/* SHORTLIS(t).H, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: ShortList

   A simple short list of strings, which can be initialised,
   strings can be added but NOT deleted.

   95-03-24  created
   95-12-08  converted to C++
   96-08-16  checked
*/

#ifndef SHORTLIS_H
#define SHORTLIS_H

#include "definiti.h"
#include "pointeri.h"
#include "myinput.h"

class ShortList
{
public:
    ShortList(void);
    ~ShortList();

    void clear (void);

    void set (const char *);
    void setFixedPosString(
        const MyFixedPosInputString &, int pPos, int pMaxLength);
    void insert (const char *);
    void insert (const PointerIntoInputString &);
    // set / insert zero or one element, or a comma-delimited number
    // of elements.
    // Zero elements if:
    // p == 0, or
    // p is an empty string

    bool contains           (const char *) const;
    // See if the parameter is in the ShortList.
    // A field matches if (in case the parameter is "XX"):
    // "XX" "XX)anything" "XX(anything" "XX+anything" "XX?anything"
    // This is for matching creators and heroes (!)

    int  numberOfElements   (void) const;
    bool empty              (void) const;

    // next two are not const; they change the internals (for speed reasons)
    const char * element         (int pIndex);
    const char * delimitedString (void);

    void concat             (ShortList & pFrom);

private:
    void makeCommaSeparated (void); // needed for delimitedString()
    void makeNullSeparated  (void); // needed for element()

    char * aBuffer;
    char * aBufferEnd;
    bool aCommaSeparated;
};

#endif
