/* SORTORDE(r).H, (c) Harry Fluks 1996

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Some definitions that are related to the type of 'sort' we use. A 'sort'
   on Unix may have a different effect from a 'sort' on Dos.

   Also, some file names of the temporary files we use in the sorting process

   97-01-09  created
*/

#ifndef SORTORDE_H
#define SORTORDE_H

#include <string.h>

class SortOrder
{
public:
#define SortOrderLastChar '{'
    // don't know how to put this properly in C++...

    inline static int strcmp(const char *, const char *);
    inline static int strncmp(const char *, const char *, size_t);
};


inline int SortOrder::strcmp(const char * s1, const char * s2)
{
#ifdef ONHARRYSPC
    // the sort on "my" PC is case insensitive
    return ::stricmp(s1, s2);
#else
    return ::strcmp(s1, s2);
#endif
}


inline int SortOrder::strncmp(const char * s1, const char * s2, size_t maxlen)
{
#ifdef ONHARRYSPC
    return ::strnicmp(s1, s2, maxlen);
#else
    return ::strncmp(s1, s2, maxlen);
#endif
}


#define cStep1Extension ("ut1")
#define cStep2Extension ("ut2")
#define cStep3Extension ("ut3")
#define cStep4Extension ("ine")
#define cUnsolvedFileName ("unsolved")

#endif
