/* STOGACOV.H, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: StoGaCov

   STOries, GAgs or COVers (or oils). A selection the user can make
   by putting a character on the command line.

   96-08-11  created (from selected.h)
   96-08-11  checked
*/

#ifndef STOGACOV_H
#define STOGACOV_H

#include "entry.h"

class StoGaCov
{
public:
    StoGaCov(char p);
    ~StoGaCov() { }

    bool match(const Entry &) const;
    const char * extension(void) const;
    const char * text(void) const;
private:
    bool stories    (void) const { return aChar == 's'; }
    bool gags       (void) const { return aChar == 'g'; }
    bool covers     (void) const { return aChar == 'c'; }
    bool oils       (void) const { return aChar == 'o'; }
    bool everything (void) const { return aChar == 'e'; }

    char aChar;
};

#endif