/* STOGACOV.CC, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   96-08-11  created
*/

#include "stogacov.h"


StoGaCov::StoGaCov(char p)
{
    switch(p)
    {
    case 's':
    case 'g':
    case 'c':
    case 'o':
         aChar = p;
         break;
    default:
         aChar = 'e';
    }
}


const char * StoGaCov::extension(void) const
{
    switch (aChar)
    {
    case 's': return "story-index";
    case 'g': return "gag-index";
    case 'c': return "cover-index";
    case 'o': return "oil-index";
    default: return "index";
    }
}


const char * StoGaCov::text(void) const
{
    switch (aChar)
    {
    case 's': return "stories";
    case 'g': return "gags";
    case 'c': return "covers";
    case 'o': return "oil paintings";
    default: return "work";
    }
}


bool StoGaCov::match(const Entry & pEntry) const
{
    if (!everything())
    {
        if (pEntry.sPageLayout.isCoverOrSo() != covers())
        {
            return FALSE;
        }

        if (pEntry.sPageLayout.isPainting() != oils())
        {
            return FALSE;
        }

        if (  (  pEntry.sPages.onePageOrLess()
              && (!covers())
              && (!oils())
              )
              !=
              (gags())
           )
        {
            return FALSE;
        }
    }
    return TRUE;
}
