/* WEBENTRY.H, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: WebEntry

   A wrapper around 'ExternalEntry' with functions to write the
   Entry to a WWW page

   96-08-22  created
*/

#ifndef WEBENTRY_H
#define WEBENTRY_H

#include "internal.h"
#include "myoutput.h"
class PersonLegend;

class WebEntry
{
public:
    static void putWeb(
        InternalEntry &,
        MyExternalOutputFile &,
        const CountrySet &,
        PersonLegend *);

    static void printShortListFullNames(
        InternalEntry &,
        MyExternalOutputFile &,
        ShortListFieldIndex,
        PersonLegend *);

    static void printReprintFullNames(
        InternalEntry &,
        MyExternalOutputFile &,
        CountryIndex,
        PersonLegend *);

private:
    static void putLinkedStoryCode(
        EntryOrStoryCode &,
        MyExternalOutputFile &);
};

#endif
