/* WEBENTRY.CC, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   96-08-22  created
*/

#include <assert.h>
#include <string.h>
#include "webentry.h"
#include "personle.h"

void WebEntry::putWeb(
    InternalEntry & pEntry,
    MyExternalOutputFile & pFile,
    const CountrySet & pReprintCountrySet,
    PersonLegend * pPersonLegend)
{
    // not fully tested - it's sufficient for the current
    // Rosa and Van Horn web pages on www.pi.net/~fluks4/dcd.htm

    if (pEntry.country() != eStoryCountry)
    {
        pFile.putS("in ");
        ENTRYCODEtype lBuffer;
        pFile.putS(pEntry.cleanedEntryCode(lBuffer));
        pFile.putS(": ");
    }
    putLinkedStoryCode(pEntry.sStoryCode, pFile);

    pFile.putS("   <b><font size=+2>");
    // first, the hero(es)
    if (! pEntry.field(eHero).empty())
    {
        printShortListFullNames(pEntry, pFile, eHero, pPersonLegend);
        pFile.putS(" ");
    }

    if (pEntry.title().empty())
    {
        pFile.putS("</b></font>");
    }
    else
    {
        pFile.putS(" &quot;");
        pFile.putS(pEntry.title());
        pFile.putS("&quot; </b></font>");
        if (! pEntry.sTitlePrefix.isRealTitle())
        {
            pFile.putS(" <i>(");
            pFile.putS(pEntry.sTitlePrefix.explanation());
            pFile.putS(")</i>");
        }
    }

    if (pEntry.sPages.empty())
    {
    }
    else if (pEntry.sPages.onePageOrLess())
    {
        pFile.printF(" %s page", pEntry.sPages.theString());
    }
    else
    {
        pFile.printF(" %s pages", pEntry.sPages.theString());
    }
    if (! pEntry.sPageLayout.isDefault())
    {
        pFile.printF(" (%s)", pEntry.sPageLayout.explanation());
    }


    if (!pEntry.comment().empty())
    {
        pFile.printLine();
        pFile.printF("%s", pEntry.comment().element());
    }

    bool lFirst = TRUE;
    ShortListFieldIndex s;
    while (s.next())
    {
        if (! pEntry.field(s).empty())
        {
            switch (s.number())
            {
            case ePlotter: case eWriter: case eArtist: case eInker:
                if (lFirst)
                {
                    pFile.printLine();
                    lFirst = FALSE;
                }
                else
                {
                    pFile.printF(",  ");
                }
                pFile.printF("<i>%s</i>: ", s.explanation());
                printShortListFullNames(pEntry, pFile, s, pPersonLegend);
                break;
            }
        }
    }

    lFirst = TRUE;
    ShortListFieldIndex s2;
    while (s2.next())
    {
        if (! pEntry.field(s2).empty())
        {
            switch (s2.number())
            {
            case ePlotter: case eWriter: case eArtist: case eInker:
            case eHero:
                break;
            default:
                if (lFirst)
                {
                    lFirst = FALSE;
                }
                pFile.printLine();
                pFile.printF("<i>%s</i>: ", s2.explanation());
                printShortListFullNames(pEntry, pFile, s2, pPersonLegend);
                break;
            }
        }
    }

    CountryIndex ci;
    lFirst = TRUE;
    while (ci.next())
    {
        if (pReprintCountrySet.includes(ci))
        {
            if (! pEntry.reprint(ci).empty())
            {
                if (lFirst)
                {
                    pFile.printLine();
                    pFile.printF("<b>Publications:</b>");
                    lFirst = FALSE;
                }
                pFile.printLine();
                printReprintFullNames(pEntry, pFile, ci, pPersonLegend);
            }
        }
    }

    pFile.printF("</font><hr>\n");
}


void WebEntry::printShortListFullNames(
    InternalEntry & pEntry,
    MyExternalOutputFile & pFile,
    ShortListFieldIndex pIndex,
    PersonLegend * pPersonLegend)
{
    int lNumber = pEntry.field(pIndex).numberOfElements();
    for (int i = 0; i < lNumber; i++)
    {
        const char * lElement = pEntry.field(pIndex).element(i);
        if (i != 0)
        {
            pFile.putS(", ");
        }
        const char * lPerson =
            pPersonLegend->find(lElement,
                                (ShortListFieldEnum) pIndex.number(),
                                TRUE); // pInLatin1
        if (lPerson == 0)
        {
            pFile.putS(lElement);
        }
        else
        {
            pFile.putS(lPerson);
        }
    }
}


void WebEntry::printReprintFullNames(
    InternalEntry & pEntry,
    MyExternalOutputFile & pFile,
    CountryIndex pCountry,
    PersonLegend * pPersonLegend)
{
    // precondition: the reprint list is not empty

    pFile.printF("<b>%s:</b>  ", pCountry.name());

    int lNumber = pEntry.reprint(pCountry).numberOfElements();
    for (int i = 0; i < lNumber; i++)
    {
        const char * lElement = pEntry.reprint(pCountry).element(i);
        if (i != 0)
        {
            pFile.putS(", ");
        }

        const char * lSeries =
            pPersonLegend->find(lElement, pCountry);

        if (lSeries == 0)
        {
            pFile.putS(lElement);
        }
        else
        {
            pFile.putS(lSeries);
        }
    }
}


void WebEntry::putLinkedStoryCode(
    EntryOrStoryCode & pStoryCode,
    MyExternalOutputFile & pFile)
{
    pFile.putS(pStoryCode); // no link to anywhere else at the moment!
}
