;		DLV1.CMD
;	      ============
;
;	Command file to deliver Package 1
;	Package 1 :	RTL/2 compiler for RSX-11M/11M+ with Symbolic Debug.
;	Version  :	10.0
;
;	You should be logged into a privileged account. 
;
;
.enable substitution
.enable global
.disable lowercase
.;
.ask OK Is it OK to continue
.iff OK .exit
;
; The delivery sequence requires PIP,MAC,TKB,LBR
;
.doins:
.sets nins ""
.ifnins ...PIP .sets nins nins+"PIP "
.ifnins ...TKB .sets nins nins+"TKB "
.ifnins ...MAC .sets nins nins+"MAC "
.ifnins ...LBR .sets nins nins+"LBR"
.if nins eq "" .goto insok
;
;	The following utilities should be installed:  'nins'
;
.pause
.goto doins	.;	Check user has done it properly!
.;
.insok:
.gosub setcli
;
;		The delivery consists of the following steps:
;
;	(1) Build the utilities
;	(2) Build the control routines.
;	(3) Transfer built utilities and run-time software to your 
;	    appointed "RTL/2" library directory
.;
.;	Get required info from user.
.;
.userin:
.again:
;
;	Before we can proceed further, we need to know the device and
;	User Directory name/UIC where the package software has been placed.
;	You should have FULL ACCESS to this directory.
;
.idev1:
.asks DEV Name of device holding the delivered software (DDn:)
.gosub chkdev
.iff devok .goto idev1
.sets indev DEV
;
.ift isdcl .sets dflt <direct>
.iff isdcl .sets dflt <uic>
.getuic:
.asks [::dflt] UDIR Enter the name/UIC of the delivery directory 
.gosub chkuic
.iff udirok .goto getuic
.sets indir1 UDIR
.sets indir2 UDIR
.sets indir3 UDIR
.sets indir4 UDIR
.;
.;	Finished getting delivery information 
.;
.gotinf:
;
.ask DBG Do you want the Symbolic Debugger delivered
;
;
;	We recommend that you keep your commonly-used RTL/2 software in 
;	an "RTL/2 library" User Directory
;	(you should have WRITE ACCESS to this directory during this delivery).
;
.odev1:
.asks DEV Name of device on which to place the built utilities
.gosub chkdev
.iff devok .goto odev1
.sets outdev DEV
;
.uico:
.asks UDIR Name/UIC of directory to hold built utilities
.gosub chkuic
.iff udirok .goto uico
.sets outdir UDIR
;
;	To build the utilities certain information is required :-
;
.ask MPLUS Will you be running the utilities under Micro/RSX or RSX-11M+
;
.asks [::"GEN"] PART In which partition are the utilities to run
;
.sets wrkmem "DISK"
.ask WRK Should utility work files be memory-resident (default is on disk)
.ift WRK .sets wrkmem "MEM"
.;
.askfcs:
.sets fcsnam ""
.sets fcsres "LIB"
;
.ask FCS Should utilities use memory-resident FCS (default is library)
.iff FCS .goto gotfcs
.sets fcsres "MEM"
;
.sets fcsnam "FCSRES"
.ift MPLUS .and .ift FCS .asks FSL Build utilities using FCSRES or FCSFSL (RES or FSL)
.ift MPLUS .and .ift FCS .sets fcsnam "FCS"+FSL
.if fcsnam ne "FCSRES" .and .if fcsnam ne "FCSFSL" .goto askfcs
.;
.gotfcs:
;
;	To build the correct set of control routines for user programs 
;	we require certain information concerning the environment in
;	which these programs will run (which need not be the same as
;	the "host" environment in which the utilities will run).
;
.start:
.;
.ask IANDD Will the user programs run with separate I- and D- spaces
.ift IANDD .sets plusm ",rtlc12,"
.iff IANDD .sets plusm ","
;
.ask TRAP Will the user programs use the Trap handler interface
.ift TRAP .sets ztrap "rtlc13,"
.iff TRAP .sets ztrap ""
;
.ask REALS Will the user programs ever use REAL variables
.iff REALS .goto noreal
;
.ask FPP Will the user programs be run on systems with the FPP co-processor
.iff FPP .setf OLDFPP
.ift FPP ;
.ift FPP .ask OLDFPP Will the user programs need the old FPP control routines
.ift OLDFPP .sets fppold "rtlc14,"
.iff OLDFPP .sets fppold ""
.ift FPP .setf FIS
.iff FPP ;
.iff FPP .ask FIS Will the user programs be run on systems with FIS
.ift FIS ; It is assumed that the compiler FP (FIS) option will always be used 
.;
.noreal:
.ift IANDD .sett EIS
.ift IANDD .sett EISW
.ift IANDD .goto setctr
.;
.ifndf FPP .or iff FPP .goto nofpp
; Having FPP means that EIS will also be available
.sett EIS
.sett EISW
.goto setctr
.;
.nofpp:
.ask EIS Will the user programs be run on systems with EIS
.ift EIS .ask EISW Will the compiler EI switch always be used
.;
.setctr:
.ift REALS .goto real
.; No reals used
.; 	EIS will not be used
	.iff EIS .sets contrl "1"
	.iff EIS .goto finctl
.; 	EIS will be used
	.iff EISW .sets contrl "2"
	.ift EISW .sets contrl "3"
	.goto finctl
.; Reals used
.real:
.; 	EIS will not be used
	.iff EIS .sets contrl "4"
	.iff EIS .and .ift FIS .sets contrl "7"
	.iff EIS .goto finctl
.; 	EIS will be used
.; 		FPP is available => EI switch used
		.ift FPP .sets contrl "11"
		.ift FPP .goto finctl
.;	 	FPP is not available  -  
.; 		FIS available => FP option used 
		.ift FIS .and .ift EISW .sets contrl "9"
		.ift FIS .and .iff EISW .sets contrl "8"
.; 		FIS not available => FP option not used 
.;		i.e. should always use FP option if FIS available
		.iff FIS .and .ift EISW .sets contrl "6"
		.iff FIS .and .iff EISW .sets contrl "5"
.finctl:
;
;	The information you have supplied will now be displayed on the screen.
;	If it is not correct, type NO and re-enter the data from the start.
.;
.open p1log.dat
.data Package 1 delivery '<date>' '<time>'
.data  
.data RTL/2 delivery location is 'indev''indir1'
.data RTL/2 library  location is 'outdev''outdir'
.ift DBG .data The Symbolic Debugger utility is to be installed
.iff DBG .data The Symbolic Debugger utility is not to be installed
.data  
.ift MPLUS .data Utilities will be run in separate I- & D- spaces
.iff MPLUS .data Utilities will not be run in separate I- & D- spaces
.data Utilities will be run in task partition 'part'
.iff WRK .data Utilities will not use memory-resident workfile
.ift WRK .data Utilities will use memory-resident workfile
.iff FCS .data Utilities will not be built with memory-resident FCS
.ift FCS .data Utilities will be built with memory-resident FCS ('fcsnam')
.data  
.ift IANDD .data User programs will be run in separate I- & D- spaces
.iff IANDD .data User programs will not be run in separate I- & D- spaces
.ift TRAP .data User programs will use the Control Routine Trap handler
.iff TRAP .data User programs will not use the Control Routine Trap handler
.ift EIS .data EIS is available for user programs
.iff EIS .data EIS is not available for user programs
.ift REALS .data User programs may use REALs
.iff REALS .data User programs will not use REALs
.iff REALS .goto norls
.ift FPP .data FPP is available for user programs
.iff FPP .data FPP is not available for user programs
.ift FPP .goto norls
.ift FIS .data FIS is available for user programs
.iff FIS .data FIS is not available for user programs
.norls:
.data  
.close #0
.;
type p1log.dat
.;
.enable control-z
.ask OK Is the above information correct (ctl-Z to quit)
.ift <eof> .goto usrend
.disable control-z
.iff OK .goto again
;
;  There are no more questions - the various utilities will now be
;  be built and the package files set up in the nominated directories
;
.opena p1log.dat
.;
;	Set current device and directory
;
.ift vax .sets setdir "set def "+indev
.ift vax .goto stdr
.ift isdcl assign 'indev' sy
.iff isdcl asn 'indev'=sy:
.ift isdcl .sets setdir "set def "
.iff isdcl .sets setdir "set /uic="
.stdr:
'setdir''indir1'
.;
;		     Implement any package updates
;		     =============================
.testfile upd1.cmd
.if <filerr> ne 1 .goto notfnd 	.; filerr ne 1 => file not found.
@upd1
.;
.; The task-build command files need to know if building to run in I- & D- Space
.;
.sets idspce "M"
.ift MPLUS .sets idspce "MPLUS"
;
;	To build the compiler - use the command file RTLBLD.CMD.
;	========================================================
;
.testfile rtlbld.cmd
.if <filerr> ne 1 .goto notfnd 	.; filerr ne 1 => file not found.
@rtlbld 'part' 'wrkmem' 'fcsres' 'idspce' 'fcsnam'
.if <exstat> lt 2 .goto cmpok
;
;	Note - compiler build failed.  DLV1 aborted.  
;	Please find out what went wrong and try again.
;
.data #0 RTL/2 compiler build failed.  DLV1 aborted.
.close #0
.exit
.;
.cmpok:
.if <exstat> eq 0 .data #0 Compiler built with diagnostics.
.if <exstat> eq 1 .data #0 RTL/2 compiler built OK.
.setn generr 0
;
;	To build the linkage verifier - use command file RLVBLD.CMD
;	===========================================================
;
.testfile rlvbld.cmd
.if <filerr> ne 1 .goto notfnd 	.; filerr ne 1 => file not found.
@rlvbld 'part' 'fcsres' 'idspce' 'fcsnam'
.if <exstat> gt 1 .setn generr 1
.if generr eq 0 .goto lvok
;
;	Warning - the Linkage Verifier has failed to build correctly.
;	Please investigate after this delivery command file has run.
;	You can rebuild the Linkage Verifier by invoking RLVBLD.CMD again.
;
.data #0 RTL/2 linkage verifier build failed
.lvok:
.if generr eq 0 .data #0 RTL/2 Linkage verifier built OK
;
;	To build the Macro Processor - use command file RMPBLD.CMD
;	==========================================================
;
.setn generr 0
.testfile rmpbld.cmd
.if <filerr> ne 1 .goto notfnd 	.; filerr ne 1 => file not found.
@rmpbld 'part' 'wrkmem' 'fcsres' 'idspce' 'fcsnam'
.if <exstat> gt 1 .setn generr 1
.if generr eq 0 .goto mpok
;
;	Warning - the Macro Processor has failed to build correctly.
;	Please investigate after this delivery command file has run.
;	You can rebuild the Macro Processor by invoking RMPBLD.CMD again.
;
.data #0 RTL/2 Macro preprocessor build failed
.mpok:
.if generr eq 0 .data #0 RTL/2 macro preprocessor built OK
.;
.iff dbg .goto nodbg
'setdir''indir4'
;
;	To build the Symbolic Debugger - use command file HSTBLD.CMD
;	============================================================
;
.testfile hstbld.cmd
.if <filerr> ne 1 .goto notfnd 	.; filerr ne 1 => file not found.
@hstbld 'indir1' 'part' 'fcsres' 'idspce' 'fcsnam'
.if <exstat> lt 2 .goto hostok
;
;	Warning - the HOST Debugger failed to build correctly.
;	Please investigate after this delivery command file has run.
;	You can rebuild the Symbolic Debugger by invoking HSTBLD.CMD again.
;
.data #0 Symbolic Debugger build failed.
.hostok:
.if <exstat> eq 0 .data #0 Symbolic Debugger built with diagnostics.
.if <exstat> eq 1 .data #0 Symbolic Debugger built OK.
.;
.nodbg:
.;
;
;	Now transfer newly-built RTL/2 utilities to your library UIC
;
.gosub trans 'indir1' rtl2.tsk delete
.gosub trans 'indir1' rmp.tsk delete
.gosub trans 'indir1' rtlv.tsk delete
.ift dbg .gosub trans 'indir4' host.tsk delete
;
;	Having built the utilities we can now generate the control routines
;	according to the user supplied information.
;
'setdir''indir2'
;
;
;			CONTROL ROUTINES
;		     ======================
;
;	To build the control routines we invoke RTLCTL.CMD
;
.testfile rtlctl.cmd
.if <filerr> ne 1 .goto notfnd 	.; filerr ne 1 => file not found.
@rtlctl 'contrl' 'plusm' 'ztrap' 'fppold'
.if <exstat> eq 1 .data #0 Control routines built OK
.if <exstat> eq 1 .goto ctrok
;
;	Warning - the control routines failed to build.
;
.data #0 The control routines failed to build.
.ctrok:
;
;    NOTE:-	The run-time software (executive interface, formatted I/O,
;		stream I/O and maths routines) is supplied in object form 
;		in the libraries RTLEXC.OLB, RTLRTSRSX.OLB, RSXIO.OLB and
;		MTHLIBRSX.OLB. The appropriate command files are supplied 
;		if the user wishes to rebuild any of these. This can be 
;		done in the second delivery location or the library uic.
;
;			EXECUTIVE INTERFACE
;		     =========================
;
;		The executive interface library can be rebuilt by running
;		EXCBLD.CMD - found in SOURCERSX.ULB along with the necessary 
;		source modules. This library will be transferred to the library
;		uic.
;
;
;			FORMATTED I/O
;		     ===================
;
;		The formatted I/O can be rebuilt by running SLRBLD.CMD
;		- found in SOURCERSX.ULB along with the necessary source
;		modules. This library will be transferred to the library uic.
;
;
;			STREAM I/O ROUTINES
;		     =========================
;
;		The stream I/O library can be rebuilt by running RSXIOBLD.CMD
;		- found in SOURCERSX.ULB along with the necessary source 
;		modules. This library will be transferred to the library uic.
;
;
;			MATHS PACKAGE
;		     ===================
;
;		The maths library can be rebuilt by running MATHSBLD.CMD 
;		- found in SOURCERSX.ULB along with the necessary source 
;		modules. This library will be transferred to the library uic.
;
;
;  		The sources of the base program and a command file (BASE.CMD)
;		are also supplied in the library SOURCERSX.ULB to enable the 
;		user to	rebuild these if required.
;
;
;	NB:	All of the above can be rebuilt using the single command
;		file BUILDRTS.CMD
;
;
;	Now we transfer the runtime software to your RTL/2 library uic
;
.gosub trans 'indir1' rtlexc.olb
.;
.gosub trans 'indir1' rsxio.olb
.;
.gosub trans 'indir2' mthlibrsx.olb delete
.gosub trans 'indir2' mthlibrsx.nlb delete
.;
.gosub trans 'indir1' rtlrtsrsx.olb
.;
.gosub trans 'indir2' rtlctl.obj delete
.;
.gosub trans 'indir2' sourcersx.ulb delete
.;
.gosub trans 'indir2' buildrts.cmd delete
.;
.gosub trans 'indir2' rtlctl.cmd delete
.;
.iff dbg .goto demo
'setdir''indir4'
.;
.; Run-time software for Debugger needs to be unpacked first
.;
.testfile dbglibrsx.olb
.if <filerr> ne 1 .goto notfnd 	.; filerr ne 1 => file not found.
lbr debba1.obj=dbglibrsx/ex:rsxba1
lbr debba2.obj=dbglibrsx/ex:rsxba2
lbr monit.obj=dbglibrsx/ex:magic
.;
.testfile dbgrsxsrc.ulb
.if <filerr> ne 1 .goto notfnd 	.; filerr ne 1 => file not found.
lbr offset.svc=dbgrsxsrc.ulb/ex:offset
.;
.gosub trans 'indir4' debba1.obj
.;
.gosub trans 'indir4' debba2.obj
.;
.gosub trans 'indir4' monit.obj
.;
.gosub trans 'indir4' offset.svc
;
;
.demo:
'setdir''indir3'
.sets ifdbg "NODBG"
.ift dbg .sets ifdbg "DBG"
.testfile demunpack.cmd
.if <filerr> ne 1 .goto notfnd 	.; filerr ne 1 => file not found.
@demunpack 'ifdbg' 'outdev''outdir'
'setdir''indir1'
;
;
;	The formal delivery is now complete.
;	Please check the log file to confirm all the utilities have built ok.
;
;	You are now ready to try some of the demonstration programs 
;	in 'indir3'
;
;	For example,to run LEARN:
;	(1) Set your UIC to 'indir3'
;	(2) Refer to Ref 63 appendix C for guidance
;	(3) Make sure that DEMETC.CMD points to the right UIC
;	(4) Type @LEARN to build the demonstration
;
;	
;	Please install the compiler as RTL before running
;	any of the demonstration programs.
;
.finish:
.data #0 DLV1 finished properly.
.close #0
'rstcli'
.exit
;
;	Abandon this command file
;
.usrend:
.opena p1log.dat
.data #0 DLV1 abandoned by user
.close #0
'rstcli'
.exit
.;
.;	Subroutines.
.;
.; Subroutine to copy a file to the RTL/2 library directory
.;
.trans:
.parse comman " " dirnam filnam delflg
pip 'outdev''outdir'/nv='indev''dirnam''filnam'
.if <exstat> ne 1 .goto ertran
.if delflg ne "" pip 'indev''dirnam''filnam';0/de
.return
.;
.ertran:
;
;	Error transferring 'filnam' to RTL/2 library directory
;
.data #0 Failed to transfer 'filnam' to RTL/2 library directory 
.return
.;
.; Subroutine to validate a device name.
.;
.chkdev:
.sett devok
.test DEV
.setn len <strlen>
.sets last DEV['len':'len']
.if last ne ":" .sets DEV DEV+":"
.testdevice 'DEV'
.if <exstri> eq "NSD," .goto badd
.sets devdrv DEV[1:2]
.ifloa 'devdrv': .return
.badd:
;
;	Unable to find any loaded device called 'DEV' - please try again.
;
.setf devok
.return
.;
.; Subroutine to validate a User Directory.
.;
.chkuic:
.sett udirok
.test UDIR
.setn len <strlen>
.sets first UDIR[1:1]
.sets last UDIR['len':'len']
.if first ne "[" .setf udirok
.if last ne "]" .setf udirok
.ift udirok .return
;
;	'udir' is an invalid User Directory name/UIC; please try again
;
.return
.;
.notfnd:	
;	ERROR	  - 	file not found in current directory.
;	Please check your input UICs, and then re-invoke DLV1.CMD.
.exit
.;
.; Determine current CLI; set it to DCL if possible
.; Also check if running on a VAX
.;
.setcli:
.sett isdcl
.sets rstcli ";"
.sets oldcli "'<cli>'"
.setf vax
.if <system> eq 5 .sett vax
.if oldcli eq "DCL" .or .ift vax .return
.if oldcli ne "MCR" .goto lsc1
.ifnins dcl .setf isdcl
.iff isdcl .return
.sets rstcli "mcr set /mcr=ti:"
.lsc1:
dcl set /dcl
.if rstcli eq ";" .sets rstcli "set term/cli:"+oldcli
.return
