/* tpc.c - (c) 2014 by Johnny Billquist */

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/mtio.h>
#include <sys/ioctl.h>

#include "block.h"

void usage(char *cmd)
{
  fprintf(stderr,"usage: %s <infile> <outfile>\n", cmd);
  exit(1);
}

main(argc,argv)
int argc;
char **argv;
{
  FILE *ofp, *ifp;
  char *cmd, *ifile=NULL, *ofile=NULL;
  int bc, bl, c, p, done, obl, b, imode=0, omode=0;

  fprintf(stderr, "tape copy/convert\n");

  cmd = *argv++;
  while (--argc) {
    if (argv[0][0] == '-') {
      if (argv[0][1] == '2') {
	if (!ifile) imode = 2;
	else omode = 2;
      }
      if (argv[0][1] == '4') {
	if (!ifile) imode = 4;
	else omode = 4;
      }
    } else if (!ifile) ifile = *argv;
    else if (!ofile) ofile = *argv;
    else usage(cmd);
    argv++;
  }

  if ((ofp = fopen(ofile, "w")) == NULL) {
    fprintf(stderr,"Output file error.\n");
    exit(1);
  }

  if ((ifp = fopen(ifile, "r")) == NULL) {
    fprintf(stderr,"Input file error.\n");
    exit(1);
  }

  if (imode == 0) imode = detect(ifp);
  if (imode < 2) {
    fprintf(stderr, "Unknown mode for input file\n");
    exit(1);
  }
  if (omode == 0) {
    omode = 2;
    fprintf(stderr,"No output mode specified. Assuming 2\n");
  }

  done = 0;
  obl = -1;
  while (!done) {
    bl = readblk(ifp, imode);
    writeblk(ofp, bl, omode);
    if (bl <= 0 && obl <= 0)
      done = -1;
    obl = bl;
    bc++;
  }
  printf("eof\n");
  fclose(ofp);
  fclose(ifp);
}
