/* tpr.c - (c) 2014 by Johnny Billquist */
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/mtio.h>
#include <sys/ioctl.h>

#include "block.h"

void usage(char *cmd)
{
  fprintf(stderr,"usage: %s <file> <tape>\n", cmd);
  exit(1);
}

main(argc,argv)
int argc;
char **argv;
{
  FILE *ofp;
  char *file=NULL, *tapenam=NULL, *cmd;
  int mode=0;
  int tape, bc, bl, c, p, done, obl;

  fprintf(stderr, "tape reader\n");

  cmd = *argv++;
  while (--argc) {
    if (argv[0][0] == '-') {
      if (argv[0][1] == '2') mode = 2;
      if (argv[0][1] == '4') mode = 4;
    } else if (!file) file = *argv;
    else if (!tapenam) tapenam = *argv;
    else usage(cmd);
    argv++;
  }

  if (!file || !tapenam) usage(cmd);

  if (mode == 0) {
    fprintf(stderr,"No mode specified. Assuming 2\n");
    mode = 2;
  }

  if ((ofp = fopen(file, "w")) == NULL) {
    fprintf(stderr,"Output file error.\n");
    exit(1);
  }

  if ((tape = open(tapenam, O_RDONLY, 0511)) == -1) {
    fprintf(stderr,"tape not found.\n");
    exit(1);
  }

  done = 0;
  obl = -1;
  bc = 0;
  while (!done) {
    bl = read(tape, buf, BFSZ);
    if (bl == -1) perror("read");
    printf("Block %d. Length = %d\n", bc, bl);
    if (bl == 0 && obl == 0)
      done = -1;
    else {
      writeblk(ofp,bl,mode);
    }
    obl = bl;
    bc++;
  }
  printf("eof\n");
  fclose(ofp);
  close(tape);
}
