/* tpw.c - (c) 2014 by Johnny Billquist */

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/mtio.h>
#include <sys/ioctl.h>

#include "block.h"

void usage(char *cmd)
{
  fprintf(stderr,"usage: %s <file> <tape>\n", cmd);
  exit(1);
}


main(argc,argv)
int argc;
char **argv;
{
  FILE *ifp;
  char *file=NULL, *tapenam=NULL, *cmd;
  int tape, bc, bl, obl, done, c, p, mode=0;
  struct mtop meof;

  fprintf(stderr, "tape writer\n");

  cmd = *argv++;
  while (--argc) {
    if (argv[0][0] == '-') {
      if (argv[0][1] == '2') mode = 2;
      if (argv[0][1] == '4') mode = 4;
    } else if (!file) file = *argv;
    else if (!tapenam) tapenam = *argv;
    else usage(cmd);
    argv++;
  }

  if (!file || !tapenam) usage(cmd);

  if ((ifp = fopen(file, "r")) == NULL) {
    fprintf(stderr,"Input file not found.\n");
    exit(1);
  }

  if ((tape = open(tapenam, O_WRONLY, 511)) == -1) {
    fprintf(stderr,"tape not found.\n");
    exit(1);
  }

  meof.mt_op = MTWEOF;
  meof.mt_count = 1;

  if (mode == 0) mode = detect(ifp);
  if (mode < 2) {
    fprintf(stderr, "Unknown mode for input file\n");
    exit(1);
  }

  bc = 0;
  obl = -1;
  done = 0;
  while (!done) {
    bl = readblk(ifp, mode);
    printf("Block %d. Length = %d\n", bc, bl);
    bc++;
    if (bl > 0) {
      c = write(tape, buf, bl);
    } else {
      ioctl(tape, MTIOCTOP, &meof);
    }
    if ((obl == 0) && (bl = 0)) done = 1;
    if (feof(ifp)) done = 1;
    obl = bl;
  }
  ioctl(tape, MTIOCTOP, &meof);
  fclose(ifp);
  close(tape);
}
