	.TITLE	KERINT
	.VERSION 1
	.SBTTL	Header
/ ++
/
/	KERINT	X1F
/
/	(c) 1988, 1989, 1990, 1991 by Johnny Billquist
/
/	Kermit for pdp8.
/	KERINT is the interrupt driver.
/
/	Id	Programmer
/	BQT	Johnny Billquist
/
/	Ver	Date		By	Comments
/	X1A	88/12/20 17:30	BQT	Split part from KERMIT X1A.
/	X1B	89/12/20  9:30	BQT	Modified to be CLOCK type independ.
/	X1C	90/03/04 19:00	BQT	Added timeout ability from kbd.
/	X1D	90/03/12 22:00	BQT	Added full XON/XOFF support.
/	X1E	91/05/10 04:10	BQT	Added BINMSK.
/	X1F	91/06/01 02:30	BQT	Added PARITY.
/
/ --
	.SBTTL	Setup
	.INCLUDE	SYS:COMMON
/
	.GLOBAL		R1,R2,T1,T2,T3,T4,T5
	.GLOBAL		CCFLAG,CLKTYP
	.ENTRY		CLKON,CLKOFF,SETTMR,CHKTMR,ENINT
	.ENTRY		PUTM,GETM,FLUSHM
	.ENTRY		PUT,TGET,FLUSH,TWAIT
	.ENTRY		PUTD2,PUTO2
	.GLOBAL		CLKTMR
                                                                                                                                                                                                                                                                                                                                                        
	SPI=6045
	KSFM=6311
	KIEM=6315
	KRBM=6316
	TFLM=6320
	TSFM=6321
	TCFM=6322
	SPIM=6325
	TLSM=6326

	.MACRO	.ERRPR	TEXT
	JMS	INTPR
	TEXT
	.ENDM

	FIXTAB
	.SBTTL	Zero page

	.ASECT	INT
	FIELD	0
	*0
RET,
PC,	0
	DCA	AC
	GTF
	DCA	FLG
	MQA
	DCA	MQ
	JMP I	INTPTR
INTPTR,	INTENT

	.XSECT	IXREG
	FIELD	0
X0,	0

	.ZSECT	IZPAGE
	FIELD	0

INTEXT,	SRQ
	SKP
	JMP I	INTPTR
	CLA
	TAD	MQ
	MQL
	TAD	FLG
	RTF
	CLA
	TAD	AC
	JMP I	RET
/
AC,	0
FLG,	0
MQ,	0
/
TMP,	0
PTR,	0
/
	.GLOBAL	BINMSK,PARITY
BINMSK,	177
PARITY,	200			/200 = MARK, 400 = SPACE, 0 = NONE.
/
MOFLG,	0
MOCNT,	0
MOWPTR,	MOBUF+1
MORPTR,	MOBUF
	.GLOBAL	MOXOFF
MOXOFF,	0
MICNT,	0
MIWPTR,	MIBUF+1
MIRPTR,	MIBUF
MIXOFF,	0
TOFLG,	0
TOCNT,	0
TOWPTR,	TOBUF+1
TORPTR,	TOBUF
TOXOFF,	0
TICNT,	0
TIWPTR,	TIBUF+1
TIRPTR,	TIBUF
TIXOFF,	0
CCFLAG,	0
CLKTYP,	0
/
TICK,	-^D100
CTICK,	-^D100
CLKTMR,	0
CLKFLG,	0
/
	.SBTTL	Interrupt handler

	.RSECT	INTSRV
	FIELD	0
/
/ INTERRUPT ENTRY. HERE WE DECIDE WHAT MADE THE INTERRUPT.
/
INTENT,	SPI			/WAS IT TTY?
	SKP
	JMP	TTYINT		/YES.
T1,	SPIM			/NO. MODEM?
	SKP
	JMP	MDMINT		/YES.
	JMS	CLKSKP		/NO. CLOCK?
	SKP
	JMP	CLKINT		/YES.
	TAD	PC		/Check if address has changed...
	TAD	LI$
	SNA CLA
	JMP	1$		/Has not. Fatal error.
	TAD	PC		/Has. Save new last_address.
	CIA
	DCA	LI$
	CAF			/NO. CLEAR ALL FLAGS.
	JMS	ENINT
/	6103			/Common 8/a problem: Power fail flag.
	JMP	INTEXT		/TRY TO CONTINUE.

1$:	.ERRPR	FATAL
	.EXIT

LI$:	0
/
ENINT,	0			/Enable interrupt routine.
	CLA			/Get calling field.
	RDF
	TAD	(CDF CIF)
	DCA	R$
	CDF	.

	IAC			/ac11=1.
	KIE			/Enable interrupt on TTY.
R1:	KIEM			/Enable interrupt on modem.
	JMS	CLKON		/Enable clock.
R$:	HLT			/Return.
	JMP I	ENINT
/
	.SBTTL	TTY non-interrupt handler.
/
/ PRINT WITHOUT INTERRUPT.
/ THIS ROUTINE PRINTS A TEXT WITHOUT THE INTERRUPT
/ ROUTINES. ON ENTRY, INTERRUPT MUST BE OFF. ON EXIT,
/ INTERRUPT WILL BE OFF AS WELL.
/
INTPR,	0			/PRINT WITHOUT INTERRUPT.
	CLA			/CHECK WETHER WE SHALL TURN INTERRUPT ON
	TAD	TOFLG		/CHECK IF WE HAVE TO SET TRANSMIT FLAG.
	SNA CLA
	TFL			/WE HAVE TO.
	CMA			/GET STRING POINTER.
	TAD I	INTPR
	DCA	X0
	ISZ	INTPR
2$:	TAD I	X0		/GET CHAR.
	SNA			/END OF STRING?
	JMP I	INTPR		/RETURN.
	JMS	IPUT		/NO. OUTPUT CHAR.
	JMP	2$		/REPEAT.
/
IPUT,	0			/OUTPUT A SINGLE CHAR. NON-INTERRUPT.
	TSF			/TRANSMIT DONE?
	JMP	.-1		/NO. WAIT.
	TLS			/YES. OUTPUT CHAR.
	CLA			/CLEAR AC.
	JMP I	IPUT		/RETURN.
/
	.SBTTL	Interrupt translator subroutine.

ITRN,	0			/Return address.
	CIA			/Negate word to find.
	DCA	TMP$
	TAD I	ITRN
	ISZ	ITRN
	DCA	PT$		/Save pointer.
LOOP$:	TAD I	PT$
	ISZ	PT$
	SNA
	JMP I	ITRN
	TAD	TMP$
	SNA CLA
	JMP	FND$
	ISZ	PT$
	JMP	LOOP$

FND$:	TAD I	PT$
	ISZ	ITRN
	JMP I	ITRN

TMP$:	0
PT$:	0
/
	PAGE
	.SBTTL	Text data

	.RADIX	10

FATAL,	TEXT	<10>%Fatal unknown interrupt. Kermit aborted.%<7><13><10>
/
	.RADIX	8
/
	.SBTTL	Clock tables.

CONTAB,	.TABLE	LEN$
	DK8EA;CLKON\DK8EA
	DK8EC;CLKON\DK8EC
	DK8EP;CLKON\DK8EP
	DKC8A;CLKON\DKC8A
LEN$=.

COFTAB,	.TABLE	LEN$
	DK8EA;CLKOF\DK8EA
	DK8EC;CLKOF\DK8EC
	DK8EP;CLKOF\DK8EP
	DKC8A;CLKOF\DKC8A
LEN$=.

CSKTAB,	DK8EA;CLKSK\DK8EA
	DK8EC;CLKSK\DK8EC
	DK8EP;CLKSK\DK8EP
	DKC8A;CLKSK\DKC8A
	0

CCLTAB,	DK8EA;CLKCL\DK8EA
	DK8EC;CLKCL\DK8EC
	DK8EP;CLKCL\DK8EP
	DKC8A;CLKCL\DKC8A
	0

	PAGE
	.SBTTL	Clock handler

CLKINT,	JMS	CLKCLR		/CLOCK INTERRUPT. CLEAR CLOCK.
	ISZ	TICK		/Bump tick count.
	JMP	INTEXT		/Return.
	TAD	CTICK		/One second passed. Reset tick count.
	DCA	TICK
	ISZ	CLKTMR		/Bump timer.
	JMP	INTEXT		/Return.
	CMA			/Timer out! Set flag.
	DCA	CLKFLG
	JMP	INTEXT		/Return.
/
SETTMR,	0			/SET TIMER. AC=Seconds.
	IOF			/No interrupts, please.
	CIA			/-Seconds.
	DCA	CLKTMR		/Save timer count.
	TAD	CTICK		/Reset tick count.
	DCA	TICK
	ION			/Allow interrupts.
	DCA	CLKFLG		/Clear flag.
	RDF			/Return to calling field.
	TAD	(CDF CIF)
	DCA	.+1
	HLT
	JMP I	SETTMR		/Return.
/
CHKTMR,	0			/Check if timer has blown.
	CLA			/Get flag.
	TAD	CLKFLG
	SNA CLA			/If nonzero, it has.
	ISZ	CHKTMR		/If zero, we skip.
	RDF			/Get return field.
	TAD	(CDF CIF)	/Make code.
	DCA	.+1		/Save code.
	HLT			/Execute it.
	JMP I	CHKTMR		/Return.
/
CLKON,	0			/Turn clock on...
	CLA			/Start with making return code.
	RDF
	TAD	(CDF CIF)
	DCA	R2$
	CDF	.		/Change to our field.
	TAD	CLKTYP		/Get clock type.
	.TRNSLT	CONTAB		/Get appropriate routine.
	JMP	R$		/No good clock, return.
	DCA	PTR		/Save pointer.
	JMP I	PTR		/Execute routine.
R$:	CLA			/We ends up here...
R2$:	HLT
	JMP I	CLKON

CLKON\DK8EA:
CLKON\DK8EC:
	6131
	JMP	R$
CLKON\DK8EP:
	CLA CMA
	6130
	6133
	TAD	(5210+1
	6132
	JMP	R$
CLKON\DKC8A:
	CLA IAC
	6135
	JMP	R$
/
CLKOFF,	0
	CLA			/Clock off. See clock on.
	RDF
	TAD	(CDF CIF)
	DCA	R2$
	CDF	.
	TAD	CLKTYP
	.TRNSLT	COFTAB
	JMP	R$
	DCA	PTR
	JMP I	PTR
R$:	CLA
R2$:	HLT
	JMP I	CLKOFF

CLKOF\DK8EA:
CLKOF\DK8EC:
	6132
	JMP	R$

CLKOF\DK8EP:
	CLA CMA
	6130
	JMP	R$

CLKOF\DKC8A:
	6135
	JMP	R$
/
CLKSKP,	0			/Clock skip.
	CLA			/Get clock type.
	TAD	CLKTYP
	JMS	ITRN;CSKTAB	/Get routine pointer.
	JMP	R2$		/No good clock.
	DCA	PTR		/Good clock.
	JMP I	PTR		/Check if skip.
R1$:	ISZ	CLKSKP		/Jump here if skip,
R2$:	CLA			/and here if not.
	JMP I	CLKSKP		/Return.

CLKSK\DK8EA:
CLKSK\DK8EC:
	6133
	JMP	R2$
	JMP	R1$

CLKSK\DK8EP:
	6131
	JMP	R2$
	JMP	R1$

CLKSK\DKC8A:
	6137
	JMP	R2$
	JMP	R1$
/
CLKCLR,	0			/Clear clock flag.
	CLA			/Get clock type.
	TAD	CLKTYP
	JMS	ITRN;CCLTAB	/Get routine pointer.
	JMP	R$		/No good clock.
	DCA	PTR		/Good clock.
	JMP I	PTR		/Execute routine.
R$:	CLA			/Return to here.
	JMP I	CLKCLR		/Return.

CLKCL\DK8EA:
CLKCL\DK8EC:
	JMP	R$

CLKCL\DK8EP:
	6135
	JMP	R$

CLKCL\DKC8A:
	6136
	JMP	R$
/
	PAGE
	.SBTTL	Modem handler

T2,
MDMINT,	KSFM			/Modem interrupts. Was it output?
	SKP CLA			/Yes. Output.
	JMP	MDMKBD		/No. Input.
	TAD	MOXOFF		/Output. Check if we have recieved an XOFF.
	SZA CLA
	JMP	MOEND		/We have an XOFF. Turn off sending.
	CLA CMA			/AC=-1.
	TAD	MOCNT		/Get count of chars remaining.
	SPA			/No more chars?
	JMP	MOEND		/Yep. End output.
	DCA	MOCNT		/Not end. Save # remaining.
	JMS	INC;MORPTR	/Increment pointer into buffer.
	TAD I	MORPTR		/Get char.
	JMS	FIXPAR		/Fix parity.
T3,	TLSM			/Output.
	CLA CMA			/Set outputting flag.
	DCA	MOFLG
	JMP	INTEXT		/Return.

MOEND,	CLA			/Done outputting. Clear outputting flag.
	DCA	MOFLG
T4,	TCFM			/Clear hw flag.
	JMP	INTEXT		/Return.
/
R2,
MDMKBD,	KRBM			/Input interrupt. Read char.
	AND	BINMSK		/Mask superfluos bits.
	DCA I	MIWPTR		/Save it.

	TAD I	MIWPTR		/Check if XON or XOFF.
	AND	(177
	TAD	(-^"S		/First: XOFF?
	SZA
	JMP	1$		/Not XOFF...
	CMA			/Was XOFF. Turn off output.
	DCA	MOXOFF
	JMP	2$

1$:	TAD	(^"S-^"Q	/Check if XON...
	SZA CLA
	JMP	2$		/Was not.
	DCA	MOXOFF		/Clear XOFF flag.
	TAD	MOFLG		/Check if we are transmitting...
	SNA CLA
	TFLM			/Were not. Start now.
	CMA			/Set flag.
	DCA	MOFLG

2$:	ISZ	MICNT		/Bump # of chars available in buffer count.
	JMS	INC;MIWPTR	/Increment buffer pointer.
	TAD	MICNT		/Check if time for xoff.
	TAD	(-100)
	SPA CLA
	JMP	INTEXT		/Not time. Return.
	TAD	MIXOFF		/Check if we already have xoff.
	SZA CLA
	JMP	INTEXT		/Already have. Return.
	TAD	(^"S)		/Send xoff.
	JMS	PUTM2
	CMA			/Set xoff flag.
	DCA	MIXOFF
	JMP	INTEXT		/Return.
/
PUTM,	0			/Put char on output queue.
	DCA	TMP
	RDF
	TAD	(CDF CIF)
	DCA	2$
	CDF	.FLD
	TAD	TMP
	IOF
	JMS	PUTM2		/Put char.
	ION
1$:	TAD	MOCNT		/Check if buffer full.
	TAD	(-200)		/If it is, wait...
	SNA CLA
	JMP	1$
2$:	HLT
	JMP I	PUTM		/Return.
/
PUTM2,	0
	DCA I	MOWPTR		/Save char in buffer.
	ISZ	MOCNT		/Bump count.
	JMS	INC;MOWPTR	/Bump pointer.
	TAD	MOFLG		/Get active flag.
	SNA CLA			/Are output active?
T5,	TFLM			/No. Activate.
	JMP I	PUTM2
/
GETM,	0			/Get char from input queue.
	CLA			/Anything available?
	RDF
	TAD	(CDF CIF)
	DCA	2$
	CDF	.FLD
	TAD	MICNT
	SNA CLA
	JMP	2$		/No. RETURN
	ISZ	GETM		/Yes, bump return.
	IOF			/No interrupts, please.
	CLA CMA			/Decr. char count.
	TAD	MICNT
	DCA	MICNT
	ION			/Allow interrupts.
	TAD	MIXOFF		/Check if we have xoff.
	SNA CLA
	JMP	1$		/No.
	TAD	MICNT		/Check if we have buffer low.
	TAD	(-10)
	SMA CLA
	JMP	1$		/No.
	TAD	(^"Q)		/Yes. Clear xoff.
	IOF			/No interrupts.
	JMS	PUTM2
	ION			/Interrupts.
	DCA	MIXOFF
1$:	IOF
	JMS	INC;MIRPTR	/Increment pointer.
	ION
	TAD I	MIRPTR		/Get char.
2$:	HLT
	JMP I	GETM		/Return.
/
	PAGE
	.SBTTL	TTY handler
/
TTYINT,	KSF			/Input interrupt?
	SKP CLA			/No. Output.
	JMP	TTYKBD		/Yes. Input.
	TAD	TOXOFF		/Check if we have recieved an XOFF...
	SZA CLA
	JMP	TOEND$		/We have. Cut outpt.
	CLA CMA
	TAD	TOCNT		/Yes. Get buffer count.
	SPA			/Anything left?
	JMP	TOEND$		/No.
	DCA	TOCNT		/Yes. Save new left.
	JMS	INC;TORPTR	/Increment pointer.
	TAD I	TORPTR		/Get char.
	TLS			/Output it.
	CLA CMA			/Set active flag.
	DCA	TOFLG
	JMP	INTEXT		/Return.

TOEND$:	CLA
	DCA	TOFLG		/End of output. Clear active flag.
	TCF			/Clear hw flag.
	JMP	INTEXT		/Return.
/
TTYKBD,	KRB			/Input interrupt. Read char.
	DCA I	TIWPTR		/Save it.

	TAD I	TIWPTR		/Check for special characters...
	AND	(177)
	SZA			/Check if NUL.
	JMP	1$		/Was not.
	CMA			/It was NUL. Set timeout flag.
	DCA	CLKFLG
	JMP	CN$		/And continue.

1$:	TAD	(-^"C)		/Check if ^C.
	SZA
	JMP	2$		/Not ^C. Skip this...
	CMA			/It was.
	DCA	CCFLAG		/Set ^C flag.
	JMP	CN$		/And continue.

2$:	TAD	(^"C-^"S	/Check for XOFF.
	SZA
	JMP	3$		/Was not. Skip this.
	CMA			/Set output xoff flag.
	DCA	TOXOFF
	JMP	CN$

3$:	TAD	(^"S-^"Q	/Check for XON...
	SZA CLA
	JMP	CN$		/Was not. Skip this.
	DCA	TOXOFF		/Was too. Clear xoff.
	TAD	TOFLG		/Check if we are transmitting.
	SNA CLA
	TFL			/We were not. Start now.
	CMA
	DCA	TOFLG		/Set flag.

CN$:	ISZ	TICNT		/Bump buffer count.
	JMS	INC;TIWPTR	/Increment pointer.
	TAD	TICNT		/Check if buffer getting full.
	TAD	(-100)
	SPA CLA
	JMP	INTEXT		/Return.
	TAD	TIXOFF		/Check if already xoff.
	SZA CLA
	JMP	INTEXT
	TAD	(^"S)		/Send xoff.
	JMS	PUT2
	CMA
	DCA	TIXOFF
	JMP	INTEXT
/
PUT,	0			/Putchar inte output queue.
	DCA	TMP
	RDF
	TAD	(CDF CIF)
	DCA	2$
	CDF	.FLD
	TAD	TMP
	IOF			/No interrupts, please.
	JMS	PUT2
	ION			/You may interrupt me.
1$:	TAD	TOCNT		/Check if buffer full.
	TAD	(-200)		/If so, wait...
	SNA CLA
	JMP	1$
2$:	HLT
	JMP I	PUT		/Return.
/
TGET,	0			/Get char from input queue.
	CLA			/Check if anything is available.
	RDF
	TAD	(CDF CIF)
	DCA	2$
	CDF	.FLD
	TAD	TICNT
	SNA CLA
	JMP	2$		/Nope. Return.
	ISZ	TGET		/Yes. Bump return.
	IOF			/Don't interrupt me.
	CLA CMA			/Decr. count.
	TAD	TICNT
	DCA	TICNT
	ION
	TAD	TIXOFF		/Check if we have xoff.
	SNA CLA
	JMP	1$		/No.
	TAD	TICNT		/Check if buffer low.
	TAD	(-10)
	SMA CLA
	JMP	1$		/No.
	TAD	(^"Q)		/Yes. Send xon.
	IOF
	JMS	PUT2
/	ION
	DCA	TIXOFF
1$:	IOF
	JMS	INC;TIRPTR	/Incr. pointer.
	ION
	TAD I	TIRPTR		/Get char.
2$:	HLT
	JMP I	TGET		/Return.
/
	PAGE
/
PUT2,	0
	DCA I	TOWPTR		/Save char.
	ISZ	TOCNT		/Bump count.
	JMS	INC;TOWPTR	/Increment pointer.
	TAD	TOFLG		/Get active flag.
	SNA CLA			/Is output active?
	TFL			/No. Activate.
	JMP I	PUT2
	.SBTTL	Associated interrupt routines.
/
TWAIT,	0
	CLA
	RDF
	TAD	(CDF CIF)
	DCA	2$
	CDF	.FLD
1$:	TAD	TOCNT
	SZA CLA
	JMP	1$
2$:	HLT
	JMP I	TWAIT
/
/ INC is a routine to increment and wrap buffer pointers.
/ ARG1 is pointer to pointer.
/ This routine may not be interrupted since it bay be called
/ both by interrupt and normal and isn't reentrant!
/
INC,	0
	CLA			/Get arg1
	TAD I	INC
	ISZ	INC
	DCA	1$
	TAD I	1$		/Get pointer.
	IAC			/Increment.
	DCA	2$		/Save temporary.
	TAD	2$
	AND	(177)		/Mask for wrap.
	SNA CLA			/Is it time for wrap?
	TAD	(-200)		/Yes. AC=-200, else AC=0.
	TAD	2$		/Get pointer.
	DCA I	1$		/Save it.
	JMP I	INC		/Return.
1$:	0			/Pointer.
2$:	0			/Tmp.
/
PUTD2,	0
	DCA	T$
	DCA	L$
	RDF
	TAD	(CDF CIF)
	DCA	2$
	CDF	.FLD
	TAD	T$
1$:	TAD	(-12)
	ISZ	L$
	SMA
	JMP	1$
	TAD	(12)
	DCA	T$
	TAD	L$
	TAD	(57)
	JMS	PUT
	TAD	T$
	TAD	(60)
	JMS	PUT
2$:	HLT
	JMP I	PUTD2

T$:	0
L$:	0
/
PUTO2,	0
	DCA	T$
	RDF
	TAD	(CDF CIF)
	DCA	1$
	CDF	.
	TAD	T$
	RTR;RAR
	AND	(7)
	TAD	(60)
	JMS	PUT
	TAD	T$
	AND	(7)
	TAD	(60)
	JMS	PUT
1$:	HLT
	JMP I	PUTO2

T$:	0
/
FLUSHM,	0
	CLA
	RDF
	TAD	(CDF CIF
	DCA	R$
	CDF	.FLD
	IOF
	TAD	(MIBUF
	DCA	MIRPTR
	TAD	(MIBUF+1
	DCA	MIWPTR
	DCA	MICNT
	ION
R$:	HLT
	JMP I	FLUSHM
/
FLUSH,	0
	CLA
	RDF
	TAD	(CDF CIF
	DCA	R$
	CDF	.FLD
	IOF
	TAD	(TIBUF
	DCA	TIRPTR
	TAD	(TIBUF+1
	DCA	TIWPTR
	DCA	TICNT
	ION
R$:	HLT
	JMP I	FLUSH
/
FIXPAR,	0
	TAD	PARITY
	JMP I	FIXPAR
/
	PAGE
	.SBTTL	Interrupt buffers.

MIBUF,	ZBLOCK	200
MOBUF,	ZBLOCK	200
TIBUF,	ZBLOCK	200
TOBUF,	ZBLOCK	200
/
	.END

 