	.TITLE	KERMIT8
	.VERSION 3
	.SBTTL	Header
/ ++
/
/	KERMIT8	Y3B
/
/	(c) 1988, 1989, 1990, 1991 by Johnny Billquist
/
/	Kermit for pdp8.
/
/	Id	Programmer
/	BQT	Johnny Billquist
/
/	Ver	Date		By	Comments
/	X1A	88/12/10 12:30	BQT	Initial coding
/	X1B	88/12/20 17:30	BQT	Splitting of interrupt and program.
/	X1C	88/12/20 19:30	BQT	Splitting of functions and code.
/	X1D	89/01/04 09:30	BQT	Changed to new LNKLIB.
/	X1E	89/01/05 12:50	BQT	Removed KERFUN. Use LNKLIB!
/	X1F	89/06/26 23:20	BQT	Started packet coding.
/	X2A	90/01/22 18:00	BQT	Split KERMIT into pieces.
/	X2B	90/03/24 01:00	BQT	Modified for multiple fields support.
/	Y2C	90/07/17 01:00	BQT	Added UNJAM command.
/	Y2D	91/03/14 04:10	BQT	Small modifications.
/	Y2E	91/05/08 05:15	BQT	Added support for future server mode.
/	Y3A	91/05/11 09:45	BQT	Finished total rewrite of filetransfer.
/	Y3B	91/05/26 22:00	BQT	Added HELP command.
/
/ --
	.SBTTL	Setup
	.INCLUDE	SYS:COMMON
/
	.EXTERNAL	TGET,PUT,TWAIT,FLUSH
	.EXTERNAL	ENINT
	.EXTERNAL	CCFLAG
	.EXTERNAL	CLKOFF
	.EXTERNAL	FP
	.EXTERNAL	CONNECT,SET,SHOW
	.EXTERNAL	BYE,SEND,FGET,RECIEV
/
/ .FP macro is NOT the same as .FILEPARSE
/ .FP calls FILEPARSE and FETCH...
/
	.MACRO	.FP	DEVADR,FILNAM
	JMS	FP
	DEVADR
	FILNAM
	.ENDM

	.MACRO	.GETCMD	CMDADR,LEN
	JMS	GETCMD
	CMDADR
	LEN
	.ENDM
	.SBTTL	Zero page

	.XSECT	XMAIN
	FIELD	1
/
X0,	0
X1,	0
/
	.XSECT	XREG
	FIELD	XMAIN
/
FX0,	0
/
	.ZSECT	ZMAIN
	FIELD	XMAIN
/
CMDPTR,	0
TMP,	0
/
INDFLG,	0
FLG,	0
/
	VTY="Y
	VNO="3
	VLE="B
	.SBTTL	Main program
/                                                                                                                                                                                                                                                                                                                                                  
	.RSECT	RMAIN
	FIELD	XMAIN
/
KERMIT,	CLA			/No difference when chain.
	CIF	ENINT		/Enable interrupts.
	JMS	ENINT
	ION			/Turn interrupt system on.
	.PRINT	KERVER		/Tell version.
	.PRINT	HELLO		/Print welcome text.
	JMS	DOIND		/Execute KERMIT.INI if it exists.
	CMA
	DCA	FLG		/Set running flag.
/
	.ENTRY	MAIN
/
MAIN,	.PRINT	PROMPT		/Prompt.
	JMS	INICMD		/Init parser.
	.INPUT	INBUF,70.	/Read command.
	TAD	(-^"C)		/Check if terminated by ^C.
	SNA
	JMP	DCC$		/It was.
	TAD	(^"C-^"Z)	/Check if terminated by ^Z.
	SNA
	JMP	DCZ$		/It was.
	JMP	3$		/Terminated by something else...

DCC$:	.PRINT	TCC		/^C. Print nice text.
XX$:	JMP	EXIT2		/Exit.

DCZ$:	.PRINT	TCZ		/^Z. Print nice text.
	TAD	XX$		/Change MAIN loop to exit.
	DCA	MAIN
/
3$:                                                                                                                                                                                                                                                                                                                                                                                               	CLA			/Execute...
	TAD	(^"M)		/Output CR
	CIF	PUT
	JMS	PUT

	.GETCMD	CMDBUF,7	/Get command.
	TAD	CMDBUF		/Check if empty line.
	SNA
	JMP	MAIN		/It was.
	TAD	(-"/)		/Check if comment.
	SNA CLA
	JMP	MAIN		/It was.
	.PARSE	CMDBUF,CMDTAB	/Was not. Parse command.
	JMP	1$		/Que?
	DCA	TMP		/Ic. Save address of function.
	JMP I	TMP		/Jump to rotuine that handles request.

1$:	.PRINT	WHAT		/Command not valid. Tell 'em.
	JMP	MAIN		/Repeat.
/
	.SBTTL	Functions
/
/ INICMD JUST SETS CMDPTR TO START OF INPUT BUFFER.
/ AND CONVERTS STRING TO UPPERCASE.
/
INICMD,	0
	CLA			/Set CMDPTR to beginning of buffer.
	TAD	(INBUF)
	DCA	CMDPTR
	TAD	(INBUF-1)	/Set pointers for loop.
	DCA	X0
	TAD	X0
	DCA	X1
1$:	TAD I	X0		/Get char.
	SNA			/End of string?
	JMP I	INICMD		/Yes. Return.
	TAD	(-140)		/No. Check if lowercase.
	SMA
	TAD	(-40)		/It was. Convert to uppercase.
	TAD	(140)
	DCA I	X1		/Save char back.
	JMP	1$		/Repeat.
/
	.ENTRY	CLRCC
/
CLRCC,	0			/Check and clear ^C.
	CLA
	RDF
	TAD	(CDF CIF)
	DCA	R$
	CDF	CCFLAG
	TAD I	(CCFLAG)	/Get flag.
	SNA CLA			/Do we have ^C?
	ISZ	CLRCC		/No. Bump return.
	DCA I	(CCFLAG)	/Clear flag.
R$:	HLT
	JMP I	CLRCC		/Return.
/
	PAGE
	.SBTTL	GET routine.
/
	.ENTRY	GET
/
GET,	0
	CLA
	RDF			/Get return field.
	TAD	(CDF CIF)
	DCA	R$
	CDF	.

	TAD	INDFLG		/Check if taking commands from file.
	SZA CLA
	JMP	GF$		/Yes. Jump to proper part.

1$:	CIF	TGET		/No. Get char from TTY
	JMS	TGET
	JMP	1$		/Nothing in. Wait...
	JMP	R$		/Got it. Return.

GF$:	JMS	CLRCC		/Reading from file. Check for ^C.
	JMP	IABO$		/There was one. Abort.
	.ICHAR	IFIB,INERR$	/Read char.
	AND	(177)		/Mask away high bit.
	TAD	(-^"Z)		/Check if EOF
	SNA
	JMP	INERR$		/It was. We are through!
	TAD	(^"Z)		/Well is it a printable character then?
	JMP	R$

IABO$:	DCA	INDFLG		/Abort indirect file.
	.PRINT	USRABO
	CIF	FLUSH
	JMS	FLUSH
	JMP	MAIN

INERR$:	CLA
	DCA	INDFLG		/Well, we have error!
	.PRINT	TEOF		/Tell 'em.
	TAD	(^"M)

R$:	HLT
	JMP I	GET
/
	.ENTRY	ADDEXT
/
ADDEXT,	0			/Routine to add default extension,
	CLA			/ if none exists.
	RDF
	TAD	(CDF CIF)
	DCA	R$
	TAD I	ADDEXT		/Filename.
	ISZ	ADDEXT
	DCA	SA$
	TAD I	ADDEXT		/Default extension.
	ISZ	ADDEXT
	DCA	DX$
	TAD	(-17)		/Max length.
	DCA	LC$

FL$:	TAD I	SA$		/Get char.
	SNA			/End of filename?
	JMP	1$		/Yes. Add extension...
	TAD	(-".)		/Start of extension?
	SNA CLA
	JMP	R$		/Yes. No use of this routine.
	ISZ	SA$		/Bump pointer.
	ISZ	LC$		/Loop count.
	JMP	FL$		/Loop.
	JMP	R$		/Max length! Return.

1$:	TAD I	DX$		/No extesion found. Add default...
	SNA			/End of default?
	JMP	2$		/Yes.
	DCA I	SA$		/No, save default.
	ISZ	DX$		/Bump pointers.
	ISZ	SA$
	ISZ	LC$		/Count chars...
	JMP	1$		/Not filled up.

2$:	DCA I	SA$		/Filled or no more chars... Set EOT.
R$:	HLT
	JMP I	ADDEXT		/And return.

SA$:	0
DX$:	0
LC$:	0
/
	.SBTTL	PARSER subroutines.
/
	.ENTRY	CHKEOL
/
CHKEOL,	0			/Check if command after end of line.
	CLA			/Get command.
	RDF
	TAD	(CDF CIF)
	DCA	R$
	CDF	.

	TAD	CMDPTR
	.GETSTR	,TBUF$,1
	CLA
	TAD	TBUF$		/Check if anything...
	SNA
	JMP	R$		/Nothing. Return.
	TAD	(-"/)		/Check if comment.
	SNA CLA
	JMP	R$		/Was comment. Return.
	.PRINT	CAEOL		/Something. Tell him.
	JMP	MAIN		/And abort.
R$:	HLT
	JMP I	CHKEOL

TBUF$:	ZBLOCK	2
/
	PAGE
/
	.ENTRY	GETCMD
/
GETCMD,	0
	CLA

	RDF
	TAD	(CDF CIF)
	DCA	R$

	CMA
	TAD I	GETCMD		/Destination address.
	ISZ	GETCMD
	DCA	X1

	TAD I	GETCMD		/Max length.
	ISZ	GETCMD
	CIA
	DCA	LC$

	RDF			/Destination field.
	TAD	(CDF)
	DCA	C$

	CDF	.
	CMA
	TAD	CMDPTR		/Get pointer to command.
	DCA	X0		/Save pointer.

SP$:	TAD I	X0		/Skip spaces.
	SNA
	JMP	NC$		/End of command found.
	TAD	(-" )
	SNA
	JMP	SP$		/Got another space.

GC$:	TAD	(" )		/No space. Restore char.
C$:	HLT			/Change to proper field.
	DCA I	X1		/Save char.
	CDF	.		/Get new char.
	TAD I	X0
	SNA
	JMP	NC$		/End of command.
	TAD	(-" )
	SNA
	JMP	NC$		/Got a space.
	ISZ	LC$		/Bump count.
	JMP	GC$		/And repeat.

	CLA			/End of destination...
SR$:	TAD I	X0		/Get char.
	SNA
	JMP	NC$		/End of command.
	TAD	(-" )
	SZA CLA
	JMP	SR$		/No space. Repeat.

NC$:	CLA			/Done. Set command pointer to separator char.
	TAD	X0
	DCA	CMDPTR
	TAD	C$		/Get change field instruction.
	DCA	.+1		/Save for execution.
	HLT
	DCA I	X1		/Set end of string.

R$:	HLT			/Return...
	JMP I	GETCMD

LC$:	0
/
NYI,	.PRINT	TNYI
	JMP	MAIN
/
	PAGE
	.SBTTL	TAKE command.
/
TAKE,	.GETCMD	TMPFIL,17	/Get filename.
	JMS	CHKEOL
	TAD	TMPFIL		/Check if any filename.
	SNA CLA			/Was there any?
	JMP	1$		/No.
	JMS	DOIND		/Yes. Start execution.
	JMP	MAIN		/Get new command.

1$:	.PRINT	FNS		/Tell 'em, WE WANT FILENAME!
	JMP	MAIN		/Get new command.

DOIND,	0			/Routine to start indirect file.
	TAD	INDFLG		/Check if already executing.
	SZA
	JMP	IE$		/We are. Error!
	JMS	ADDEXT;TMPFIL;DOEXT
	.FP	IDEVH!1,TMPFIL	/Not. Parse file...
	DCA	IFIB+DEVNUM	/Save device parameters.
	TAD I	FX0
	DCA	IFIB+DEVADR
	.IOPEN	IFIB,FIL,INDERR	/Open file.
	CMA			/Set flag.
	DCA	INDFLG
	.PRINT	INDON		/Tell starter.
	.PRINT	TMPFIL		/With file.
	.PRINT	IND2		/Thats it!
	JMP I	DOIND		/Return.

IE$:	.PRINT	INDE		/Well, we can't nest!
	JMP	MAIN		/Get new command.

INDERR,	CLA			/Error while opening.
	TAD	FLG		/Check if init file, or user request.
	SNA CLA
	JMP I	DOIND		/Init file. Return.
	.PRINT	FNF		/User request. Tell file not found.
	JMP	MAIN		/Get new command.
/
	.SBTTL	EXIT command.
/
EXIT,	JMS	CHKEOL		/Anything else?
EXIT2,	CIF	CLKOFF		/Turn clock off.
	JMS	CLKOFF
	.PRINT	EXTTXT		/Exit KERMIT.
	CIF	TWAIT
	JMS	TWAIT		/Wait for print to be done.
	IOF			/Turn off interrupt system.
	.EXIT			/Return to monitor.
/
	.SBTTL	UNJAM command.
/
	.EXTERNAL	MOXOFF
/
UNJAM,	JMS	CHKEOL
	CDF	MOXOFF
	TAD I	(MOXOFF)
	DCA	1$
	DCA I	(MOXOFF)
	CDF	.
	TAD	1$
	SZA CLA
	JMP	2$
	.PRINT	JAMN
	JMP	MAIN
2$:	.PRINT	JAMY
	JMP	MAIN

1$:	0
/
HELP,	.PRINT	HTXT
	JMP	MAIN
/
	PAGE
	.SBTTL	Text data

	.DSECT	TXMAIN
	.RADIX	10

INDE,	TEXT                                                                                                                                                                                                                                                                                                                                                                                   	<10>"Already processing indirect file."<13>
TEOF,	TEXT	"[End of file]"
TIC,	TEXT	<10>"Error closing indirect file."<13>
INDON,	TEXT	<10>'[Executing file "'
IND2,	TEXT	'"]'<13>
USRABO,	TEXT	"^C"<13><10>"[Aborted]"<13>

	.GLOBAL	KERVER,HELLO

KERVER,	TEXT	<10>"KERMIT8   "<VTY><VNO><VLE><13>
HELLO,	TEXT	<10>"(c) 1988, 1989, 1990, 1991 by Johnny Billquist"<13><10>
PROMPT,	TEXT	<10>"Kermit-8>"
EXTTXT,	TEXT	<10>"[Exiting Kermit]"<13><10>
WHAT,	TEXT	<10>"Unknown command."<13>
CAEOL,	TEXT	<10>"Characters detected after logical end of line."<13>
TNYI,	TEXT	<10>"%NYI - Not Yet Implemented."<13>

TCC,	TEXT	"^C"<13>
TCZ,	TEXT	"^Z"

FNF,	TEXT	<10>"File not found."<13>
FNS,	TEXT	<10>"No file specified."<13>

JAMY,	TEXT	<10>"Output was jammed."<13>
JAMN,	TEXT	<10>"Output was not jammed."<13>

	.DISABL	FILL
HTXT,	TEXT	<10>"Short help for KERMIT-8."<13><10>
	TEXT	<10>"EXit               End program."<13>
	TEXT	<10>"Quit               End program."<13>
	TEXT	<10>"Connect            Connect terminal to modem."<13>
	TEXT	<10>"SEt <options>      Set various options."<13>
        TEXT    <10>"SHow <options>     Show various options."<13>
	TEXT	<10>"TAke <filename>    Take commands from file."<13>
	TEXT	<10>"BYE                End remote server."<13>
	TEXT	<10>"Help               Give this help text."<13><10>

	TEXT	<10>"SENd <local-filenames> [<remote-filenames>]"<13>
	TEXT	<10>"GEt <remote-filenames> [<local-filenames>]"<13>
	TEXT	<10>"REcieve [<local-filenames>]"<13><0>
	.ENABLE	FILL

	.SBTTL	Data

	.DSECT	DAMAIN
	FIELD	XMAIN
	.RADIX	8

INBUF,	ZBLOCK	71.		/Buffer to hold string.
CMDBUF,	ZBLOCK	10		/Buffer to hold specific command.
/
IFIB,	.FIB	,,FILBUF	/FIB for indirect file.
/
	.GLOBAL	DEV,FIL
/
DEV,	DEVICE	DSK		/Packed file info for all file operations.
FIL,	FILENAM	XXXXXX.XX
/
CMDTAB,	CMDEXI;EXIT		/Main command table.
	CMDQUI;EXIT
	CMDCON;CONNEC
	C                                                                                                                                                                                                                                                                                                                                                                                          MDSET;SET
	CMDSHO;SHOW
	CMDTAK;TAKE
	CMDBYE;BYE
	CMDSND;SEND
	CMDGET;FGET
	CMDREC;RECIEV
	CMDJAM;UNJAM
	CMDHEL;HELP
	0
/
CMDEXI,	TEXT	"EXit"		/Command strings.
CMDQUI,	TEXT	"Quit"
CMDCON,	TEXT	"Connect"
CMDSET,	TEXT	"SEt"
CMDSHO,	TEXT	"SHow"
CMDTAK,	TEXT	"TAke"
CMDBYE,	TEXT	"BYE"
CMDSND,	TEXT	"SENd"
CMDGET,	TEXT	"GEt"
CMDREC,	TEXT	"REcieve"
CMDJAM,	TEXT	"UNjam"
CMDHEL,	TEXT	"Help"
/
TMPFIL,	TEXT	"SYS:KERMIT.INI"<0>	/File name areas.

DOEXT,	TEXT	".INI"			/Default extensions...
	.DSECT	BUMAIN
/
FILBUF,	ZBLOCK	400			/File buffer.
/
	.RSECT	HNMAIN
	FIELD	0
IDEVH,	ZBLOCK	400			/Area for device handler.
/
	.END	KERMIT
