/ ++
/
/	C O M M O N
/
/	PDP8 COMMON LIBRARY
/	VERSION Y1.8
/	COPYRIGHT (C) 1988, 1989, 1990, 1991 BY JOHNNY BILLQUIST
/	ALL RIGHTS RESERVED
/
/ --
	OLDLIS=.LISTW
	.LISTW=^O4001
	OLDLIS=OLDLIS ^B011000000001
/ ++
/
/
/	Common definitions
/
/	History:
/
/	Y1.0	88/10/30 18:10	BQT	Initial coding
/	Y1.1	88/12/29 14:45	BQT	Made to accomodate FILEIO Y1.4.
/	Y1.2	89/01/03 12:25	BQT	Added STRLIB.
/	Y1.3	89/06/02 15:15	BQT	Added macros for different clocks.
/	Y1.4	89/06/13 23:10	BQT	Added preserving of .LISTW
/	Y1.5	89/10/21 20:20	BQT	Added disk code functions.
/	Y1.6	90/07/02 21:00	BQT	Split into multiple files.
/	Y1.7	91/03/14 00:35	BQT	Merged back into one big file.
/	Y1.8	91/05/04 20:30	BQT	Added .FLUSH (FILEIO Y1.8)
/					Added .TABLE (for .TRNSLT)
/
/ --
/
/	ENABLES
/
	.ENABLE	ASCII,7BIT,FILL
/
/	EXTERNALS
/
	USR=17700		/ We should always use this USR...

	.MACRO	.EXIT
	CDF CIF
	JMP	7600
	.ENDM

	.MACRO	.END	ADR
	.IF NB	ADR	<.START	ADR>
	$
	.ENDM
/
	.MACRO	.PRINT	TXT
	.IF BL	TXT	<DCA	.+3>
	.EXTERNAL	$PRINT
	CIF	$PRINT
	JMS	$PRINT
	.IF BL	TXT	<
	0
	.FLD>
	.IF NB	TXT	<
	TXT
	EDF	TXT >
	.ENDM

	.MACRO	.PSIX	TXT                                                                                                                                                                                                                                                                                                                                                              
	.IF BL	TXT	<DCA	.+3>
	.EXTERNAL	PSIX
	CIF	PSIX
	JMS	PSIX
	.IF BL	TXT	<
	0
	.FLD>
	.IF NB	TXT	<
	TXT
	EDF	TXT >
	.ENDM

	.MACRO	.PFNAM	TXT
	.IF BL	TXT	<DCA	.+3>
	.EXTERNAL	$PFNAM
	CIF	$PFNAM
	JMS	$PFNAM
	.IF NB	TXT	<TXT>
	.IF BL	TXT	<0>
	.ENDM

	.MACRO	.INPUT	BUF,LEN
	.EXTERNAL	$INPUT
	CIF	$INPUT
	JMS	$INPUT
	.IF NB	BUF	<
	BUF
	LEN>
	.ENDM

	.MACRO	.PUTC
	.EXTERNAL	PUT
	CIF	PUT
	JMS	PUT
	.ENDM

	.MACRO	.GETC
	.EXTERNAL	GET
	CIF	GET
	JMS	GET
	.ENDM

	.MACRO	.PUTAC
	.EXTERNAL	PUTAC
	CIF	PUTAC
	JMS	PUTAC
	.ENDM

	.MACRO	.UNSIX
	.EXTERNAL	UNSIX
	CIF	UNSIX
	JMS	UNSIX
	.ENDM
/
/	SYMBOLS
/
	DK8EA=1
	DK8EC=2
	DK8EP=3
	DKC8A=4
/
	.MACRO	CLKDEF	CLKTYP
	.IF EQ	CLKTYP-DK8EA	<
	CLKON=6131
	CLKOF=6132
	CLKSKP=6133
	.MACRO	CLKCLR
	CLKCKP
	NOP
	.ENDM	CLKCLR
	>
	.IF EQ	CLKTYP-DKC8A	<
	.MACRO	CLKON
	CLA IAC
	6135
	CLA
	.ENDM
	.MACRO	CLKOF
	CLA
	6135
	.ENDM
	CLKSKP=6137
	CLKCLR=6136
	>
	.IF EQ	CLKTYP-DK8EP	<
	.MACRO	CLKON
	6134
	6130
	CLA CMA
	6133
	TAD	(5210
	6132
	CLA
	.ENDM
	.MACRO	CLKOF
	CLA CLL CML RAR
	6130
	CLA
	.ENDM
	CLKSKP=6131
	.MACRO	CLKCLR
	6135
	CLA
	.ENDM
	FIXTAB
	.ENDM
/
/ Disk symbols
/
	DSKP=6741
	DCLR=6742
	DLAG=6743
	DLCA=6744
	DRST=6745
	DLDC=6746
	DMAN=6747

	RLDC=6600
	RLSD=6601
	RLMA=6602
	RLCA=6603
	RLCB=6604
	RLSA=6605
	RLWC=6607
	RRER=6610
	RRWC=6611
	RRCA=6612
	RRCB=6613
	RRSA=6614
	RRSI=6615
	RLSE=6617
/
	.MACRO	CALUSR	FUNC
	CIF	10
	JMS	USR
	FUNC
	.ENDM

	.MACRO	.FETCH	DEVPTR,DEVADR,ERR
	CLA
	TAD	DEVADR
	DCA	.+12
	TAD	DEVPTR
	DCA	.+6
	TAD	DEVPTR+1
	DCA	.+5
	CALUSR	1
	0
	0
	0

	.IF NB	ERR	<JMP	ERR>
	.IF BL	ERR	<HLT>

	TAD	(.-4)
	.ENDM
/
	.MACRO	.GETSTR	SRC.A,DST.A,MAX.L,SEP
	.IF BL	SRC.A	<
	DCA	.+3
	>
	.EXTERNAL	$GETSTR
	CIF	$GETSTR
	JMS	$GETSTR
	.IF BL	SRC.A	<
	0
	>
	.IF NB	SRC.A	<SRC.A>
	.IF NB	DST.A	<
	DST.A
	MAX.L
	.IF NB	SEP	<SEP>
	.IF BL	SEP	<" >>
	.ENDM

	.MACRO	.FPARSE	SRC.A,DST.A
	.IF BL	SRC.A	<
	DCA	.+3
	>
	.EXTERNAL	$FPARSE
	CIF	$FPARSE
	JMS	$FPARSE
	.IF BL	SRC.A	<
	0
	>
	.IF NB	SRC.A	<SRC.A>
	.IF NB	DST.A	<DST.A>
	.ENDM

	.MACRO	.COPYF	SRC.A,DEF.A,DST.A
	.IF BL	SRC.A	<DCA	.+3>
	.EXTERNAL	$COPYF
	CIF	$COPYF
	JMS	$COPYF
	.IF BL	SRC.A	<0>
	.IF NB	SRC.A	<SRC.A>
	DEF.A
	DST.A
	.ENDM

	.MACRO	.FIXFIL	SRC.A
	.EXTERNAL	$FIXFIL
	CIF	$FIXFIL
	JMS	$FIXFIL
	.IF NB	SRC.A	<SRC.A>
	.ENDM

	.MACRO	.TRNSLT	TBL.A
	.EXTERNAL	TRNSLT
	CIF	TRNSLT
	JMS	TRNSLT
	.IF NB	TBL.A	<TBL.A>
	.ENDM

	.MACRO	.TABLE	E.LBL
	E.LBL-.%2
	.ENDM

	.MACRO	.PARSE	STR.A,TBL.A
	.IF BL STR.A	<
	DCA	.+3
	>
	.EXTERNAL	PARSE
	CIF	PARSE
	JMS	PARSE
	.IF BL	STR.A	<
	0
	>
	.IF NB	STR.A	<STR.A>
	.IF NB	TBL.A	<TBL.A>
	.ENDM
/
	.MACRO	.CVTDB	SRC.A
	.EXTERNAL	CVTDB
	CIF	CVTDB                                                                                                                                                                                                                                                          
	JMS	CVTDB
	.IF NB	SRC.A	<SRC.A>
	.ENDM

	.MACRO	.CVTBD	DST.A
	.EXTERNAL	CVTBD
	CIF	CVTBD
	JMS	CVTBD
	.IF NB	DST.A	<DST.A>
	.ENDM

	.MACRO	.CVTOB	SRC.A
	.EXTERNAL	CVTOB
	CIF	CVTOB
	JMS	CVTOB
	.IF NB	SRC.A	<SRC.A>
	.ENDM

	.MACRO	.CVTBO	DST.A
	.EXTERNAL	CVTBO
	CIF	CVTBO
	JMS	CVTBO
	.IF NB	DST.A	<DST.A>
	.ENDM

	.MACRO	.BDATD	DST.A
	.EXTERNAL	$BDATD
	CIF	$BDATD
	JMS	$BDATD
	.IF NB	DST.A	<DST.A>
	.ENDM	.BDATD
/
/	SYMBOLS
/
	DEVADR=00
	DEVNUM=01
	BUFADR=02
	BUFFLD=03
	FILLIN=04
	BUFCNT=05
	FILBLK=06
	FILFLG=07
	FILBEG=10
	FILSIZ=11
	FILEND=12
	FILNAM=13
	FILEXT=16
	FILDAT=17
/
/	MACROS
/
	.MACRO	.FIB	DEVADR,DEVNUM,BUFADR
	.IF NB	DEVADR	<DEVADR>
	.IF BL	DEVADR	<0>
	.IF NB	DEVNUM	<DEVNUM>
	.IF BL	DEVNUM	<0>
	.IF NB	BUFADR	<
	BUFADR
	EDF	BUFADR
	>
	.IF BL	BUFADR	<
	.+16
	.FLD
	>
	ZBLOCK	14
	.IF BL	BUFADR	<
	ZBLOCK	400>
	.ENDM

	.MACRO	.LOOKUP	NAME,FILNAM,ERR
	.EXTERNAL	$FILEIO
	CIF	$FILEIO
	JMS	$FILEIO
	1
	NAME
	FILNAM

	.IF NB	ERR	<JMP	ERR>
	.IF BL	ERR	<HLT>
	.ENDM

	.MACRO	.IOPEN	NAME,FILNAM,ERR
	.EXTERNAL	$FILEIO
	CIF	$FILEIO
	JMS	$FILEIO
	2
	NAME
	FILNAM

	.IF NB	ERR	<JMP	ERR>
	.IF BL	ERR	<HLT>
	.ENDM

	.MACRO	.OOPEN	NAME,FILNAM,ERR
	.EXTERNAL	$FILEIO
	CIF	$FILEIO
	JMS	$FILEIO
	3
	NAME
	FILNAM

	.IF NB	ERR	<JMP	ERR>
	.IF BL	ERR	<HLT>
	.ENDM

	.MACRO	.PUT	NAME,ERR
	.EXTERNAL	$FILEIO
	CIF	$FILEIO
	JMS	$FILEIO
	4
	NAME

	.IF NB	ERR	<JMP	ERR>
	.IF BL	ERR	<HLT>
	.ENDM

	.MACRO	.GET	NAME,ERR
	.EXTERNAL	$FILEIO
	CIF	$FILEIO
	JMS	$FILEIO
	5
	NAME

	.IF NB	ERR	<JMP	ERR>
	.IF BL	ERR	<HLT>
	.ENDM

	.MACRO	.OCHAR	NAME,ERR
	.EXTERNAL	$FILEIO
	CIF	$FILEIO
	JMS	$FILEIO
	6
	NAME

	.IF NB	ERR	<JMP	ERR>
	.IF BL	ERR	<HLT>
	.ENDM

	.MACRO	.ICHAR	NAME,ERR
	.EXTERNAL	$FILEIO
	CIF	$FILEIO
	JMS	$FILEIO
	7
	NAME

	.IF NB	ERR	<JMP	ERR>
	.IF BL	ERR	<HLT>
	.ENDM

	.MACRO	.FPRINT	NAME,STRING,ERR
	.IF BL	STRING	<
	DCA	.+5
	>

	.EXTERNAL	$FILEIO
	CIF	$FILEIO
	JMS	$FILEIO
	10
	NAME
	.IF BL	STRING	<
	0
	>
	.IF NB	STRING	<STRING>

	.IF NB	ERR	<JMP	ERR>
	.IF BL	ERR	<HLT>
	.ENDM

	.MACRO	.POSIT	NAME,ADR,ERR
	.EXTERNAL	$FILEIO
	CIF	$FILEIO
	JMS	$FILEIO
	11
	NAME
	ADR

	.IF NB	ERR	<JMP	ERR>
	.IF BL	ERR	<HLT>
	.ENDM

	.MACRO	.POSITP	NAME,ADR,ERR
	.EXTERNAL	$FILEIO
	CIF	$FILEIO
	JMS	$FILEIO
	12
	NAME
	ADR

	.IF NB	ERR	<JMP	ERR>
	.IF BL	ERR	<HLT>
	.ENDM

	.MACRO	.CLOSE	NAME,ERR
	.EXTERNAL	$FILEIO
	CIF	$FILEIO
	JMS	$FILEIO
	13
	NAME

	.IF NB	ERR	<JMP	ERR>
	.IF BL	ERR	<HLT>
	.ENDM

	.MACRO	.FLUSH	NAME,ERR
	.EXTERNAL	$FILEIO
	CIF	$FILEIO
	JMS	$FILEIO
	14
	NAME

	.IF NB	ERR	<JMP	ERR>
	.IF BL	ERR	<HLT>
	.ENDM

	FIXTAB

	.LISTW=OLDLIS

 