	.TITLE	PSIX - Output SIXBIT string.
	.VERSIO	20
/ ++
/
/	PSIX Y2.0
/
/	(c) 1988, 1989 by Johnny Billquist
/
/	All rights reserved.
/
/	IOLIB is a library routine.
/
/	History:
/
/	88/10/30 17:50	BQT	Initial coding.
/	88/12/28 17:30	BQT	Y1.2. Added INPUT.
/	89/01/04 09:05	BQT	Y1.3. Separated IOLIB and STDIO.
/	89/12/01 20:00	BQT	Y1.4. Made functions FSECT.
/	89/12/27 05:00	BQT	Y2.0. Made from IOLIB.
/
/ --
	.EXTERNAL	PUT
/
/
/ PSIX outputs a sixbit string on TTY.
/ String is terminated by a NUL. @ is control quote.
/
	.FSECT	PSIX
/
	0			/For return address.
	CLA CMA
	TAD I	PSIX		/Get arg1.
	ISZ	PSIX
	DCA	PP1$		/Save as string pointer.
	TAD I	PSIX		/Get arg2.
	ISZ	PSIX
	TAD	(CDF)
	DCA	C$		/Save as data field.
	RDF			/Get return field.
	TAD	(CDF CIF)
	DCA	R$
	CDF	.FLD		/Change to current field.
	DCA	PP2$		/Save even/odd flag.
1$:	JMS	GC$		/Get char.
	SNA			/NUL?
	JMP	R$		/Yes. String done. Return.
	CIF	PUT		/No. Output char.
	JMS	PUT
	JMP	1$		/Repeat.
R$:	HLT			/Return field.
	JMP I	PSIX		/Return.
/
GC$:	0			/Get char routine.
	JMS	GC2$		/Call get char 2.
	SNA			/Control quote?
	JMP	2$		/Yep.
	JMS	UNSIX$		/No. Unsixify.
	JMP I	GC$		/Return.
2$:	JMS	GC2$		/Control quote. Get new char.
	JMP I	GC$		/Return.
/
GC2$:	0			/Get char 2. Reads from memory.
C$:	HLT			/Change to data field.
	ISZ	PP2$		/Check even/odd.
	JMP	3$		/Even.
	CLA			/Odd.
	TAD I	PP1$		/Get word. Odd is right part of word.
	JMP	4$		/Continue.
3$:	ISZ	PP1$		/Even is left part of new word. Bump pointer.
	CLA CMA			/Reset even/odd flag.
	DCA	PP2$
	TAD I	PP1$		/Get word.
	BSW			/SWAP.
4$:	CDF	.FLD		/Change to current field.
	AND	(77)		/Mask char from word.
	JMP I	GC2$		/Return.
/
UNSIX$:	0			/Unsixify routine.
	TAD	(-40)		/Separate alpha from special.
	SPA			/Skip is special.
	TAD	(100)		/Alpha shall have bit 5 set.
	TAD	(40)		/Normalize.
	JMP I	UNSIX$		/Return.
/
PP1$:	0			/Pointer.
PP2$:	0			/Even/odd flag.
/
$
