/*
 *	EMUL-8: a pdp8e emulator.
 *
 *	Author:
 *		Bill Haygood
 *		41832 Ernest Road
 *		Loon Lake, WA 99148-9607
 *		Internet: billh@comtch.iea.com
 *		Voice/AnsMach/FAX \
 *			or	   509-233-2555
 *		  Cellular/Pager  /
 *
 *	Copyright 1992,1993, 1994 by the author with all rights reserved.
 *
 *	Include file for Miscellaneous routines.
 */
/* -------------------------------------------------------------------- */
/*
 *	Print a header to display the registers.
 */
extern	INT header (INT newline, INT cputrace, INT fpptrace) ;
/* -------------------------------------------------------------------- */
/*
 *	Print a header to display the registers.
 */
extern	VOID outline (VOID) ;
/* -------------------------------------------------------------------- */
/*
 *	Store double to UWORD array w.
 */
extern	VOID storefpp (DOUBLE d, UWORD *w) ;
/* -------------------------------------------------------------------- */
/*
 *	Convert a pdp8 fpp floating point datum to double.
 *	w points to fpp exponent word.
 */
extern	DOUBLE fpp2d (UWORD *w) ;
/* --------------------------------------------------------------------	*/
/*
 *	Output an FPP datum in decimal format.
 *	e.g. : -3.14159265358979
 *
 *	If 'w' is NULL, output content of the FAC, otherwise
 *	use address supplied.
 */
extern	VOID outfpp (UWORD *w, INT posit) ;
/* --------------------------------------------------------------------	*/
/*
 *	Output a bit stream to a file.
 */
extern	VOID outbits (ULONG bits, INT length) ;
/* --------------------------------------------------------------------	*/
/*
 *	Input a bit stream from a file.
 */
extern	UWORD inbits (INT length) ;
/* -------------------------------------------------------------------- */
/*
 *	Do RK8-E write cylinder.
 */
extern	VOID rk8writ (INT unit) ;
/* -------------------------------------------------------------------- */
/*
 *	Do RK8-E read cylinder.
 */
extern	VOID rk8read (INT unit) ;
/* -------------------------------------------------------------------- */
/*
 *	Do RK8-E I/O (read or write an rk8e OS/8 block or half-block).
 */
extern	INT rk8io (INT unit, INT block, UBYTE half,
					UBYTE rwflag, UINT memadr) ;
/* -------------------------------------------------------------------- */
/*
 *	Do RX50 write track.
 */
extern	VOID rx5writ (INT unit) ;
/* -------------------------------------------------------------------- */
/*
 *	Do RX50 read track.
 */
extern	VOID rx5read (INT unit) ;
/* -------------------------------------------------------------------- */
/*
 *	Do RX50 I/O (read or write an rx50 OS/8 block or half block).
 */
extern	INT rx5io (INT unit, INT block, UBYTE half,
					UBYTE rwflag, UINT memadr) ;
/* -------------------------------------------------------------------- */
/*
 *	Load instruction vectors for the EAE.
 */
extern	VOID loadEAE (VOID) ;
/* -------------------------------------------------------------------- */
/*
 *	Load instruction vectors for specified clock.
 */
extern	INT loadCLOCK (VOID) ;
/* -------------------------------------------------------------------- */
/*
 *	Load instruction vectors for the FPP.
 */
extern	INT loadFPP (VOID) ;
/* -------------------------------------------------------------------- */
/*
 *	Load instruction and text vectors for RX50 floppy disk drive.
 */
extern	INT loadRX50 (INT ioadr) ;
/* -------------------------------------------------------------------- */
/*
 *	Load text and instruction vectors for the AUX VDU.
 */
extern	INT loadAUXVDU (INT ioadr) ;
/* -------------------------------------------------------------------- */
/*
 *	Load special emulator instruction and text vectors.
 */
extern	INT loadEMUL8 (INT ioadr) ;
/* -------------------------------------------------------------------- */
extern	INT validate (VOID) ;
/* -------------------------------------------------------------------- */
