/*
 *	EMUL-8: a pdp8e emulator.
 *
 *	Author:
 *		Bill Haygood
 *		41832 Ernest Road
 *		Loon Lake, WA 99148-9607
 *		Internet: billh@comtch.iea.com
 *		Voice/AnsMach/FAX \
 *			or	   509-233-2555
 *		  Cellular/Pager  /
 *
 *	Copyright 1992, 1993, 1994 by the author with all rights reserved.
 *
 *	Register definitions.
 */
#include "pdp8.h"
/*
 *	pdp8 registers.
 */
UINT	DF = 0 ;			/* Data Field register		*/
UINT	IB = 0 ;			/* Inst Buffer			*/
UINT	IF = 0 ;			/* Inst Field register		*/
UINT	PC = 07600 ;			/* PC register			*/
UINT	INST ;				/* Instruction fetched from mem */
UINT	AC = 0 ;			/* Accumulator			*/
UINT	MQ = 0 ;			/* Multiplier-Quotient		*/
UINT	SR = 0 ;			/* Switch register		*/
UBYTE	EAE = FALSE ;			/* EAE presence/mode flag	*/
UBYTE	GTF = FALSE ;			/* EAE Greater Than flag	*/
UINT	SC = 0 ;			/* EAE Step Counter		*/
UBYTE	int_ena = FALSE ;		/* Interrupt Enable Flip-Flop	*/
UBYTE	int_inh = FALSE ;		/* Interrupt Inhibit Flop-Flop	*/
ULONG	io_flags = FALSE ;		/* Interrupt request line	*/
UINT	UB = FALSE ;			/* User Buffer			*/
UINT	UF = FALSE ;			/* User Flag			*/
UINT	SF = 0 ;			/* Save Field			*/
DOUBLE	cpu_count = FALSE ;		/* Count CPU instructions	*/
UBYTE	cpu_trace = FALSE ;		/* Trace CPU instruction count	*/
DOUBLE	eae_count = FALSE ;		/* Count EAE instructions	*/
UBYTE	eae_trace = FALSE ;		/* Trace EAE instruction count	*/
/*
 *	'base' points to pdp8 memory.
 */
UWORD	*base = NULL ;
/*
 *	FPP-8/A Floating Point Processor
 */
VOID	(*fppexec)(VOID) = NULL ;	/* Pointer to FPP-8/A run loop	*/
DOUBLE	fpp_count = 0 ;			/* FPP-8/A inst execution count	*/
UBYTE	fpp_trace = 0 ;			/* FPP instruction trace count	*/
UBYTE	fpp_mode = FALSE ;		/* Run mode			*/
UBYTE	fpp_data = FALSE ;		/* Data mode			*/
UBYTE	fpp_run = FALSE ;		/* Pause: run = halt = TRUE	*/
UBYTE	fpp_pause = FALSE ;		/* Set by FPHLT (6554)		*/
UINT	fpp_aptp = 0 ;			/* FPP APT pointer		*/
UINT	fpp_command = 0 ;		/* FPP command register		*/
					/* Bit	Meaning			*/
					/*   0	Select DP mode		*/
					/*   1	Exit on exp overflow	*/
					/*   2	Enable memory protection*/
					/*   3	Enable interrupt	*/
					/*   4	No store op address	*/
					/*   5	No store index regs	*/
					/*   6	No store ind ptr list	*/
					/*   7	No store FAC		*/
					/*   8	Unused			*/
					/* 9-11	APT data field		*/
UINT	fpp_stat = 0 ;			/* FPP status register		*/
					/* Bit	Meaning			*/
					/*   0	DP Mode			*/
					/*   1	Instruction Trap	*/
					/*   2	CPU Force Trap		*/
					/*   3	Divide by zero		*/
					/*   4	Frac overflow (DP only)	*/
					/*   5	Exponent overflow	*/
					/*   6	Exponent underflow	*/
					/* 7-10	Unused			*/
					/*  11	Run			*/
UWORD	fpp_ac [6] ;			/* FPP FAC in pdp8 format	*/
UINT	fpp_pc = 0 ;			/* FPP program counter		*/
UINT	fpp_x0 = 0 ;			/* FPP index register location	*/
UINT	fpp_br = 0 ;			/* FPP base register		*/
UINT	fpp_opadd = 0 ;			/* FPP operand address		*/
/*
 *	100 Hz clock (DK8E-C, PDP8-A, VT/78, VT/278)
 */
UBYTE	clocktype = 0 ;
LONG	tickspersec = 0 ;		/* Real time clock ticks/second	*/
/*
 *	Console VDU
 */
UBYTE	coninchar = '\0', conoutchar = '\0' ;
/*
 *	Auxilliary VDU
 */
UBYTE	aux_vdu = FALSE ;
UBYTE	auxinchar = '\0', auxoutchar = '\0' ;
/*
 *	PT8-E Reader/Punch
 */
FILE	*pt8reader = NULL ;
UBYTE	pt8rdrbuffer = 0377 ;
BYTE	*ptrtape [16] = { NULL } ;
INT	itape = 0 ;
FILE	*pt8punch = NULL ;
UBYTE	pt8punbuffer = 0 ;
BYTE	*ptptape [16] = { NULL } ;
INT	otape = 0 ;
/*
 *	LP8-E Line Printer
 */
FILE	*lp8printer = NULL ;
UBYTE	printCHAR  = 0 ;
/*
 *	RK8-E Disk System Registers
 */
BYTE	*rk8file [4] = { NULL, NULL, NULL, NULL } ;
UINT	rk8command = 0 ;
UINT	rk8curaddr = 0 ;
UINT	rk8block   = 0 ;
UINT	rk8status  = 0 ;
struct
{
    FILE *drive ;
    UBYTE *buff ;
    INT cyl ;
    INT maxcyl ;
    UBYTE dirty ;
} rk8 [4] ;
INT	rk8unit = 0 ;
INT	rk8words ;
INT	rk8count = 0 ;
UBYTE	rk8lock = 0 ;
UBYTE	rk8write = 0 ;
/*
 *	RX50 Disk System Registers
 */
UBYTE	rx50 = FALSE ;			/* RX50 presence flag		*/
BYTE	*rx5file [2] = { NULL, NULL } ;
UINT	rx5command = 0 ;
UINT	rx5curaddr = 0 ;
UINT	rx5block   = 0 ;
UINT	rx5status  = 0 ;
struct
{
    FILE *drive ;
    UBYTE *buff ;
    INT cyl ;
    INT maxcyl ;
    UBYTE dirty ;
} rx5 [2] ;
INT	rx5unit = 0 ;
INT	rx5words ;
INT	rx5count = 0 ;
UBYTE	rx5lock = 0 ;
UBYTE	rx5write = 0 ;
/*
 *	Miscellaneous variables used by the emulator.
 */
BYTE	chrsout [400] = { 0 }, pdp8exec [100] = { 0 } ;
UBYTE	run = FALSE ;
UBYTE	delay = FALSE ;			/* Delay after ION		*/
ULONG	int_mask = 0 ;			/* Interrupt request mask	*/
UBYTE	incrPC = FALSE ;		/* Used by disassem & in pdp8.c	*/
UINT	lastPC = 0 ;			/* Used in tracing		*/
UINT	os8date = 0 ;			/* Used to store OS/8 date	*/
UBYTE	breakflag = FALSE ;
UBYTE	tabulate = FALSE ;
UBYTE	profile = FALSE ;
UBYTE	checkvdus = FALSE ;
INT	clkcntr = CLKCNT ;
LONG	curtime, ticks, ticktime ;
UWORD	addrmask = 0177777, instmask = 0177777 ;
UWORD	breakaddr = 0177777, breakinst = 0177777 ;
FILE	*tabfile, *histofile ;
ULONG	*tab = NULL, *histo = NULL ;
ULONG	exec = 0 ;
INT	diag = 0 ;
LONG	trace = 0 ;
union
{
    DOUBLE d ;
    FLOAT f [2] ;
    ULONG l [2] ;
    UWORD w [4] ;
    UBYTE b [8] ;
} order ;
/*
 *	Various output files.
 */
FILE	*pdp8conout = NULL ;		/* pdp8 console output file	*/
FILE	*pdp8auxout = NULL ;		/* pdp8 aux console output file	*/
FILE	*tracefile = NULL ;		/* trace output file		*/
/*
 *	pdp8 memory
 */
FILE	*pdp8file = NULL ;		/* pdp8 memory storage file	*/
UWORD	mem32k [8L * 4096] ;
/* -------------------------------------------------------------------- */
