/*
 *	EMUL-8: a pdp8e emulator.
 *
 *	Author:
 *		Bill Haygood
 *		41832 Ernest Road
 *		Loon Lake, WA 99148-9607
 *		Internet: billh@comtch.iea.com
 *		Voice/AnsMach/FAX \
 *			or	   509-233-2555
 *		  Cellular/Pager  /
 *
 *	Copyright 1992, 1993, 1994 by the author with all rights reserved.
 *
 *	Include file for hardware registers module.
 */
/*
 *	pdp8 registers.
 */
extern	UINT	DF ;			/* Data Field register		*/
extern	UINT	IB ;			/* Inst Buffer			*/
extern	UINT	IF ;			/* Inst Field register		*/
extern	UINT	PC ;			/* PC register			*/
extern	UINT	INST ;			/* Instruction fetched from mem */
extern	UINT	AC ;			/* Accumulator			*/
extern	UINT	MQ ;			/* Multiplier-Quotient		*/
extern	UINT	SR ;			/* Switch register		*/
extern	UBYTE	EAE ;			/* EAE presence/mode flag	*/
extern	UBYTE	GTF ;			/* EAE Greater Than flag	*/
extern	UINT	SC ;			/* EAE Step Counter		*/
extern	UBYTE	int_ena ;		/* Interrupt Enable Flip-Flop	*/
extern	UBYTE	int_inh ;		/* Interrupt Inhibit Flop-Flop	*/
extern	ULONG	io_flags ;		/* Interrupt request line	*/
extern	UINT	UB ;			/* User Buffer			*/
extern	UINT	UF ;			/* User Flag			*/
extern	UINT	SF ;			/* Save Field			*/
extern	DOUBLE	cpu_count ;		/* Count CPU instructions	*/
extern	UBYTE	cpu_trace ;		/* Trace CPU instruction count	*/
extern	DOUBLE	eae_count ;		/* Count EAE instructions	*/
extern	UBYTE	eae_trace ;		/* Trace EAE instruction count	*/
/*
 *	'base' points to pdp8 memory.
 */
extern	UWORD	*base ;
/*
 *	FPP-8/A Floating Point Processor
 */
extern	VOID	(*fppexec)(VOID) ;	/* Pointer to FPP-8/A run loop	*/
extern	DOUBLE	fpp_count ;		/* FPP-8/A inst execution count	*/
extern	UBYTE	fpp_trace ;		/* FPP instruction trace count	*/
extern	UBYTE	fpp_mode ;		/* Run mode			*/
extern	UBYTE	fpp_data ;		/* Data mode			*/
extern	UBYTE	fpp_run ;		/* Pause: run = halt = TRUE	*/
extern	UBYTE	fpp_pause ;		/* Set by FPHLT (6554)		*/
extern	UINT	fpp_aptp ;		/* FPP APT pointer		*/
extern	UINT	fpp_command ;		/* FPP command register		*/
extern	UINT	fpp_stat ;		/* FPP status register		*/
extern	UWORD	fpp_ac [6] ;		/* FPP FAC in pdp8 format	*/
extern	UINT	fpp_pc ;		/* FPP program counter		*/
extern	UINT	fpp_x0 ;		/* FPP index register location	*/
extern	UINT	fpp_br ;		/* FPP base register		*/
extern	UINT	fpp_opadd ;		/* FPP operand address		*/
/*
 *	100 Hz clock (DK8E-C, PDP8-A, VT/78, VT/278)
 */
extern	UBYTE	clocktype ;
extern	LONG	tickspersec ;		/* Real time clock ticks/second	*/
/*
 *	Console VDU
 */
extern	UBYTE	coninchar , conoutchar ;
/*
 *	Auxilliary VDU
 */
extern	UBYTE	aux_vdu ;
extern	UBYTE	auxinchar , auxoutchar ;
/*
 *	PT8-E Reader/Punch
 */
extern	FILE	*pt8reader ;
extern	UBYTE	pt8rdrbuffer ;
extern	BYTE	*ptrtape [16] ;
extern	INT	itape ;
extern	FILE	*pt8punch ;
extern	UBYTE	pt8punbuffer ;
extern	BYTE	*ptptape [16] ;
extern	INT	otape ;
/*
 *	LP8-E Line Printer
 */
extern	FILE	*lp8printer ;
extern	UBYTE	printCHAR  ;
/*
 *	RK8-E Disk System Registers
 */
extern	BYTE	*rk8file [4] ;
extern	UINT	rk8command ;
extern	UINT	rk8curaddr ;
extern	UINT	rk8block ;
extern	UINT	rk8status ;
extern	struct
	{
	    FILE *drive ;
	    UBYTE *buff ;
	    INT cyl ;
	    INT maxcyl ;
	    UBYTE dirty ;
	} rk8 [4] ;
extern	INT	rk8unit ;
extern	INT	rk8words ;
extern	INT	rk8count ;
extern	UBYTE	rk8lock ;
extern	UBYTE	rk8write ;
/*
 *	RX50 Disk System Registers
 */
extern	UBYTE	rx50 ;			/* RX50 presence flag		*/
extern	BYTE	*rx5file [2] ;
extern	UINT	rx5command ;
extern	UINT	rx5curaddr ;
extern	UINT	rx5block ;
extern	UINT	rx5status ;
extern	struct
	{
	    FILE *drive ;
	    UBYTE *buff ;
	    INT cyl ;
	    INT maxcyl ;
	    UBYTE dirty ;
	} rx5 [2] ;
extern	INT	rx5unit ;
extern	INT	rx5words ;
extern	INT	rx5count ;
extern	UBYTE	rx5lock ;
extern	UBYTE	rx5write ;
/*
 *	Miscellaneous variables used by the emulator.
 */
extern	BYTE	chrsout [400], pdp8exec [100] ;
extern	UBYTE	run ;
extern	UBYTE	delay ;			/* Delay after ION		*/
extern	ULONG	int_mask ;		/* Interrupt request mask	*/
extern	UBYTE	incrPC ;		/* Used by disassem & in pdp8.c	*/
extern	UINT	lastPC ;		/* Used in tracing		*/
extern	UINT	os8date ;		/* Used to store OS/8 date	*/
extern	UBYTE	breakflag ;
extern	UBYTE	tabulate ;
extern	UBYTE	profile ;
extern	UBYTE	checkvdus ;
extern	INT	clkcntr ;
extern	LONG	curtime, ticks, ticktime ;
extern	UWORD	addrmask, instmask ;
extern	UWORD	breakaddr, breakinst ;
extern	FILE	*tabfile, *histofile ;
extern	ULONG	*tab, *histo ;
extern	ULONG	exec ;
extern	INT	diag ;
extern	LONG	trace ;
extern	union
	{
	    DOUBLE d ;
	    FLOAT f [2] ;
	    ULONG l [2] ;
	    UWORD w [4] ;
	    UBYTE b [8] ;
	} order ;
/*
 *	Various output files.
 */
extern	FILE	*pdp8conout ;		/* pdp8 console output file	*/
extern	FILE	*pdp8auxout ;		/* pdp8 aux console output file	*/
extern	FILE	*tracefile ;		/* trace output file		*/
/*
 *	pdp8 memory
 */
extern	FILE	*pdp8file ;		/* pdp8 memory storage file	*/
extern	UWORD	mem32k [8L * 4096] ;
/* -------------------------------------------------------------------- */
