;	THIS WILL REVERSE THE PASSED STRING, IE HELLO THERE
;	BECOMES - EREHT OLLEH.
;
;	THE ASM FILE MUST BE A 'COM' TYPE, THE CODE, DATA, EXTRA
;	SEGMENTS ARE THE SAME AT LOAD TIME. FIRST ASSEMBLE THE
;	SOURCE USING ASM OR MASM, THEN LINK AND CONVERT IT:
;
;		MASM TESTEXEC;
;		LINK TESTEXEC;
;		EXE2BIN TESTEXEC
;
;	REGISTER VALUES ON ENTRY:
;
;		DS - QNE DATA SEGMENT (USE FOR PARAMTER PASSING)
;		ES - QNE DATA SEGMENT (DITTO)
;		SI - POINTER TO PASSED STRING
;		CX - LENGTH OF PASSED STRING (MAX 255)
;		DI - POINTER TO ADDRESS TO COPY RESULT STRING
;
;	REGISTER VALUES ON EXIT:
;
;		CX - RESULT STRING LENGTH (MAX 255)
;
;	REMEMBER TO SET THE DS AND ES REGISTERS WHEN GETTING OR
;	PUTTING A PARAMETER TO THE RUNTIME.
;
;	THE ONLY REGISTERS THAT MUST NOT BE DESTROYED ARE THE
;	STACK POINTER AND STACK SEGMENT (SP & SS) AND THE DS AND
;	ES SEGMENT REGISTERS. THE MAXIMUM PASSED AND RETURNED STRING
;	LENGTHS ARE 255 CHARACTERS.
;
CODE		SEGMENT	BYTE PUBLIC 'CODE'
		ASSUME	CS:CODE,DS:CODE,ES:CODE

START		PROC	FAR
; OFFSET 0 - GET VERSION ENTRY
		CALL	GET_VER
		RET			;FAR RETURN
; OFFSET 4 - SWAP STRING ENTRY
		CALL	SWAP_IT
		RET
; OFFSET 8 - FORCE ERROR ENTRY
		POP	AX		;CLEAR NORMAL OFFSET
		POP	AX		;CLEAR NORMAL SEGMENT
		RET			;RETURNS TO ERROR HANDELER 
START		ENDP
;
;	RETURN CURRENT VERSION OF THIS PROGRAM
;
VER_MSG		DB	'5 MAR 84'
VER_LEN		EQU	8
;
GET_VER		PROC	NEAR
		CALL	SAVE_PARM	;SAVE PASSED PARAMETERS
		MOV	CX,VER_LEN	;MOVE VERSION STRING TO RUNTIME
		MOV	DI,DPTR		;DESTINATION OFFSET
		PUSH	ES
		MOV	ES,ES_SAVE	;RUNTIME SEGMENT VALUE
		MOV	SI,OFFSET VER_MSG
		REP	MOVSB		;MOVE IT
		POP	ES
		CALL	RESTORE		;CLEAN UP
		MOV	CX,VER_LEN	;LENGTH OF RETURNED STRING
		RET
GET_VER		ENDP
;
;	SWAP STRING (MAKE READ RIGHT TO LEFT)
;
SWAP_IT		PROC	NEAR
		CALL	SAVE_PARM
		MOV	SI,SPTR
		MOV	CX,SLEN
		MOV	DI,OFFSET BUFF
		ADD	DI,CX		;FILL BUFFER BACKWARDS
		DEC	DI
		PUSH	DS
		MOV	DS,DS_SAVE	;GET BACK QNE DATA SEG
		CLD			;CLEAR DIRECTION FLAG
REVERSE_LP:
		LODSB			;GET A CHAR FROM THE SOURCE
		MOV	ES:[DI],AL	;PUT A CHAR TO THE DESTINATION
		DEC	DI
		LOOP	REVERSE_LP	;LOOP TILL SOURCE EXHAUSTED
		POP	DS
		MOV	CX,SLEN		;GET STRING LENGTH
		MOV	SI,OFFSET BUFF	;SET SOURCE TO BUFFER
LJUST_LP:	MOV	AL,[SI]		;LEFT JUSTIFY RESULTS
		CMP	AL,' '
		JNE	LJUST_ELP	;EXIT IF NON SPACE
		DEC	CX
		JZ	LJUST_ELP	;OR IF NO MORE CHAR IN BUFFER
		INC	SI
		JMP	SHORT LJUST_LP
LJUST_ELP:
		PUSH	CX		;SAVE FOR RETURN
		MOV	DI,DPTR		;POINTS TO QNE RETURNED STRING AREA
		PUSH	ES		;SET TO RUNTIME VALUE
		MOV	ES,ES_SAVE
		REP	MOVSB		;MOVE BUFFER TO RUNTIME
		POP	ES
		CALL	RESTORE		;CLEAN UP
		POP	CX		;RETURNED STRING LENGTH
		RET
SWAP_IT		ENDP
;
;	SAVE PARAMETERS
;
SAVE_PARM	PROC	NEAR
		MOV	CS:DS_SAVE,DS	;SAVE DATA SEGMENT REGS
		MOV	CS:ES_SAVE,ES
		MOV	AX,CS		;SET DATA SEGMENTS TO THIS
		MOV	DS,AX		;PROGRAMS AREA
		MOV	ES,AX
		MOV	SPTR,SI		;SAVE PASSED STRING POINTER
		MOV	SLEN,CX		;AND ITS LENGTH ALSO
		MOV	DPTR,DI		;SAVE RETURN VALUE STRING POINTER
		RET
SAVE_PARM	ENDP
;
;	RESTORE SEGMENT VALUES FOR RETURN TO RUNTIME
;
RESTORE		PROC	NEAR
		MOV	ES,ES_SAVE
		MOV	DS,DS_SAVE
		RET
RESTORE		ENDP
;
;	DATA AREA
;
DS_SAVE		DW	0
ES_SAVE		DW	0
DPTR		DW	0
SPTR		DW	0
SLEN		DW	0
BUFF		DB	255 DUP(0)	;BUFFER FOR MAX STRING LEN

CODE		ENDS

		END

