package REXX;

use Carp;
require REXXCALL;
require Exporter;
@ISA = (REXXCALL, Exporter);
@EXPORT = qw();
@EXPORT_OK = qw();

@libs = split(/;/, $ENV{'PERL5REXX'} || $ENV{'PERLREXX'} || $ENV{'PATH'});

sub load
{
	confess 'Usage: load REXX <file> [<dirs>]' unless $#_ >= 1;
	my ($class, $file, @where) = (@_, @libs);
	my $handle;
	foreach (@where) {
		$handle = DynaLoader::dl_load_file("$_/$file.dll");
		last if $handle;
	}
	eval "package REXX::$file; \@ISA = REXX; 1;" or die "eval package";
	return bless {'handle' => $handle, 'file' => $file}, "REXX::$file" if $handle;
	return undef;
}

sub find
{
	my $self = shift;
	my $handle = $self->{'handle'};
	my ($ucname, $addr);
	foreach (@_) {
		$ucname = uc $_;
		$addr = $self->{$ucname};
		if (!$addr) {
			$addr = DynaLoader::dl_find_symbol($handle, $ucname)
				or return 0;
			$self->{$ucname} = $addr;
		}
	}
	return $addr;
}

AUTOLOAD
{
	my ($self) = @_;
	$AUTOLOAD =~ /^(REXX::.*)::(.*)$/ or return undef;
	return undef if $2 eq "DESTROY";
	my $addr = $self->find($2);
	confess("Unkown entry '$2' called in DLL '$self->{'file'}'")
		unless $addr;
	eval "package $1; sub $2 { shift; REXXCALL::call('$2', $addr, 'SESSION', \@_); } 1;"
		or die "eval sub";
	goto &$AUTOLOAD;
}

sub TIESCALAR
{
	my ($obj, $name) = @_;
	$name = uc $name;
	return bless \$name, REXX::_SCALAR;
}	

sub TIEARRAY
{
	my ($obj, $name) = @_;
	return bless [uc $name, 0], REXX::_ARRAY;
}

sub TIEHASH
{
	my ($obj, $name) = @_;
	return bless {'stem' => uc $name}, REXX::_HASH;
}

#############################################################################
package REXX::_SCALAR;

sub FETCH
{
	return REXXCALL::fetch(${$_[0]});
}

sub STORE
{
	return REXXCALL::set(${$_[0]}, $_[1]);
}

sub DESTROY
{
	return REXXCALL::drop(${$_[0]});
}

#############################################################################
package REXX::_ARRAY;

sub FETCH
{
	$_[0]->[1] = $_[1] if $_[1] > $_[0]->[1];
	return REXXCALL::fetch($_[0]->[0].'.'.(0+$_[1]));
}

sub STORE
{
	$_[0]->[1] = $_[1] if $_[1] > $_[0]->[1];
	return REXXCALL::set($_[0]->[0].'.'.(0+$_[1]), $_[2]);
}

#############################################################################
package REXX::_HASH;

require TieHash;
@ISA = TieHash;

sub FIRSTKEY
{
	my ($self) = @_;
	my $stem = $self->{'stem'};

	delete $self->{'list'} if exists $self->{'list'};

	my @list = ();
	my ($name, $value);
	REXXCALL::fetch('DUMMY'); # resets REXX's first/next iterator
	while (($name) = REXXCALL::next($stem)) {
		push @list, $name;
	}
	my $key = pop @list;

	$self->{'list'} = \@list;
	return $key;
}

sub NEXTKEY
{
	return pop @{$_[0]->{'list'}};
}

sub EXISTS
{
	return defined REXXCALL::fetch($_[0]->{'stem'}.$_[1]);
}

sub FETCH
{
	return REXXCALL::fetch($_[0]->{'stem'}.$_[1]);
}

sub STORE
{
	return REXXCALL::set($_[0]->{'stem'}.$_[1], $_[2]);
}

sub DELETE
{
	REXXCALL::drop($_[0]->{'stem'}.$_[1]);
}
