#
# Expects:
#	EXT=name	Module name, set in command line
#	EXTLIBS=...	optional libraries for EXT
#

TOP	= ../..
PERL	= $(TOP)/miniperl
AUTO	= $(TOP)/lib/auto

CC	= gcc
OPTIM	= -O2
DEBUG	=

CFLAGS	= $(OPTIM) $(DEBUG) -Zomf -I$(TOP) -DEMBED
LDFLAGS	= $(OPTIM) $(DEBUG) -Zomf -Zdll -Zcrtdll
LDLIBS	= $(EXTLIBS) $(TOP)/perl5.lib

DLL	= $(AUTO)/$(EXT)/$(EXT).dll
PM	= $(TOP)/lib/$(EXT).pm
BOOT	= $(AUTO)/$(EXT)/$(EXT).bs

.INCLUDE .IGNORE : ../../os2/$(EXT).mk

all : $(DLL) $(PM) $(BOOT)

$(DLL) : $(EXT).obj $(EXT).def
	$(CC) $(LDFLAGS) $(EXT).obj $(EXT).def $(LDLIBS) -o $@

$(PM) :	$(EXT).pm
[
	cp $(EXT).pm $@
	cd $(TOP)
	miniperl autosplit $(EXT)
]

$(BOOT) :
[
	$(PERL) -I$(TOP)/lib $(TOP)/ext/util/mkbootstrap
	touch $(EXT).bs
	cp -t $(EXT).bs $@
]

$(EXT).def :
[
	echo "LIBRARY '$(EXT)' INITINSTANCE TERMINSTANCE" > $@
	echo "CODE LOADONCALL" >> $@
	echo "DATA LOADONCALL NONSHARED MULTIPLE" >> $@
	echo "EXPORTS" >> $@
	echo "  boot_$(EXT)" >> $@
]

$(EXT).c : $(EXT).xs
[
	if [ -f typemap ]
	then
		$(PERL) $(TOP)/ext/xsubpp -typemap typemap $(EXT).xs > $@
	else
		$(PERL) $(TOP)/ext/xsubpp $(EXT).xs > $@
	fi
]

cleanup :
	-$(RM) $(RMFLAGS) $(DLL) $(EXT).def $(EXT).c $(EXT).obj
