extproc perl5 -Sx
#! perl
'di ';
'ds 00 \"';
'ig 00 ';

use Getopt::Std;

$usage='h2xs [-Aachfm] [-I include-dir] [-n module_name] [headerfile [extra_libraries]]
	-a	Omit AutoLoad facilities from .pm file.
	-c	Omit the constant() function from the XS file.
	-A	Equivalent to -a -c 
	-f	Force creation of the extension even if the C header does not exist.
	-m	Also create an old-style Makefile.SH
	-h 	help
	-n	Specify a name to use for the extension.
	-I	Specify directory of include-file.
extra_libraries are any libraries that might be needed for loading
	the extension, e.g. -lm would try to link in the math library.
';

sub usage{ die "Usage: $usage\n" }

getopts("fhcaAmn:I:") || &usage;

&usage if $opt_h;

if( @ARGV ){
	$path_h = shift;
}
elsif( ! @ARGV && ! $opt_n ){
	die "Must supply header file or module name\n";
}

$extralibs = "@ARGV";
if( $opt_A ){
	$opt_a = $opt_c = 1;
}
$write_makefile_sh = ($opt_m) ? 1 : 0;

if( $path_h ){
	$name = $path_h;
	if( $path_h =~ s#::#/#g && $opt_n ){
		warn "Nesting of headerfile ignored with -n\n";
	}
	$path_h .= ".h" unless $path_h =~ /\.h$/;
	$path_h = "$opt_I/$path_h" if $opt_I;
	die "Can't find $path_h\n" if( ! $opt_f && ! -f $path_h );
}

$module = $opt_n || do {
	$name =~ s/\.h$//;
	if( $name !~ /::/ ){
		$name =~ s#^.*/##;
		$name = "\u$name";
	}
	$name;
};

chdir 'ext' if -d 'ext';

if( $module =~ /::/ ){
	$nested = 1;
	@modparts = split(/::/,$module);
	$modfname = $modparts[-1];
	$modpname = join('/',@modparts);
}
else {
	$nested = 0;
	@modparts = ();
	$modfname = $modpname = $module;
}


die "Won't overwrite existing ext/$modpname\n" if -e $modpname;
# quick hack, should really loop over @modparts
mkdir($modparts[0], 0777) if $nested;
mkdir($modpname, 0777);
chdir($modpname) || die "Can't chdir ext/$modpname: $!\n";

open(XS, ">$modfname.xs") || die "Can't create ext/$modpname/$modfname.xs: $!\n";
open(PM, ">$modfname.pm") || die "Can't create ext/$modpname/$modfname.pm: $!\n";


if( -r $path_h ){
    open(CH, "<$path_h") || die "Can't open $path_h: $!\n";
    while (<CH>) {
	if (/^#[ \t]*define\s+(\w+)\b\s*[^("]/) {
	    $_ = $1;
	    next if /^_.*_h_*$/i;
	    $names{$_}++;
	    @AZ = 'A' .. 'Z' if !@AZ && /^[A-Z]/;
	    @az = 'a' .. 'z' if !@az && /^[a-z]/;
	    @under = '_' if !@under && /^_/;
	}
    }
    close(CH);
    @names = sort keys %names;
} else { die "hmm..."; }


$" = "\n\t";
warn "Writing ext/$modpname/$modfname.pm\n";

if( ! $opt_a ){
print PM <<"END";
package $module;

require Exporter;
require AutoLoader;
require DynaLoader;
\@ISA = qw(Exporter AutoLoader DynaLoader);
# Items to export into callers namespace by default
# (move infrequently used names to \@EXPORT_OK below)
\@EXPORT = qw(
	@names
);
# Other items we are prepared to export if requested
\@EXPORT_OK = qw(
);

sub AUTOLOAD {
    if (\@_ > 1) {
	\$AutoLoader::AUTOLOAD = \$AUTOLOAD;
	goto &AutoLoader::AUTOLOAD;
    }
    local(\$constname);
    (\$constname = \$AUTOLOAD) =~ s/.*:://;
    \$val = constant(\$constname, \@_ ? \$_[0] : 0);
    if (\$! != 0) {
	if (\$! =~ /Invalid/) {
	    \$AutoLoader::AUTOLOAD = \$AUTOLOAD;
	    goto &AutoLoader::AUTOLOAD;
	}
	else {
	    (\$pack,\$file,\$line) = caller;
	    die "Your vendor has not defined $module macro \$constname, used at \$file line \$line.\n";
	}
    }
    eval "sub \$AUTOLOAD { \$val }";
    goto &\$AUTOLOAD;
}

bootstrap $module;

# Preloaded methods go here.  Autoload methods go after __END__, and are
# processed by the autosplit program.

1;
__END__
END
}
else{
print PM <<"END";
package $module;

require Exporter;
require DynaLoader;
\@ISA = qw(Exporter DynaLoader);
# Items to export into callers namespace by default
\@EXPORT = qw();
# Other items we are prepared to export if requested
\@EXPORT_OK = qw();


bootstrap $module;

1;
END
}

close PM;

warn "Writing ext/$modpname/$modfname.xs\n";
print XS <<"END";
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

END
if( $path_h ){
	my($h) = $path_h;
	$h =~ s#^/usr/include/##;
print XS <<"END";
#include <$h>

END
}

if( ! $opt_c ){
print XS <<"END";
static int
not_here(s)
char *s;
{
    croak("$module::%s not implemented on this architecture", s);
    return -1;
}

static double
constant(name, arg)
char *name;
int arg;
{
    errno = 0;
    switch (*name) {
END

foreach $letter (@AZ, @az, @under) {

    last if $letter eq 'a' && !@names;

    print XS "    case '$letter':\n";
    my($name);
    while (substr($names[0],0,1) eq $letter) {
	$name = shift(@names);
	print XS <<"END";
	if (strEQ(name, "$name"))
#ifdef $name
	    return $name;
#else
	    goto not_there;
#endif
END
    }
    print XS <<"END";
	break;
END
}
print XS <<"END";
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}


MODULE = $module		PACKAGE = $module

double
constant(name,arg)
	char *		name
	int		arg

END
}
else{
print XS <<"END";

MODULE = $module		PACKAGE = $module

END
}

close XS;

{
warn "Writing ext/$modpname/Makefile.PL\n";
open(PL, ">Makefile.PL") || die "Can't create ext/$modpname/Makefile.PL: $!\n";

# Ideally this should have a #!../.. ... miniperl etc header
print PL <<'END';
use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile being created.
END
print PL "&writeMakefile(\n";
print PL "	'potential_libs' => '$extralibs',   # e.g., '-lm' \n";
print PL "	'INC' => '',     # e.g., '-I/usr/include/other' \n";
print PL "	'DISTNAME' => 'myname',\n";
print PL "	'VERSION' => '0.1',\n";
print PL ");\n";
}

if ($write_makefile_sh){
warn "Writing ext/$modpname/Makefile.SH\n";
open(MF, ">Makefile.SH") || die "Can't create ext/$modpname/Makefile.SH: $!\n";
print MF <<'END';
: This forces SH files to create target in same directory as SH file.
: This is so that make depend always knows where to find SH derivatives.

case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac

if test -f config.sh; then TOP=.;
elif test -f ../config.sh; then TOP=..;
elif test -f ../../config.sh; then TOP=../..;
elif test -f ../../../config.sh; then TOP=../../..;
elif test -f ../../../../config.sh; then TOP=../../../..;
else
	echo "Can't find config.sh."; exit 1
fi

: Find absolute path name for TOP.  This is needed when we cd to TOP
: to run perl on autosplit.
oldpwd=`pwd`; cd $TOP; ABSTOP=`pwd`; cd $oldpwd

case $CONFIG in
'')
	. $TOP/config.sh
	;;
esac

: Find out directory name.  This is also the extension name.
ext=`pwd | $sed -e 's@.*/@@'`

: This extension might have its own typemap
if test -f typemap; then
	exttypemap='typemap'
else
	exttypemap=''
fi

: This extension might need additional libraries.
END
print MF "potential_libs=\"$extralibs\"\n";
print MF <<'END';
. $TOP/ext/util/extliblist

: This extension might need bootstrap support
if test -f ${ext}_BS; then
	bootdep=${ext}_BS
else
	bootdep=''
fi

case "$dlsrc" in
dl_aix*)
    echo "#!" > $ext.exp
    echo "boot_$ext" >> $ext.exp
    ;;
esac

echo "Extracting ext/$ext/Makefile (with variable substitutions)"
: This section of the file will have variable substitutions done on it.
: Move anything that needs config subs from !NO!SUBS! section to !GROK!THIS!.
: Protect any dollar signs and backticks that you do not want interpreted
: by putting a backslash in front.  You may delete these comments.
$spitshell >Makefile << !GROK!THIS!
#
# This Makefile is for the $ext extension to perl.
# 
CC = $cc
RANLIB = $ranlib
TOP = $TOP
ABSTOP = $ABSTOP
LDFLAGS = $ldflags
CLDFLAGS = $ldflags
SMALL = $small
LARGE = $large $split

# To use an alternate make, set \\$altmake in config.sh.
MAKE = ${altmake-make}

EXT = $ext

# $ext might have its own typemap
EXTTYPEMAP = $exttypemap

# $ext might have its own bootstrap support
BOOTDEP  = $bootdep
BOOTSTRAP  = $ext.bs

# The following are used to build and install shared libraries for
# dynamic loading.
LDDLFLAGS = $lddlflags
CCDLFLAGS = $ccdlflags
CCCDLFLAGS = $cccdlflags
SO = $so

# $ext might need to be linked with some extra libraries.
# EXTRALIBS =  full list of libraries needed for static linking.
#		Only those libraries that actually exist are included.
# DYNLOADLIBS = list of those libraries that are needed but can be
#		linked in dynamically on this platform.  On SunOS, for
#		example, this would be .so* libraries, but not archive
#		libraries.  The bootstrap file is installed only if
#		this list is not empty.
# STATLOADLIBS = list of those libraries which must be statically
#		linked into the shared library.  On SunOS 4.1.3, 
#		for example,  I have only an archive version of
#		-lm, and it must be linked in statically.
EXTRALIBS = $extralibs
DYNALOADLIBS  = $dynaloadlibs
STATLOADLIBS = $statloadlibs

!GROK!THIS!

$spitshell >>Makefile <<'!NO!SUBS!'

# Where to put things:
AUTO = $(TOP)/lib/auto
INSTALLBOOT = $(AUTO)/$(EXT)/$(EXT).bs
INSTALLDYNAMIC = $(AUTO)/$(EXT)/$(EXT).$(SO)
INSTALLSTATIC = $(EXT).a
INSTALLPM = $(TOP)/lib/$(EXT).pm

PERL = $(ABSTOP)/miniperl
XSUBPP = $(TOP)/ext/xsubpp
SHELL = /bin/sh
CCCMD = `sh $(shellflags) $(TOP)/cflags $@`

.c.o:
	$(CCCMD) $(CCCDLFLAGS) -I$(TOP) $*.c

all:	dynamic
# Phony target to force checking subdirectories.
FORCE:

# Target for Dynamic Loading:
dynamic:	$(INSTALLDYNAMIC) $(INSTALLPM) $(INSTALLBOOT)

$(INSTALLDYNAMIC): $(EXT).o
	@test -d $(AUTO) || mkdir $(AUTO)
	@test -d $(AUTO)/$(EXT) || mkdir $(AUTO)/$(EXT)
	ld $(LDDLFLAGS) -o $@ $(EXT).o $(STATLOADLIBS)

$(BOOTSTRAP):	Makefile $(BOOTDEP)
	$(PERL) -I$(TOP)/lib $(TOP)/ext/util/mkbootstrap $(DYNALOADLIBS)
	touch $(BOOTSTRAP)

$(INSTALLBOOT):	$(BOOTSTRAP)
	@test ! -s $(BOOTSTRAP) || cp $(BOOTSTRAP) $@

# Target for Static Loading:
static: $(INSTALLSTATIC) $(INSTALLPM)

$(INSTALLSTATIC):	$(EXT).o
	ar cr $@ $(EXT).o
	$(RANLIB) $@
	echo $(EXTRALIBS) >> $(TOP)/ext.libs

$(EXT).c:	$(EXT).xs $(XSUBPP) $(TOP)/ext/typemap $(EXTTYPEMAP) $(TOP)/cflags Makefile
	$(PERL) $(XSUBPP) $(EXT).xs >tmp
	mv tmp $@

END
if( ! $opt_a ){
print MF <<'END';
$(INSTALLPM):	$(EXT).pm
	rm -f $@
	cp $(EXT).pm $@
	cd $(TOP); $(PERL) autosplit $(EXT)
END
}
else {
print MF <<'END';
$(INSTALLPM):	$(EXT).pm
	cp $(EXT).pm $@
END
}
print MF <<'END';

clean:
	rm -f *.o *.a mon.out core $(EXT).c so_locations $(BOOTSTRAP) $(EXT).exp

realclean: 	clean
	rm -f makefile Makefile
	rm -f $(INSTALLPM) $(INSTALLDYNAMIC) $(INSTALLSTATIC) $(INSTALLBOOT)
	rm -rf $(AUTO)/$(EXT)

purge:	realclean

$(EXT).o :	$(TOP)/EXTERN.h
$(EXT).o :	$(TOP)/perl.h
$(EXT).o :	$(TOP)/embed.h
$(EXT).o :	$(TOP)/config.h
$(EXT).o :	$(TOP)/unixish.h
$(EXT).o :	$(TOP)/handy.h
$(EXT).o :	$(TOP)/regexp.h
$(EXT).o :	$(TOP)/sv.h
$(EXT).o :	$(TOP)/util.h
$(EXT).o :	$(TOP)/form.h
$(EXT).o :	$(TOP)/gv.h
$(EXT).o :	$(TOP)/cv.h
$(EXT).o :	$(TOP)/opcode.h
$(EXT).o :	$(TOP)/op.h
$(EXT).o :	$(TOP)/cop.h
$(EXT).o :	$(TOP)/av.h
$(EXT).o :	$(TOP)/hv.h
$(EXT).o :	$(TOP)/mg.h
$(EXT).o :	$(TOP)/scope.h
$(EXT).o :	$(TOP)/pp.h
$(EXT).o :	$(TOP)/proto.h
$(EXT).o :	$(TOP)/XSUB.h 

Makefile:	Makefile.SH $(TOP)/config.sh ; /bin/sh Makefile.SH
$(TOP)/config.h:	$(TOP)/config.sh; cd $(TOP); /bin/sh config_h.SH
$(TOP)/embed.h:	$(TOP)/config.sh; cd $(TOP); /bin/sh embed_h.SH
$(TOP)/cflags:	$(TOP)/config.sh; cd $(TOP); /bin/sh cflags.SH

!NO!SUBS!
chmod 755 Makefile
$eunicefix Makefile

END
close MF;
}

system 'ls -1 > MANIFEST';

# this needs fixing
# system '[ -f Makefile.SH ] && sh Makefile.SH';
# system '[ -f Makefile.PL ] && perl Makefile.PL';


##############################################################################

	# These next few lines are legal in both Perl and nroff.

.00 ;			# finish .ig
 
'di			\" finish diversion--previous line must be blank
.nr nl 0-1		\" fake up transition to first page again
.nr % 0			\" start at page 1
'; __END__ ############# From here on it's a standard manual page ############
.TH H2XS 1 "August 9, 1994"
.AT 3
.SH NAME
h2xs \- convert .h C header files to Perl extensions
.SH SYNOPSIS
.B h2xs [-Aachfm] [-n module_name] [headerfile [extra_libraries]]
.SH DESCRIPTION
.I h2xs
builds a Perl extension from any C header file.  The extension will include
functions which can be used to retrieve the value of any #define statement
which was in the C header.
.PP
The 
.I module_name
will be used for the name of the extension.  If module_name is not supplied
then the name of the header file will be used, with the first character
capitalized.
.PP
If the extension might need extra libraries, they should be included
here.  The extension Makefile.SH will take care of checking whether
the libraries actually exist and how they should be loaded.
The extra libraries should be specified in the form -lm -lposix, etc,
just as on the cc command line.  By default, the Makefile.SH will
search through the library path determined by Configure.  That path
can be augmented by including arguments of the form -L/another/library/path
in the extra-libraries argument.
.SH OPTIONS
.TP
.B \-f
Allows an extension to be created for a header even if that
header is not found in /usr/include.
.TP
.B \-a
Omit AutoLoad(), AUTOLOAD, and autosplit from the .pm and Makefile files.
.TP
.B \-c
Omit constant() from the .xs file.
.TP
.B \-n module_name
Specifies a name to be used for the extension.
.TP
.B \-A
Turns on both -a and -c.
.TP
.B \-m
Causes an old-style Makefile.SH to be created.
.SH EXAMPLES
.nf

	# Default behavior, extension is Rusers
	h2xs rpcsvc/rusers

	# Same, but extension is RUSERS
	h2xs -n RUSERS rpcsvc/rusers

	# Extension is rpcsvc::rusers. Still finds <rpcsvc/rusers.h>
	h2xs rpcsvc::rusers

	# Extension is ONC::RPC.  Still finds <rpcsvc/rusers.h>
	h2xs -n ONC::RPC rpcsvc/rusers

	# Without AUTOLOAD, AutoLoad, autosplit
	h2xs -a rpcsvc/rusers

	# Creates templates for an extension named RPC
	h2xs -Afn RPC

	# Extension is ONC::RPC.
	h2xs -An ONC::RPC

	# Makefile.SH will look for library -lrpc in 
	# additional directory /opt/net/lib
	h2xs rpcsvc/rusers -L/opt/net/lib -lrpc

.fi
.SH ENVIRONMENT
No environment variables are used.
.SH AUTHOR
Larry Wall
.SH "SEE ALSO"
perl(1)
.SH DIAGNOSTICS
The usual warnings if it can't read or write the files involved.
.ex
