CC	= gcc
OPTIM	= -O3 -m486 -fomit-frame-pointer
DEBUG	=
D	=

EMX	= h:/emx
OMFLD	= emxomfld -Zstack 384 $(EMX)/lib/crt0.obj $(EMX)/lib/ctor.obj $(EMX)/lib/dtor.obj -L$(EMX)/lib/st -L$(EMX)/lib

CFLAGS	= $(OPTIM) $(DEBUG) -Zomf -DEMBED -DHIDEMYMALLOC -DDOSISH -DOS2=2 -I. -Ios2 $D
LDFLAGS	= $(OPTIM) $(DEBUG) -Zomf -Zcrtdll -Zstack 384
LDLIBS	= -lsocket -lm -lbsd

modules	= Fcntl GDBM_File SDBM_File POSIX Socket UPM REXXCALL

mallocobj = malloc.obj
obj1 = $(mallocobj) gv.obj toke.obj perly.obj op.obj regcomp.obj dump.obj util.obj mg.obj
obj2 = hv.obj av.obj run.obj pp_hot.obj sv.obj pp.obj scope.obj pp_ctl.obj pp_sys.obj
obj3 = doop.obj doio.obj regexec.obj taint.obj deb.obj perl.obj os2.obj
objs = $(obj1) $(obj2) $(obj3)

exts = DynaLoader.obj

.SOURCE.c : os2 ext/DynaLoader

all : config.h preplibrary perl5.dll perl5.lib perl5.exe lib/Config.pm modules

mini : miniperl.exe

miniperl.exe miniperl.map .UPDATEALL : miniperlmain.obj $(objs)
	$(CC) $(LDFLAGS) miniperlmain.obj $(objs) $(LDLIBS) -Zmap -Zlinker /map -o $@

perl5.exe : os2main.obj perl5.lib
	$(CC) $(LDFLAGS) os2main.obj perl5.lib -o $@

perl5.dll : $(objs) data.obj $(exts) perl5.def
	$(CC) $(LDFLAGS) -Zdll $(objs) data.obj $(exts) perl5.def $(LDLIBS) -o $@

perl5.lib : perl5.def
	implib /noign $@ perl5.def

perl5.def : os2/perl5hdr.def miniperl.map os2/mkdef.pl
	cat os2/perl5hdr.def > $@
	.\miniperl -n os2/mkdef.pl miniperl.map | sort -u - >>perl5.def

preplibrary : miniperl.exe lib/Config.pm config.sh
	-mkdir lib/auto
	@echo "	AutoSplitting perl library"
	find lib -name "*.pm" -print >tmp
	.\miniperl -Ilib -e "use AutoSplit; autosplit_lib_modules(@ARGV)" @tmp
	-$(RM) $(RMFLAGS) tmp

config.h : config.sh
	ksh config_h.sh

lib/Config.pm : config.sh miniperl.exe
	.\miniperl.exe configpm

DynaLoader.c .SETDIR=ext/DynaLoader : dl_os2.xs
	..\..\miniperl ../xsubpp dl_os2.xs > DynaLoader.c

modules :
	cmd /c "for %x in ($(modules)) do call os2\ext %x"

#############################################################################

install : perl5.exe perl5.dll os2/h2xs.cmd
	-cp -t $? $(ROOTDIR)/usr/binp
