use REXX;

$db2 = load REXX "sqlar", "g:/sqllib/dll" or die "load";
tie $sqlcode, REXX, "sqlca.sqlcode";
tie $sqlstate, REXX, "sqlca.sqlstate";

sub stmt
{
	my ($s) = @_;
	$s =~ s/\s*\n\s*/ /g;
	$s =~ s/^\s+//;
	$s =~ s/\s+$//;
	return $s;
}

sub sql
{
	my ($stmt) = stmt(@_);
	return 0 if $db2->sqlexec($stmt);
	return $sqlcode >= 0;
}

sub dbs
{
	my ($stmt) = stmt(@_);
	return 0 if $db2->sqldbs($stmt);
	return $sqlcode >= 0;
}

sub error
{
	my ($where) = @_;
	my $msg;
	print "ERROR in $where: sqlcode=", $sqlcode, " sqlstate=", $sqlstate, "\n";
	dbs("GET MESSAGE INTO :msg LINEWIDTH 75");
	tie $msg, REXX, "msg";
	print "\n", $msg;
	exit 1;
}

sql(<<) or error("connect");
     CONNECT TO sample IN SHARE MODE

REXXCALL::set("STMT" => stmt(<<));
     SELECT name FROM sysibm.systables

sql(<<) or error("prepare");
     PREPARE s1 FROM :stmt

sql(<<) or error("declare");
     DECLARE c1 CURSOR FOR s1

sql(<<) or error("open");
     OPEN c1

tie $name, REXX, "name";
while (1) {
     sql(<<) or error("fetch");
          FETCH c1 INTO :name

     last if $sqlcode == 100;

     print "Table name is $name\n";
}
	
sql(<<) or error("close");
     CLOSE c1

sql(<<) or error("rollback");
     ROLLBACK

sql(<<) or error("disconnect");
     CONNECT RESET

exit 0;
