/**********************************************************************
PopCliD.cmd - popclient Daemon                
Copyright:
    Claudio Fahey claudio@uclink.berkeley.edu, 1994 and 
    Clark Gaylord (cgaylord@vt.edu), 1995.

User is licensed to use this program, associated programs, and
documentation in any way provided that:
1) attribution of program source is maintained
2) copyright notices are maintained
3) changes made by user are clearly documented.
Note that popclient.exe, popclient.c, and associated files are 
copyright by Carl Harris; see the documentation for further 
information regarding the licensing of popclient itself.
                                              
Procedures GetArg, ArgCheck, Help, Elm support and other changes:                       
Clark K. Gaylord (cgaylord@vt.edu)
Version 2.21a: 18 January 1995
        2.21b: 25 March 1995
        2.21c:  8 April 1995
        2.21d: 25 May 1995
        2.21e: 26 May 1995
        2.21f: 31 May 1995

See README.OS2 for more details.
**********************************************************************/
                                              
CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs

/**********************************************************************
New argument processing.  I moved Claudios' original
to the bottom with label 'Changed:'.                    CKG
**********************************************************************/
PARSE ARG Args
IF (Pos( '-?', Args )>0) THEN SIGNAL HELP
CALL GetArg Args

/**********************************************************************
Set environment variable POPUPBIFF=YES if you want to be notified that
mail has arrived.
**********************************************************************/

/*  Can we use PMPOPUP at all? */
PopupExe = SysSearchPath( 'PATH', 'pmpopup.exe')
IF (PopupExe='') THEN
   PopUp = 0
ELSE
   PopUp = 1

PopUpBiff = Value( 'POPUPBIFF', ,'OS2ENVIRONMENT' )
/*  If = YES then notify of incoming mail via PMPOPUP  */

/*  Is it POPCLIEN.EXE (FAT) or POPCLIENT.EXE (HPFS)?  */
PopClient = SysSearchPath( 'PATH', 'popclient.exe')
IF (PopClient = '') THEN
   PopClient = SysSearchPath( 'PATH', 'popclien.exe')
IF (PopClient = '') THEN DO
    IF (PopUp) THEN
        "@start" PopupExe "Could not find POPCLIENT executable."
    ELSE
        SAY 'Could not find POPCLIENT executable.'
    EXIT
END

IF ((Mailer='U') | (Mailer='u')) THEN DO
    mda_path = 'UMAILER.EXE'
    mda_args = '-dest' inbasket '-to $u'
END
ELSE IF ((Mailer='E') | (Mailer='e')) THEN DO
    mda_path = 'filter.exe'
    mda_args = '-u' loginname
END
ELSE DO
    mda_path = value('COMSPEC',,'OS2ENVIRONMENT')
    mda_args = '/C LaMailer.cmd -dest' inbasket '-to $u'
END

SIGNAL ON HALT  /* don't display REXX error message when user breaks out */

/**********************************************************************
   When mail arrives, popclient runs the mail delivery agent
   specified by MDA_PATH with arguments MDA_ARGS.  This
   sets the environment to the correct MDA.
**********************************************************************/
rc = Value('MDA_PATH',mda_path,'OS2ENVIRONMENT')
rc = Value('MDA_ARGS',mda_args,'OS2ENVIRONMENT')

Counter = 0
DO Until (Delay=0 | Counter>10)
    SAY Time()
/**********************************************************************
This was used to write directly to the elm mailbox, bypasing filter.
It is now obsolete.  Using filter is more stable than writing directly
to mbox; maybe someday we'll have something better than filter, too.
    IF ((Mailer='E') | (Mailer='e')) THEN
        '@'PopClient '-u' Loginname '-p' Password,
            ' -o' Inbasket Host
    ELSE
**********************************************************************/

    TmpDir = Value( 'TMP', , 'OS2ENVIRONMENT' )
    TmpFile = SysTempFileName( TmpDir'\PopJunk.???' )

    "@"PopClient "-u" Loginname "-p" Password OtherArgs Host "2>" TmpFile

    /* If there's an error, just beep and continue, but keep count. */
    IF rc > 1 THEN DO
       IF (PopUp) THEN
          "@start" PopupExe "POPCLID.CMD: POPCLIENT.EXE returned error ("rc")"
       ELSE
           say 'POPCLID.CMD: POPCLIENT.EXE returned error ('rc')'
       CALL Beep 400, 500
       Counter = Counter + 1
       END
    ELSE
       Counter = 0

    NumMsgs = 0
    Line = Linein( TmpFile )
    Line = Linein( TmpFile )
    CALL Lineout TmpFile
    "@type" TmpFile
    "@del" TmpFile
    PARSE Value(Line) WITH 1 NumMsgs 'messages'
    IF (NumMsgs > 0) THEN DO
        IF (PopUp & (Translate(PopUpBiff)='YES')) THEN
            "@start" PopupExe "You have" NumMsgs"new messages."
        ELSE
            SAY "You have" NumMsgs"new messages."
    END

    /* wait for a specified number of seconds */
    CALL SysSleep Delay
    END

IF (Counter>1) THEN DO
    IF (PopUp) THEN
       "@start" PopupExe "POPCLID.CMD aborted with too many errors."
    ELSE
        say 'POPCLID.CMD aborted with too many errors.'
END

halt:
   exit

GetArg:
PARSE ARG 1 '-h' host .  1 '-l' loginname .  1 '-p' password . ,
          1 '-d' delay . 1 '-b' inbasket .   1 '-m' mailer . ,
          1 '-u' user .  1 '-o' otherargs

host      = ArgCheck( host, 'POPHOST', '' )
loginname = ArgCheck( loginname, 'POPUSER', '' )
password  = ArgCheck( password, 'POPPASS', '' )
delay     = ArgCheck( delay, 'POPDELAY', '0' )
inbasket  = ArgCheck( inbasket, 'INBASKET', '.' )
mailer    = left( ArgCheck( mailer, 'MDA_PROG', 'LAMAIL' ), 1 )
user      = ArgCheck( user, 'USER', 'root' )

IF ((host='') | (loginname='') | (password='')) THEN SIGNAL HELP
RETURN

ArgCheck:
PARSE ARG RexxVar, OS2Var, Default
IF (RexxVar = '') THEN DO
   RexxVar = value(OS2Var,,'OS2ENVIRONMENT')
   IF (RexxVar = '') THEN
      RexxVar = Default
END
RETURN RexxVar

Help:
SAY 'POPCLID: OS/2 frontend for Carl Harris'' popclient'
SAY '   by Claudio Fahey and Clark Gaylord'
SAY ' '
SAY 'Usage:'
SAY 'popclid -h pophost -l loginname -p password [-d delay] [-b inbasket]'
SAY '           [-m L|U|E] [-u user] [-o otherargs]'
SAY ' '
SAY ' '
SAY 'The following environment variables can be used:'
SAY '   POPHOST  for pophost'
SAY '   POPUSER  for loginname'
SAY '   POPPASS  for password'
SAY '   POPDELAY for delay, defaults to 0, i.e., retrieve mail once only'
SAY '   INBASKET for inbasket, defaults to current directory,'
SAY '                should be SERVER''s inbox for UltiMail Lite.'
SAY '   MDA_PROG for mailer, LaMail or Ultimail, only first letter significant,'
SAY '                defaults to LaMail'
SAY '   USER     for Ultimail inbasket, defaults to root.'
SAY '   L|U|E    for LaMail (default), Ultimail, or Elm'
SAY ' '
EXIT

Changed:
/**********************************************************************
   These lines are only for reference; the program never gets here.   
   CKG
**********************************************************************/
/*********************************************************/
/* Edit the following lines to configure this program:   */
/*********************************************************/
host = 'pop.server'                 /* POP host name                */
loginname = 'loginnameonpop'        /* Login name on the host       */
password = 'password'               /* Password on the host         */
delay = 600                         /* Seconds between mail checks  */
