/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.emulator;

import com.fx702p.emulator.Characters;
import com.fx702p.emulator.Console;

public class TokenHelper {
    public static boolean isComment(String aLine) {
        return aLine.matches("[ \t]*(//|/\\*|\\\\\\*).*");
    }

    public static String convertStringLiteral(String aString) {
        return TokenHelper.convert(aString, true);
    }

    public static String convertLine(String aString) {
        return TokenHelper.convert(aString, false);
    }

    public static String convertForOutput(String aString) {
        StringBuilder converted = new StringBuilder();
        int last = aString.length();
        block7: for (int i = 0; i < last; ++i) {
            char c = aString.charAt(i);
            switch (c) {
                case '{': {
                    converted.append("\\<");
                    continue block7;
                }
                case '}': {
                    converted.append("\\>");
                    continue block7;
                }
                case 'e': {
                    converted.append("\\e");
                    continue block7;
                }
                case '~': {
                    converted.append("\\=");
                    continue block7;
                }
                case 'p': {
                    converted.append("\\p");
                    continue block7;
                }
                default: {
                    converted.append(c);
                }
            }
        }
        return converted.toString();
    }

    protected static String convert(String aString, boolean checkValidity) {
        StringBuilder converted = new StringBuilder();
        int last = aString.length();
        for (int i = 0; i < last; ++i) {
            char c = aString.charAt(i);
            if (c == '\\') {
                if (++i < last) {
                    c = aString.charAt(i);
                    switch (c) {
                        case '<': {
                            c = '{';
                            break;
                        }
                        case '>': {
                            c = '}';
                            break;
                        }
                        case 'E': 
                        case 'e': {
                            c = 'e';
                            break;
                        }
                        case '=': {
                            c = '~';
                            break;
                        }
                        case 'P': 
                        case 'p': {
                            c = 'p';
                            break;
                        }
                        default: {
                            Console.reportError("Unknown character '" + c + "' after \\");
                            break;
                        }
                    }
                } else {
                    Console.reportError("Character \\ cannot be the last one of a String");
                }
            } else if (Character.isLowerCase(c)) {
                c = Character.toUpperCase(c);
            }
            if (checkValidity) {
                if (Characters.isValidStringCharacter(c)) {
                    converted.append(c);
                    continue;
                }
                Console.reportError("Invalid character '" + c + "'");
                continue;
            }
            converted.append(c);
        }
        return converted.toString();
    }

    public static String convertFloatLiteral(String aString) {
        StringBuilder converted = new StringBuilder();
        int last = aString.length();
        for (int i = 0; i < last; ++i) {
            char c = aString.charAt(i);
            if (c == '\\') {
                if (++i < last) {
                    c = aString.charAt(i);
                    switch (c) {
                        case 'E': 
                        case 'e': {
                            c = 'E';
                            break;
                        }
                        default: {
                            Console.reportError("Unknown character '" + c + "' after \\");
                            break;
                        }
                    }
                } else {
                    Console.reportError("Character \\ cannot be the last one of a Float");
                }
            }
            converted.append(c);
        }
        return converted.toString();
    }
}

