/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.emulator.implementation;

import com.fx702p.Fx702pFullParser;
import com.fx702p.emulator.ArrayVariable;
import com.fx702p.emulator.DollarVariable;
import com.fx702p.emulator.FullVariable;
import com.fx702p.emulator.Fx702pBasicProgram;
import com.fx702p.emulator.Fx702pBasicSourceCode;
import com.fx702p.emulator.Fx702pConstants;
import com.fx702p.emulator.Fx702pDisplay;
import com.fx702p.emulator.Fx702pMemory;
import com.fx702p.emulator.Variable;
import com.fx702p.emulator.exceptions.Fx702pErr2Exception;
import com.fx702p.emulator.exceptions.Fx702pErr5Exception;
import com.fx702p.emulator.exceptions.Fx702pErr6Exception;
import com.fx702p.emulator.exceptions.Fx702pLoadingException;
import com.fx702p.interpreters.Fx702pAbstractParserVisitor;
import com.fx702p.interpreters.Fx702pCalculator;
import com.fx702p.interpreters.Fx702pException;
import com.fx702p.interpreters.Fx702pFormatter;
import com.fx702p.parser.ASTAssignment;
import com.fx702p.parser.ASTComment;
import com.fx702p.parser.ASTInteger;
import com.fx702p.parser.ASTMultiplePrograms;
import com.fx702p.parser.ASTProgramsFile;
import com.fx702p.parser.ASTSavedDefm;
import com.fx702p.parser.ASTSingleProgram;
import com.fx702p.parser.ASTVariablesAndProgram;
import com.fx702p.parser.ParseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class Fx702pDefaultMemory
implements Fx702pMemory {
    protected DollarVariable dollar;
    protected FullVariable[] variable = new FullVariable[26];
    protected FullVariable[] array = new FullVariable[200];
    protected int activeProgramIndex = 0;
    protected Fx702pBasicProgram[] program = new Fx702pBasicProgram[10];
    protected BigDecimal statCounter = BigDecimal.ZERO;
    protected BigDecimal sumX = BigDecimal.ZERO;
    protected BigDecimal sumY = BigDecimal.ZERO;
    protected BigDecimal sumX2 = BigDecimal.ZERO;
    protected BigDecimal sumY2 = BigDecimal.ZERO;
    protected BigDecimal sumXY = BigDecimal.ZERO;
    protected BigDecimal lastY = null;
    protected double trigonometricConversionFactor = Math.PI / 180;
    protected double trigonometricMaxArgument = 1440.0;
    protected BigDecimal lastResult = BigDecimal.ZERO;
    protected Fx702pFormatter formatter = Fx702pConstants.NORMAL_FORMATTER;
    protected RoundingMode roundingMode = Fx702pConstants.DEFAULT_ROUNDING_MODE;
    protected Fx702pMemory.Watcher watcher = EMPTY_WATCHER;
    protected File programsFile = null;
    protected boolean modified = false;
    protected Fx702pBasicSourceCode globalBasicSourceCode;
    protected boolean hasComments = false;
    protected int programStepsCount = 1680;
    protected int variablesCount = 26;
    protected boolean saveVariables = false;
    protected boolean saveBreakpoints = false;

    public Fx702pDefaultMemory() {
        int i;
        int comparisonIndex = 0;
        this.dollar = new DollarVariable(this, comparisonIndex++);
        for (i = 0; i < 26; ++i) {
            this.variable[i] = new FullVariable(this, comparisonIndex++);
        }
        for (i = 0; i < 200; ++i) {
            this.array[i] = new ArrayVariable(this, comparisonIndex++);
        }
        for (i = 0; i < 10; ++i) {
            this.program[i] = new Fx702pBasicProgram("P" + i);
        }
    }

    public void clearAllPrograms() {
        for (int i = 0; i < 10; ++i) {
            this.program[i].clear();
        }
    }

    public void clearAllVariables() {
        int i;
        this.dollar.clear();
        for (i = 0; i < 26; ++i) {
            this.variable[i].clear();
        }
        for (i = 0; i < 200; ++i) {
            this.array[i].clear();
        }
        this.watcher.allCleared();
    }

    public DollarVariable getDollarVariable() {
        return this.dollar;
    }

    public FullVariable getVariable(int anIndex) {
        return this.variable[anIndex];
    }

    public FullVariable getArrayVariable(int anIndex) {
        if (anIndex < 0 || anIndex >= 200) {
            throw new Fx702pErr5Exception();
        }
        if (anIndex >= this.variablesCount - 26) {
            throw new Fx702pErr6Exception();
        }
        return this.array[anIndex];
    }

    public Fx702pBasicProgram getProgram(int anIndex) {
        return this.program[anIndex];
    }

    public Fx702pBasicProgram getActiveProgram() {
        return this.program[this.activeProgramIndex];
    }

    public int getActiveProgramIndex() {
        return this.activeProgramIndex;
    }

    public void setActiveProgramIndex(int aProgramIndex) {
        this.activeProgramIndex = aProgramIndex;
    }

    public double getTrigonometricConversionFactor() {
        return this.trigonometricConversionFactor;
    }

    public void setTrigonometricConversionFactor(double aTrigonometricConversionFactor) {
        this.trigonometricConversionFactor = aTrigonometricConversionFactor;
    }

    public double getTrigonometricMaxArgument() {
        return this.trigonometricMaxArgument;
    }

    public void setTrigonometricMaxArgument(double aTrigonometricMaxArgument) {
        this.trigonometricMaxArgument = aTrigonometricMaxArgument;
    }

    public void clearStatVariables() {
        this.statCounter = BigDecimal.ZERO;
        this.sumY2 = this.sumXY = BigDecimal.ZERO;
        this.sumX2 = this.sumXY;
        this.sumY = this.sumXY;
        this.sumX = this.sumXY;
        this.lastY = null;
        this.watcher.statVariablesCleared();
    }

    protected void clearAll() {
        this.clearAllPrograms();
        this.clearAllVariables();
    }

    public BigDecimal getStatCounter() {
        return this.statCounter;
    }

    public BigDecimal getSumX() {
        return this.sumX;
    }

    public BigDecimal getSumY() {
        return this.sumY;
    }

    public BigDecimal getSumX2() {
        return this.sumX2;
    }

    public BigDecimal getSumY2() {
        return this.sumY2;
    }

    public BigDecimal getSumXY() {
        return this.sumXY;
    }

    public BigDecimal getLastY() {
        return this.lastY;
    }

    public void setLastY(BigDecimal aLastY) {
        this.lastY = aLastY;
    }

    public void setStatVariables(BigDecimal aStatCounter, BigDecimal aSumX, BigDecimal aSumY, BigDecimal aSumX2, BigDecimal aSumY2, BigDecimal aSumXY) {
        this.statCounter = aStatCounter;
        this.sumX = aSumX;
        this.sumY = aSumY;
        this.sumX2 = aSumX2;
        this.sumY2 = aSumY2;
        this.sumXY = aSumXY;
        this.watcher.statVariablesModified();
    }

    public BigDecimal getLastResult() {
        return this.lastResult;
    }

    public void setLastResult(BigDecimal aLastResult) {
        this.lastResult = aLastResult;
    }

    public Fx702pFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(Fx702pFormatter aFx702pFormatter) {
        this.formatter = aFx702pFormatter;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(RoundingMode aRoundingMode) {
        this.roundingMode = aRoundingMode;
    }

    public Fx702pMemory.Watcher getWatcher() {
        return this.watcher;
    }

    public void setWatcher(Fx702pMemory.Watcher aWatcher) {
        this.watcher = aWatcher == null ? EMPTY_WATCHER : aWatcher;
    }

    public boolean isSavingVariables() {
        return this.saveVariables;
    }

    public boolean isSavingBreakpoints() {
        return this.saveBreakpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File aProgramsFile, Fx702pCalculator aCalculator, Fx702pDisplay aDisplay) throws FileNotFoundException, UnsupportedEncodingException, ParseException, Fx702pLoadingException {
        try {
            this.programsFile = aProgramsFile;
            this.saveVariables = false;
            this.saveBreakpoints = false;
            Fx702pFullParser parser = new Fx702pFullParser(new FileInputStream(this.programsFile));
            ASTProgramsFile programsFile = parser.ProgramsFile();
            ProgramFilesVisitor programFilesVisitor = new ProgramFilesVisitor(parser.getBasicSourceCode(), aCalculator, aDisplay);
            programsFile.jjtAccept(programFilesVisitor, null);
        }
        finally {
            this.modified = false;
        }
    }

    public void reload(Fx702pCalculator aCalculator, Fx702pDisplay aDisplay) throws FileNotFoundException, UnsupportedEncodingException, Fx702pLoadingException, ParseException {
        this.load(this.programsFile, aCalculator, aDisplay);
    }

    public void saveAll(Fx702pDisplay aDisplay) throws IOException {
        boolean confirmed = true;
        if (this.hasComments) {
            confirmed = aDisplay.askConfirmation("Confirm Save", "Comments will be lost. Save anyway?");
        }
        if (confirmed) {
            this.saveAllAs(null, this.saveVariables, this.saveBreakpoints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAllAs(File aProgramsFile, boolean aSaveVariablesFlag, boolean aSaveBreakpointsFlag) throws IOException {
        block5: {
            if (aProgramsFile == null) {
                aProgramsFile = this.programsFile;
            }
            File tempFile = File.createTempFile('_' + aProgramsFile.getName(), null, aProgramsFile.getAbsoluteFile().getParentFile());
            try {
                FileOutputStream outputStream = new FileOutputStream(tempFile);
                this.save(outputStream, this.buildName(aProgramsFile), aSaveVariablesFlag, aSaveBreakpointsFlag);
                outputStream.flush();
                outputStream.close();
                if (tempFile.renameTo(aProgramsFile)) {
                    this.programsFile = aProgramsFile;
                    this.saveVariables = aSaveVariablesFlag;
                    this.saveBreakpoints = aSaveBreakpointsFlag;
                    this.hasComments = false;
                    this.modified = false;
                    break block5;
                }
                throw new IOException("Cannot rename temporary file " + tempFile.getPath() + " to " + this.programsFile.getPath());
            }
            finally {
                tempFile.delete();
            }
        }
    }

    protected String buildName(File aFile) {
        String name = aFile.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot > 0) {
            name = name.substring(0, lastDot);
        }
        return name.substring(0, Math.min(name.length(), 8)).toUpperCase();
    }

    protected void save(OutputStream anOutputStream, String aName, boolean aSaveVariablesFlag, boolean aSaveBreakpointsFlag) {
        PrintWriter writer = new PrintWriter(anOutputStream);
        this.saveName(writer, aName);
        this.saveDefm(writer);
        if (aSaveVariablesFlag) {
            this.saveVariables(writer);
        }
        this.savePrograms(writer, aSaveBreakpointsFlag);
        writer.flush();
        writer.close();
    }

    protected void saveName(PrintWriter aWriter, String aName) {
        aWriter.println("All programs: \"" + aName + '\"');
        aWriter.println();
    }

    protected void saveDefm(PrintWriter aWriter) {
        aWriter.print("DEFM ");
        aWriter.println((this.variablesCount - 26) / 10);
        aWriter.println();
    }

    public void saveVariables(PrintWriter aWriter) {
        int i;
        this.saveVariable("", "", this.dollar, aWriter);
        for (i = 0; i < 26; ++i) {
            this.saveVariable("" + (char)(65 + i), "", this.variable[i], aWriter);
        }
        for (i = 0; i < this.variablesCount - 26; ++i) {
            this.saveVariable("A", "(" + i + ")", this.array[i], aWriter);
        }
        aWriter.println();
    }

    protected void saveVariable(String aName, String anIndex, Variable aVariable, PrintWriter aWriter) {
        boolean empty;
        boolean bl = empty = aVariable.isStringVariable() && aVariable.getValue().equals("") || !aVariable.isStringVariable() && aVariable.getValue().equals(BigDecimal.ZERO);
        if (!empty) {
            aWriter.print(aName);
            if (aVariable.isStringVariable()) {
                aWriter.print('$');
                aWriter.print(anIndex);
                aWriter.print("=\"");
                aWriter.print((String)aVariable.getValue());
                aWriter.print('\"');
            } else {
                aWriter.print(anIndex);
                aWriter.print('=');
                aWriter.print(Fx702pConstants.NORMAL_FORMATTER.format((BigDecimal)aVariable.getValue()));
            }
            aWriter.print('\n');
        }
    }

    protected void savePrograms(PrintWriter aWriter, boolean aSaveBreakpointsFlag) {
        for (int i = 0; i < 10; ++i) {
            Fx702pBasicProgram program = this.getProgram(i);
            if (program.isEmpty()) continue;
            aWriter.println("P" + i);
            aWriter.println();
            program.write(this, aWriter, false, aSaveBreakpointsFlag);
            aWriter.println();
        }
    }

    public boolean areVariablesModified() {
        return this.modified;
    }

    public boolean isModified() {
        if (this.modified) {
            return true;
        }
        for (int i = 0; i < 10; ++i) {
            if (!this.program[i].isModified()) continue;
            return true;
        }
        return false;
    }

    public void markAsModified() {
        this.modified = true;
    }

    public String getProgramsFileName() {
        return this.programsFile == null ? "" : this.programsFile.getName();
    }

    public boolean canBeSaved() {
        return this.programsFile != null && this.isModified();
    }

    public boolean canBeLoaded() {
        return this.isAllLoaded();
    }

    public boolean isAllLoaded() {
        return this.programsFile != null;
    }

    public void setDefm(int aDefm) {
        if (aDefm < 0 || aDefm > 20) {
            throw new Fx702pErr5Exception();
        }
        this.programStepsCount = 1680 - 80 * aDefm;
        int newVariablesCount = 26 + 10 * aDefm;
        if (newVariablesCount > this.variablesCount) {
            for (int i = this.variablesCount - 26; i < newVariablesCount - 26; ++i) {
                this.array[i].clear();
            }
        }
        this.variablesCount = newVariablesCount;
    }

    public int getVariablesCount() {
        return this.variablesCount;
    }

    public int getProgramStepsCount() {
        return this.programStepsCount;
    }

    protected class ProgramFilesVisitor
    extends Fx702pAbstractParserVisitor {
        protected Fx702pBasicSourceCode basicSourceCode;
        protected Fx702pCalculator calculator;
        protected Fx702pDisplay display;

        public ProgramFilesVisitor(Fx702pBasicSourceCode aBasicSourceCode, Fx702pCalculator aCalculator, Fx702pDisplay aDisplay) {
            this.basicSourceCode = aBasicSourceCode;
            this.calculator = aCalculator;
            this.display = aDisplay;
        }

        public Object visit(ASTMultiplePrograms aMultiplePrograms, Object aData) {
            Fx702pDefaultMemory.this.clearAll();
            aMultiplePrograms.childrenAccept(this, aData);
            Fx702pDefaultMemory.this.globalBasicSourceCode = new Fx702pBasicSourceCode(this.basicSourceCode, aMultiplePrograms.getBeginLine(), aMultiplePrograms.getEndLine());
            return null;
        }

        public Object visit(ASTSavedDefm aSavedDefm, Object aData) {
            try {
                if (aSavedDefm.jjtGetNumChildren() != 1 || !(aSavedDefm.jjtGetChild(0) instanceof ASTInteger)) {
                    throw new Fx702pErr2Exception();
                }
                int value = ((ASTInteger)aSavedDefm.jjtGetChild((int)0)).value.intValue();
                Fx702pDefaultMemory.this.setDefm(value);
                return null;
            }
            catch (Fx702pException exception) {
                exception.setLine((Integer)aSavedDefm.jjtGetValue());
                throw exception;
            }
        }

        public Object visit(ASTSingleProgram aSingleProgram, Object aData) {
            int programNumber = aSingleProgram.getProgramNumber();
            String name = "P" + programNumber + " in " + Fx702pDefaultMemory.this.programsFile.getName();
            String password = aSingleProgram.getPassword();
            Fx702pBasicSourceCode programSourceCode = new Fx702pBasicSourceCode(this.basicSourceCode, aSingleProgram.getBeginLine(), aSingleProgram.getEndLine());
            try {
                Fx702pDefaultMemory.this.program[programNumber].load(name, aSingleProgram, programSourceCode, password, this.calculator, this.display);
                Fx702pDefaultMemory.this.saveBreakpoints |= Fx702pDefaultMemory.this.program[programNumber].isSavingBreakpoints();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }

        public Object visit(ASTVariablesAndProgram aNode, Object aData) {
            try {
                Fx702pDefaultMemory.this.getActiveProgram().load(Fx702pDefaultMemory.this.programsFile, aNode, this.basicSourceCode, this.calculator, this.display);
                Fx702pDefaultMemory.this.saveBreakpoints |= Fx702pDefaultMemory.this.getActiveProgram().isSavingBreakpoints();
                Fx702pDefaultMemory.this.programsFile = null;
            }
            catch (Exception exception) {
                throw new Fx702pLoadingException(exception.getMessage());
            }
            return null;
        }

        public Object visit(ASTAssignment anAssignment, Object aData) {
            try {
                this.calculator.visit(anAssignment, aData);
                Fx702pDefaultMemory.this.saveVariables = true;
                return null;
            }
            catch (Fx702pException exception) {
                exception.setLine((Integer)anAssignment.jjtGetValue());
                throw exception;
            }
        }

        public Object visit(ASTComment aNode, Object aData) {
            Fx702pDefaultMemory.this.hasComments = true;
            return null;
        }
    }
}

