/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.beans;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.numericalchameleon.beans.AnalogClockBean;

public class AnalogClockTest
extends JFrame {
    private AnalogClockBean analogClock = new AnalogClockBean();
    private AnalogClockBean analogClockBean1;
    private JCheckBox checkBox;
    private JSlider slider;
    private JToggleButton toggleButton;

    public AnalogClockTest() {
        this.initComponents();
    }

    private void initComponents() {
        this.slider = new JSlider();
        this.toggleButton = new JToggleButton();
        this.checkBox = new JCheckBox();
        this.analogClockBean1 = new AnalogClockBean();
        this.setDefaultCloseOperation(3);
        this.slider.setMajorTickSpacing(21600);
        this.slider.setMaximum(86399);
        this.slider.setPaintTicks(true);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AnalogClockTest.this.sliderStateChanged(changeEvent);
            }
        });
        this.toggleButton.setText("Run");
        this.toggleButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AnalogClockTest.this.toggleButtonStateChanged(changeEvent);
            }
        });
        this.checkBox.setText("smooth");
        this.checkBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AnalogClockTest.this.checkBoxStateChanged(changeEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.analogClockBean1);
        this.analogClockBean1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 341, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.analogClockBean1, -2, 341, -2).addGap(18, 18, 18).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.slider, -2, -1, -2).addComponent(this.toggleButton).addComponent(this.checkBox)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(0, 223, Short.MAX_VALUE).addComponent(this.checkBox).addGap(18, 18, 18).addComponent(this.toggleButton).addGap(18, 18, 18).addComponent(this.slider, -2, -1, -2)).addComponent(this.analogClockBean1, -1, 338, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void sliderStateChanged(ChangeEvent changeEvent) {
        int n = this.slider.getValue();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (n > 0) {
            n2 = n % 60;
            n /= 60;
        }
        if (n > 0) {
            n3 = n % 60;
            n /= 60;
        }
        if (n > 0) {
            n4 = n % 24;
            n /= 24;
        }
        this.analogClock.setSeconds(n2);
        this.analogClock.setMinutes(n3);
        this.analogClock.setHours(n4);
        this.analogClock.repaint();
    }

    private void toggleButtonStateChanged(ChangeEvent changeEvent) {
        if (this.toggleButton.isSelected()) {
            this.slider.setEnabled(false);
            this.analogClock.start();
        } else {
            this.slider.setEnabled(true);
            this.analogClock.stop();
            this.slider.setValue(this.analogClock.getHours() * 3600 + this.analogClock.getMinutes() * 60 + this.analogClock.getSeconds());
        }
    }

    private void checkBoxStateChanged(ChangeEvent changeEvent) {
        if (this.checkBox.isSelected()) {
            this.analogClock.setIntervalInMillis(10);
        } else {
            this.analogClock.setIntervalInMillis(1000);
        }
    }

    private void analogClockPropertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new AnalogClockTest().setVisible(true);
            }
        });
    }
}

