/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.categories;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.data.Unit;
import uk.me.jstott.jcoord.LatLng;

public class CategoryTimezones
extends CategoryObject {
    private static String INVALID;
    private String infoConversion;
    private final ArrayList<Unit> units;
    private final ArrayList<String> timezoneVector;
    private final DateFormat dateFormat;
    private TimeZone defaultTimeZone;
    private static final String yyyyMMddHHmmss = "yyyyMMddHHmmss";
    private HashMap<String, LatLng> coordsHash;
    private final DecimalFormat formatHour;
    private final DecimalFormat formatLatLng;
    private final ResourceBundle iso3166;

    public String getTzId(int index) {
        return this.timezoneVector.get(index);
    }

    public CategoryTimezones(CategoryInterface categoryInterface) {
        InputStream is;
        this.rb = categoryInterface.getResourceBundle();
        this.iso3166 = categoryInterface.getISO3166ResourceBundle();
        INVALID = this.localize("Moduls.sourceInvalid", "Source is invalid");
        this.dateFormat = DateFormat.getDateTimeInstance(2, 2);
        this.formatHour = new DecimalFormat("##.##");
        this.formatLatLng = new DecimalFormat("#,###,###.##");
        this.units = new ArrayList();
        this.timezoneVector = new ArrayList();
        String[] availableIDs = TimeZone.getAvailableIDs();
        HashMap<String, Boolean> hash = new HashMap<String, Boolean>();
        for (String availableID : availableIDs) {
            hash.put(availableID, Boolean.TRUE);
        }
        try {
            String thisLine;
            is = this.getClass().getResourceAsStream("/data/lists/timezones.list");
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
            int index = 0;
            this.defaultTimeZone = TimeZone.getDefault();
            String timeZoneDefault = this.defaultTimeZone.getID();
            while ((thisLine = br.readLine()) != null) {
                if (thisLine.startsWith("#") || thisLine.length() <= 0) continue;
                StringTokenizer st = new StringTokenizer(thisLine, ":");
                String countrycode = st.nextToken();
                String timezonecode = st.nextToken();
                boolean active = true;
                if (st.hasMoreTokens()) {
                    active = !st.nextToken().equals("false");
                }
                st = null;
                if (hash.get(timezonecode) != null) {
                    this.timezoneVector.add(timezonecode);
                    StringBuilder sbt = new StringBuilder(96);
                    sbt.append(timezonecode);
                    if (!timezonecode.contains("/")) {
                        String desc = TimeZone.getTimeZone(timezonecode).getDisplayName(Locale.US);
                        sbt.append(" - ").append(desc);
                    }
                    sbt.append(" (");
                    sbt.append(this.iso3166.getString(countrycode));
                    sbt.append(")");
                    this.units.add(new Unit(index, sbt.toString(), countrycode, active));
                    if (timezonecode.equalsIgnoreCase(timeZoneDefault)) {
                        this.sourceDefault = index;
                    }
                    if (timezonecode.equalsIgnoreCase("America/New_York")) {
                        this.targetDefault = index;
                    }
                    ++index;
                    continue;
                }
                System.out.println("Timezone " + timezonecode + " not found.");
            }
            br.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        try {
            String thisLine;
            is = this.getClass().getResourceAsStream("/data/lists/zone.tab");
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
            this.coordsHash = new HashMap();
            while ((thisLine = br.readLine()) != null) {
                if (thisLine.startsWith("#") || thisLine.length() <= 0) continue;
                StringTokenizer st = new StringTokenizer(thisLine, "\t");
                String countrycode = st.nextToken();
                String coordinates = st.nextToken();
                String tzid = st.nextToken();
                st = null;
                try {
                    if (hash.get(tzid) == null) continue;
                    boolean longformat = coordinates.length() == 15;
                    int offset = longformat ? 2 : 0;
                    LatLng latLng = new LatLng(Integer.parseInt(coordinates.substring(1, 3)), Integer.parseInt(coordinates.substring(3, 5)), longformat ? (double)Integer.parseInt(coordinates.substring(5, 7)) : 0.0, coordinates.charAt(0) == '+' ? 1 : -1, Integer.parseInt(coordinates.substring(6 + offset, 9 + offset)), Integer.parseInt(coordinates.substring(9 + offset, 11 + offset)), longformat ? (double)Integer.parseInt(coordinates.substring(13, 15)) : 0.0, coordinates.charAt(5 + offset) == '+' ? 1 : -1);
                    this.coordsHash.put(tzid, latLng);
                }
                catch (IllegalArgumentException iae) {
                    System.err.println(iae + " " + tzid + " " + coordinates);
                }
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    @Override
    public String getInfoConversion() {
        return this.infoConversion;
    }

    @Override
    public ArrayList<Unit> getSourceUnits() {
        return this.units;
    }

    @Override
    public ArrayList<Unit> getTargetUnits() {
        return this.units;
    }

    @Override
    public int getSourceDefault() {
        return this.sourceDefault;
    }

    @Override
    public int getTargetDefault() {
        return this.targetDefault;
    }

    @Override
    public String getOutput(int s, int t) throws Exception {
        Unit sourceUnit = this.units.get(s);
        Unit targetUnit = this.units.get(t);
        return this.getOutput(sourceUnit, targetUnit);
    }

    @Override
    public String getOutput(Unit sourceUnit, Unit targetUnit) throws Exception {
        int sid = sourceUnit.getId();
        int tid = targetUnit.getId();
        TimeZone fromTimeZone = TimeZone.getTimeZone(this.timezoneVector.get(sid));
        GregorianCalendar fromCal = new GregorianCalendar(fromTimeZone);
        this.dateFormat.setTimeZone(fromTimeZone);
        this.dateFormat.setLenient(false);
        fromCal.setTime(this.dateFormat.parse(this.input));
        long ms = fromCal.getTimeInMillis();
        TimeZone toTimeZone = TimeZone.getTimeZone(this.timezoneVector.get(tid));
        GregorianCalendar toCal = new GregorianCalendar(toTimeZone);
        this.dateFormat.setTimeZone(toTimeZone);
        toCal.setTimeInMillis(fromCal.getTimeInMillis());
        String result = this.dateFormat.format(toCal.getTime());
        this.dateFormat.setTimeZone(fromTimeZone);
        fromCal.setTime(this.dateFormat.parse(result));
        double d = (double)(fromCal.getTimeInMillis() - ms) / 3600000.0;
        this.infoConversion = (d > 0.0 ? "+" : "") + this.formatHour.format(d) + " h";
        LatLng latLngt = this.coordsHash.get(this.timezoneVector.get(tid));
        LatLng latLngs = null;
        if (latLngt != null) {
            latLngs = this.coordsHash.get(this.timezoneVector.get(sid));
        }
        if (latLngt != null && latLngs != null) {
            this.infoConversion = this.infoConversion + " / " + this.formatLatLng.format(latLngs.distance(latLngt)) + " km";
        }
        return result;
    }

    @Override
    public String getInitialValue() {
        this.dateFormat.setTimeZone(this.defaultTimeZone);
        return this.dateFormat.format(new Date());
    }

    public static String getInternationalTimeValue() {
        SimpleDateFormat formatter = new SimpleDateFormat(yyyyMMddHHmmss);
        return formatter.format(new Date());
    }

    @Override
    public String addValue(BigDecimal plus, int sourceIndex) throws Exception {
        TimeZone fromTimeZone = TimeZone.getTimeZone(this.timezoneVector.get(sourceIndex));
        GregorianCalendar fromCal = new GregorianCalendar(fromTimeZone);
        this.dateFormat.setTimeZone(fromTimeZone);
        fromCal.setTime(this.dateFormat.parse(this.input));
        int count = Integer.parseInt(plus.toString());
        ((Calendar)fromCal).add(10, count);
        String temp = this.dateFormat.format(fromCal.getTime());
        this.setInput(temp);
        return temp;
    }

    @Override
    public String setValue(BigDecimal big, int sourceIndex) throws Exception {
        TimeZone fromTimeZone = TimeZone.getTimeZone(this.timezoneVector.get(sourceIndex));
        GregorianCalendar fromCal = new GregorianCalendar(fromTimeZone);
        SimpleDateFormat standardDateFormat = new SimpleDateFormat(yyyyMMddHHmmss);
        fromCal.setTime(standardDateFormat.parse(big.toString()));
        this.dateFormat.setTimeZone(fromTimeZone);
        String temp = this.dateFormat.format(fromCal.getTime());
        this.setInput(temp);
        return temp;
    }

    @Override
    public String getTransferValue(int s) throws Exception {
        TimeZone fromTimeZone = TimeZone.getTimeZone(this.timezoneVector.get(s));
        GregorianCalendar fromCal = new GregorianCalendar(fromTimeZone);
        this.dateFormat.setTimeZone(fromTimeZone);
        fromCal.setTime(this.dateFormat.parse(this.input));
        SimpleDateFormat standardDateFormat = new SimpleDateFormat(yyyyMMddHHmmss);
        return standardDateFormat.format(fromCal.getTime());
    }

    @Override
    public String getCard() {
        return "tzCard";
    }

    @Override
    public String getTransferValue(Unit sourceUnit) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

