/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.cli;

import java.io.File;
import java.util.Properties;
import javax.swing.JTextArea;
import jonelo.sugar.args.Arguments;
import jonelo.sugar.args.InvalidArgumentException;
import jonelo.sugar.util.Counter;
import net.numericalchameleon.cli.CLIInterface;
import net.numericalchameleon.gui.dialogs.exchangerates.ExchangeRatesDialog;
import net.numericalchameleon.info.ProgInfo;
import net.numericalchameleon.util.exchangerates.CurrencyConverter;
import net.numericalchameleon.util.exchangerates.ExchangeRates;

public class CLI {
    private boolean debug = false;
    private boolean logfileWanted = false;
    private boolean continueFlow = true;
    private boolean jnlp = false;
    private String[] args;
    private String arg_rates;
    private String arg_filter;
    String filter;
    private CLIInterface cliInterface;
    private boolean updateRatesWanted = false;
    private boolean removeUserPropsWanted = false;

    public CLI(String[] args, CLIInterface cliInterface) {
        if (args.length == 0) {
            return;
        }
        this.args = args;
        this.cliInterface = cliInterface;
        Arguments arguments = new Arguments(args, "-rates|-filter");
        if (arguments.listArguments().size() > 0) {
            if (arguments.receivedArgument("-help") || arguments.receivedArgument("-h")) {
                CLI.printUsage();
                this.continueFlow = false;
                return;
            }
            if (arguments.receivedArgument("-verbose")) {
                this.debug = true;
                CurrencyConverter.setDebug(this.debug);
                ExchangeRatesDialog.setDebug(this.debug);
            }
            if (arguments.receivedArgument("-logfile")) {
                this.logfileWanted = true;
            }
            if (arguments.receivedArgument("-reset")) {
                this.removeUserPropsWanted = true;
            }
            if (arguments.receivedArgument("-jnlp")) {
                this.debug = false;
                this.jnlp = true;
            }
            if (arguments.receivedArgument("-rates") && arguments.receivedArgument("-filter")) {
                this.continueFlow = arguments.receivedArgument("-continue");
                this.updateRatesWanted = true;
                try {
                    this.arg_rates = arguments.getStringValueOf("-rates");
                    this.arg_filter = arguments.getStringValueOf("-filter");
                }
                catch (InvalidArgumentException ex) {
                    System.err.println(ex);
                    this.continueFlow = false;
                }
            }
        }
    }

    public void removeUserProps() {
        System.out.print("Removing user properties ... ");
        File f = new File(System.getProperty("user.home") + File.separator + ".NumericalChameleon/.nc.properties");
        try {
            if (f.exists()) {
                f.delete();
            }
            System.out.println("OK.");
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void updateRates() {
        try {
            JTextArea textArea = new JTextArea();
            Counter counter = new Counter();
            ExchangeRates exchangeRates = new ExchangeRates();
            CurrencyConverter cc = new CurrencyConverter("/data/rates/" + this.arg_filter + ".filter", this.arg_rates, counter, textArea, exchangeRates, this.cliInterface.getISO3166ResourceBundle());
            if (exchangeRates.success()) {
                try {
                    exchangeRates.writeToDisk();
                    Properties newProps = new Properties();
                    newProps.setProperty("rates_date", exchangeRates.getDate());
                    newProps.setProperty("rates_logic", exchangeRates.getLogic() ? "true" : "false");
                    this.cliInterface.updatePropertiesForAllUsers(newProps);
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            if (this.debug) {
                System.out.println("update finished.");
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public static void printUsage() {
        System.out.println("Program:    " + ProgInfo.getInstance().getProgramName());
        System.out.println("Version:    " + ProgInfo.getInstance().getVersion());
        System.out.println("Patchlevel: " + ProgInfo.getInstance().getPatchLevel());
        System.out.println("Launch:     java -jar nc.jar|nc-portable.jar");
        System.out.println("Options:    [-rates <exchange rates> -filter <exchange rate filter> [-continue]]");
        System.out.println("            [-h|-help]");
        System.out.println("            [-verbose]");
        System.out.println("            [-logfile]");
        System.out.println("            [-reset]");
        System.out.println("            [-jnlp]");
    }

    public boolean isDebugWanted() {
        return this.debug;
    }

    public boolean isLogfileWanted() {
        return this.logfileWanted;
    }

    public boolean isContinuingFlowWanted() {
        return this.continueFlow;
    }

    public boolean isJnlpWanted() {
        return this.jnlp;
    }

    public String[] getArgs() {
        return this.args;
    }

    public boolean isUpdateRatesWanted() {
        return this.updateRatesWanted;
    }

    public boolean isRemoveUserPropsWanted() {
        return this.removeUserPropsWanted;
    }
}

