/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.renderer;

import java.awt.Component;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import net.numericalchameleon.data.Group;
import net.numericalchameleon.gui.common.interfaces.DialogInterface;

public class GroupCellRenderer
extends DefaultListCellRenderer {
    private ResourceBundle rb = null;

    public GroupCellRenderer(DialogInterface dialogInterface) {
        this.rb = dialogInterface.getResourceBundle();
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value != null) {
            String localized;
            Group group = (Group)value;
            try {
                localized = this.rb.getString("Group." + group.getId());
            }
            catch (MissingResourceException mre) {
                localized = group.getId();
            }
            label.setText(localized);
            label.setIcon(group.getIcon());
        }
        return label;
    }
}

