/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.romannumerals;

import java.util.Properties;
import jonelo.sugar.util.GeneralString;
import net.numericalchameleon.util.romannumerals.RomanNumeralException;

public class RomanNumeral {
    public static final int MIN_VALUE = 1;
    public static final int MAX_VALUE = 49999;
    private String sourceString = null;
    private long sourceLong = 0L;
    private static final char _5000 = '\u2181';
    private static final char _10000 = '\u2182';
    private static Properties props = new Properties();

    public static void setL10NProperties(Properties props) {
        RomanNumeral.props = props;
    }

    public RomanNumeral(String roman) throws RomanNumeralException {
        this.setString(roman);
    }

    public RomanNumeral(long myLong) throws RomanNumeralException {
        this.setLong(myLong);
    }

    private int wandle(char c) throws RomanNumeralException {
        switch (c) {
            case '\u2182': {
                return 10000;
            }
            case '\u2181': {
                return 5000;
            }
            case 'M': {
                return 1000;
            }
            case 'D': {
                return 500;
            }
            case 'C': {
                return 100;
            }
            case 'L': {
                return 50;
            }
            case 'X': {
                return 10;
            }
            case 'V': {
                return 5;
            }
            case 'I': {
                return 1;
            }
        }
        throw new RomanNumeralException(props.getProperty(Errors.INVALIDCHAR.name()));
    }

    public void setString(String myString) throws RomanNumeralException {
        this.sourceString = myString.toUpperCase();
        try {
            this.sourceLong = this.convert2Long();
        }
        catch (RomanNumeralException e) {
            this.sourceLong = 0L;
            throw new RomanNumeralException(e.getMessage());
        }
    }

    public void setLong(long myLong) throws RomanNumeralException {
        if (myLong < 1L || myLong > 49999L) {
            throw new RomanNumeralException(props.getProperty(Errors.OUTOFRANGE.name()));
        }
        this.sourceLong = myLong;
        this.sourceString = this.convert2Roman();
    }

    public long toLong() {
        return this.sourceLong;
    }

    public String toRoman() {
        return this.convert2Roman();
    }

    private long convert2Long() throws RomanNumeralException {
        long sum;
        if (this.sourceString.length() == 0) {
            throw new RomanNumeralException(props.getProperty(Errors.ISEMPTY.name()));
        }
        if (GeneralString.countChar(this.sourceString, 'V') > 1) {
            throw new RomanNumeralException(GeneralString.message(props.getProperty(Errors.CHARONLYONCE.name()), 'V'));
        }
        if (GeneralString.countChar(this.sourceString, 'L') > 1) {
            throw new RomanNumeralException(GeneralString.message(props.getProperty(Errors.CHARONLYONCE.name()), 'L'));
        }
        if (GeneralString.countChar(this.sourceString, 'D') > 1) {
            throw new RomanNumeralException(GeneralString.message(props.getProperty(Errors.CHARONLYONCE.name()), 'D'));
        }
        if (this.sourceString.indexOf("IIIII") >= 0) {
            throw new RomanNumeralException(GeneralString.message(props.getProperty(Errors.CHAR4TIMES.name()), 'I'));
        }
        if (this.sourceString.indexOf("XXXXX") >= 0) {
            throw new RomanNumeralException(GeneralString.message(props.getProperty(Errors.CHAR4TIMES.name()), 'X'));
        }
        if (this.sourceString.indexOf("CCCCC") >= 0) {
            throw new RomanNumeralException(GeneralString.message(props.getProperty(Errors.CHAR4TIMES.name()), 'C'));
        }
        int len = this.sourceString.length();
        try {
            sum = this.wandle(this.sourceString.charAt(len - 1));
            for (int i = len - 1; i >= 1; --i) {
                long temp = this.wandle(this.sourceString.charAt(i - 1));
                if ((long)this.wandle(this.sourceString.charAt(i)) <= temp) {
                    sum += temp;
                    continue;
                }
                sum -= temp;
            }
        }
        catch (RomanNumeralException e) {
            throw new RomanNumeralException(e.getMessage());
        }
        if (sum < 1L || sum > 49999L) {
            throw new RomanNumeralException(props.getProperty(Errors.OUTOFRANGE.name()));
        }
        return sum;
    }

    private String convert2Roman() {
        long value;
        StringBuilder buf = new StringBuilder();
        for (value = this.sourceLong; value >= 10000L; value -= 10000L) {
            buf.append('\u2182');
        }
        if (value >= 9000L) {
            buf.append('M');
            buf.append('\u2182');
            value -= 9000L;
        }
        while (value >= 5000L) {
            buf.append('\u2181');
            value -= 5000L;
        }
        if (value >= 4000L) {
            buf.append('M');
            buf.append('\u2181');
            value -= 4000L;
        }
        while (value >= 1000L) {
            buf.append('M');
            value -= 1000L;
        }
        if (value >= 900L) {
            buf.append("CM");
            value -= 900L;
        }
        if (value >= 500L) {
            buf.append('D');
            value -= 500L;
        }
        if (value >= 400L) {
            buf.append("CD");
            value -= 400L;
        }
        while (value >= 100L) {
            buf.append('C');
            value -= 100L;
        }
        if (value >= 90L) {
            buf.append("XC");
            value -= 90L;
        }
        if (value >= 50L) {
            buf.append('L');
            value -= 50L;
        }
        if (value >= 40L) {
            buf.append("XL");
            value -= 40L;
        }
        while (value >= 10L) {
            buf.append('X');
            value -= 10L;
        }
        if (value >= 9L) {
            buf.append("IX");
            value -= 9L;
        }
        if (value >= 5L) {
            buf.append('V');
            value -= 5L;
        }
        if (value >= 4L) {
            buf.append("IV");
            value -= 4L;
        }
        while (value > 0L) {
            buf.append('I');
            --value;
        }
        return buf.toString();
    }

    static {
        props.put(Errors.ISEMPTY.name(), "The roman value may not be empty");
        props.put(Errors.INVALIDCHAR.name(), "The roman value is invalid (only \u2182, \u2181, M, D, C, L, X, V and I are allowed).");
        props.put(Errors.CHARONLYONCE.name(), "The character {0} is allowed only once in a roman number");
        props.put(Errors.CHAR3TIMES.name(), "It is prohibited to use the character {0} more than 3 times in a sequence");
        props.put(Errors.CHAR4TIMES.name(), "It is prohibited to use the character {0} more than 4 times in a sequence");
        props.put(Errors.OUTOFRANGE.name(), "The decimal value must be between 1 and 49999 for roman calculations");
    }

    public static enum Errors {
        INVALIDCHAR,
        ISEMPTY,
        CHARONLYONCE,
        CHAR3TIMES,
        CHAR4TIMES,
        OUTOFRANGE;

    }
}

