/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class BrailleNumber
extends SpokenNumber {
    private static Font font;
    private static final String[] numbers;
    private static final String MINUS = "\u2824";
    private static final String NUMBERSIGN = "\u283c";

    @Override
    protected void convert2Syllables() throws Exception {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add(MINUS);
        }
        this.syllables.add(NUMBERSIGN);
        this.fillSyllables(numbers);
    }

    @Override
    protected int getSupportedDigits() {
        return 100;
    }

    @Override
    public String getSoundDir() {
        return "braille";
    }

    static {
        try {
            String filename = "/data/fonts/UBraille.ttf";
            InputStream inputStream = BrailleNumber.class.getResourceAsStream(filename);
            Font f = Font.createFont(0, inputStream);
            font = f.deriveFont(16.0f);
        }
        catch (FontFormatException ex) {
            System.err.println(ex);
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        numbers = new String[]{"\u281a", "\u2801", "\u2803", "\u2809", "\u2819", "\u2811", "\u280b", "\u281b", "\u2813", "\u280a"};
    }
}

