/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class RomanianNumber
extends SpokenNumber {
    private static final int MASCULIN = 0;
    private static final int FEMININ = 1;
    private static final int NEUTRU = 2;
    private static final String[] UNITATI = new String[]{"", "unu", "doi", "trei", "patru", "cinci", "\u015fase", "\u015fapte", "opt", "nou\u0103"};
    private static final String[] SPREZECE = new String[]{"zece", "unsprezece", "doisprezece", "treisprezece", "paisprezece", "cincisprezece", "\u015faisprezece", "\u015faptesprezece", "optsprezece", "nou\u0103sprezece"};
    private static final String[] ZECI = new String[]{"", "", "dou\u0103zeci", "treizeci", "patruzeci", "cincizeci", "\u015faizeci", "\u015faptezeci", "optzeci", "nou\u0103zeci"};
    private static final String[][] GRUPA = new String[][]{{"sut\u0103", "sute"}, {"mie", "mii"}, {"milion", "milioane"}, {"miliard", "miliarde"}, {"biliard", "biliarde"}, {"triliard", "triliarde"}};
    private static final String ZERO = "zero";
    private static final String MINUS = "minus";
    private static final String DE = "de";
    private static final String SI = "\u015fi";
    private static final String[] UNU = new String[]{"un", "o", "un"};
    private static final String[] UNA = new String[]{"unu", "una", "unu"};
    private static final String[] DOI = new String[]{"doi", "dou\u0103", "dou\u0103"};
    private static final int[] GENGRUPA = new int[]{1, 1, 2, 2, 2, 2};

    public RomanianNumber() {
    }

    public RomanianNumber(long nNumber) throws Exception {
        super(nNumber);
    }

    public RomanianNumber(String strNumber) throws Exception {
        super(strNumber);
    }

    @Override
    protected int getSupportedDigits() {
        return 18;
    }

    @Override
    public String getSoundDir() {
        return "romanian";
    }

    @Override
    protected void convert2Syllables() {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add(MINUS);
        }
        if (this.numberType == 1) {
            String[] single = new String[9];
            System.arraycopy(UNITATI, 1, single, 0, 9);
            this.fillSyllables(ZERO, single);
            return;
        }
        this.number2digits();
        if (this.number.equals("0")) {
            this.syllables.add(ZERO);
        } else {
            int cntGroups;
            block4: for (int i = cntGroups = this.digits.length / 3; i > 0; --i) {
                int nUnits = this.digits[(i - 1) * 3 + 0];
                int nTens = this.digits[(i - 1) * 3 + 1];
                int nHundresds = this.digits[(i - 1) * 3 + 2];
                if (nUnits + nTens + nHundresds == 0) continue;
                if (i == 1) {
                    this.convertThreesome(nUnits, nTens, nHundresds, 0, true);
                    continue;
                }
                switch (nUnits + nTens * 10 + nHundresds * 100) {
                    case 1: {
                        this.syllables.add(UNU[GENGRUPA[i - 1]]);
                        this.syllables.add(GRUPA[i - 1][0]);
                        continue block4;
                    }
                    case 2: {
                        this.syllables.add(DOI[GENGRUPA[i - 1]]);
                        this.syllables.add(GRUPA[i - 1][1]);
                        continue block4;
                    }
                    default: {
                        this.convertThreesome(nUnits, nTens, nHundresds, GENGRUPA[i - 1], false);
                        if (nUnits + nTens * 10 >= 20 || nUnits + nTens * 10 == 0) {
                            this.syllables.add(DE);
                        }
                        this.syllables.add(GRUPA[i - 1][1]);
                    }
                }
            }
        }
        this.addSpaces();
    }

    private void convertThreesome(int nUnits, int nTens, int nHundreds, int nGender, boolean bFirstGroup) {
        switch (nHundreds) {
            case 0: {
                break;
            }
            case 1: {
                this.syllables.add(UNU[1]);
                this.syllables.add(GRUPA[0][0]);
                break;
            }
            case 2: {
                this.syllables.add(DOI[1]);
                this.syllables.add(GRUPA[0][1]);
                break;
            }
            default: {
                this.syllables.add(UNITATI[nHundreds]);
                this.syllables.add(GRUPA[0][1]);
            }
        }
        if (nTens > 1) {
            this.syllables.add(ZECI[nTens]);
            if (nUnits > 0) {
                this.syllables.add(SI);
            }
        } else if (nTens == 1) {
            this.syllables.add(SPREZECE[nUnits]);
        }
        if (nUnits > 0 && nTens != 1) {
            switch (nUnits) {
                case 1: {
                    if (bFirstGroup) {
                        this.syllables.add(UNITATI[1]);
                        break;
                    }
                    this.syllables.add(UNA[nGender]);
                    break;
                }
                case 2: {
                    if (bFirstGroup) {
                        this.syllables.add(UNITATI[2]);
                        break;
                    }
                    this.syllables.add(DOI[nGender]);
                    break;
                }
                default: {
                    this.syllables.add(UNITATI[nUnits]);
                }
            }
        }
    }

    protected void addSpaces() {
        for (int i = 0; i < this.syllables.size() - 1; ++i) {
            this.syllables.set(i, (String)this.syllables.get(i) + " ");
        }
    }

    public static String toString(long nNumber) throws Exception {
        return new RomanianNumber(nNumber).toString();
    }

    public static String toString(String strNumber) throws Exception {
        return new RomanianNumber(strNumber).toString();
    }
}

