/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODTheme;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

class NimRODUtils {
    protected static Color rollColor;
    static final int THIN = 0;
    static final int FAT = 1;
    static final int MATRIX_FAT = 5;
    static Kernel kernelFat;
    static final int MATRIX_THIN = 3;
    static Kernel kernelThin;

    NimRODUtils() {
    }

    static Color getSombra() {
        return NimRODUtils.getColorAlfa(NimRODUtils.getColorTercio(NimRODLookAndFeel.getControlDarkShadow(), Color.black), 64);
    }

    static Color getBrillo() {
        return NimRODUtils.getColorAlfa(NimRODUtils.getColorTercio(NimRODLookAndFeel.getControlHighlight(), Color.white), 64);
    }

    static Color getSombraMenu() {
        return new Color(20, 20, 20, 50);
    }

    static Color getBrilloMenu() {
        return new Color(255, 255, 255, 64);
    }

    static NimRODTheme iniCustomColors(NimRODTheme nt, Properties props) {
        String selection = props.getProperty("nimrodlf.selection");
        String background = props.getProperty("nimrodlf.background");
        String p1 = props.getProperty("nimrodlf.p1");
        String p2 = props.getProperty("nimrodlf.p2");
        String p3 = props.getProperty("nimrodlf.p3");
        String s1 = props.getProperty("nimrodlf.s1");
        String s2 = props.getProperty("nimrodlf.s2");
        String s3 = props.getProperty("nimrodlf.s3");
        String w = props.getProperty("nimrodlf.w");
        String b = props.getProperty("nimrodlf.b");
        String opMenu = props.getProperty("nimrodlf.menuOpacity");
        String opFrame = props.getProperty("nimrodlf.frameOpacity");
        return NimRODUtils.iniCustomColors(nt, selection, background, p1, p2, p3, s1, s2, s3, w, b, opMenu, opFrame);
    }

    static NimRODTheme iniCustomColors(NimRODTheme nt, String selection, String background, String p1, String p2, String p3, String s1, String s2, String s3, String w, String b, String opMenu, String opFrame) {
        if (selection != null) {
            nt.setPrimary(Color.decode(selection));
        }
        if (background != null) {
            nt.setSecondary(Color.decode(background));
        }
        if (p1 != null) {
            nt.setPrimary1(Color.decode(p1));
        }
        if (p2 != null) {
            nt.setPrimary2(Color.decode(p2));
        }
        if (p3 != null) {
            nt.setPrimary3(Color.decode(p3));
        }
        if (s1 != null) {
            nt.setSecondary1(Color.decode(s1));
        }
        if (s2 != null) {
            nt.setSecondary2(Color.decode(s2));
        }
        if (s3 != null) {
            nt.setSecondary3(Color.decode(s3));
        }
        if (w != null) {
            nt.setWhite(Color.decode(w));
        }
        if (b != null) {
            nt.setBlack(Color.decode(b));
        }
        if (opMenu != null) {
            nt.setMenuOpacity(Integer.parseInt(opMenu));
        }
        if (opFrame != null) {
            nt.setFrameOpacity(Integer.parseInt(opFrame));
        }
        return nt;
    }

    static ImageIcon loadRes(String fich) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(NimRODUtils.readStream(NimRODLookAndFeel.class.getResourceAsStream(fich))));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("No se puede cargar el recurso " + fich);
            return null;
        }
    }

    static byte[] readStream(InputStream input) throws IOException {
        int read;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] buffer = new byte[256];
        while ((read = input.read(buffer, 0, 256)) != -1) {
            bytes.write(buffer, 0, read);
        }
        return bytes.toByteArray();
    }

    static void pintaBarraMenu(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        if (menuItem.isOpaque()) {
            g.setColor(menuItem.getBackground());
            g.fillRect(0, 0, menuWidth, menuHeight);
        }
        if (menuItem instanceof JMenu && !((JMenu)menuItem).isTopLevelMenu() && model.isSelected() || model.isArmed()) {
            RoundRectangle2D.Float boton = new RoundRectangle2D.Float();
            boton.x = 1.0f;
            boton.y = 0.0f;
            boton.width = menuWidth - 3;
            boton.height = menuHeight - 1;
            boton.arcwidth = 8.0f;
            boton.archeight = 8.0f;
            GradientPaint grad = new GradientPaint(1.0f, 1.0f, NimRODUtils.getBrilloMenu(), 0.0f, menuHeight, NimRODUtils.getSombraMenu());
            Graphics2D g2D = (Graphics2D)g;
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(bgColor);
            g2D.fill(boton);
            g.setColor(bgColor.darker());
            g2D.draw(boton);
            g2D.setPaint(grad);
            g2D.fill(boton);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
        g.setColor(oldColor);
    }

    static void paintFocus(Graphics g, int x, int y, int width, int height, int r1, int r2, Color color) {
        NimRODUtils.paintFocus(g, x, y, width, height, r1, r2, 2.0f, color);
    }

    static void paintFocus(Graphics g, int x, int y, int width, int height, int r1, int r2, float grosor, Color color) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Stroke oldStroke = g2d.getStroke();
        g2d.setColor(color);
        g2d.setStroke(new BasicStroke(grosor));
        if (r1 == 0 && r2 == 0) {
            g.drawRect(x, y, width, height);
        } else {
            g.drawRoundRect(x, y, width - 1, height - 1, r1, r2);
        }
        g2d.setStroke(oldStroke);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    static Color getRolloverColor() {
        if (rollColor == null) {
            rollColor = NimRODUtils.getColorAlfa(UIManager.getColor("Button.focus"), 40);
        }
        return rollColor;
    }

    static Color getColorAlfa(Color col, int alfa) {
        return new Color(col.getRed(), col.getGreen(), col.getBlue(), alfa);
    }

    static Color getColorMedio(Color a, Color b) {
        return new Color(NimRODUtils.propInt(a.getRed(), b.getRed(), 2), NimRODUtils.propInt(a.getGreen(), b.getGreen(), 2), NimRODUtils.propInt(a.getBlue(), b.getBlue(), 2));
    }

    static ColorUIResource getColorTercio(Color a, Color b) {
        return new ColorUIResource(NimRODUtils.propInt(a.getRed(), b.getRed(), 3), NimRODUtils.propInt(a.getGreen(), b.getGreen(), 3), NimRODUtils.propInt(a.getBlue(), b.getBlue(), 3));
    }

    private static int propInt(int a, int b, int prop) {
        return b + (a - b) / prop;
    }

    static void paintShadowTitleFat(Graphics g, String title, int x, int y, Color frente) {
        NimRODUtils.paintShadowTitle(g, title, x, y, frente, Color.black, 1, 1, 0);
    }

    static void paintShadowTitleFat(Graphics g, String title, int x, int y, Color frente, Color shadow) {
        NimRODUtils.paintShadowTitle(g, title, x, y, frente, shadow, 1, 1, 0);
    }

    static void paintShadowTitleFat(Graphics g, String title, int x, int y, Color frente, Color shadow, int desp) {
        NimRODUtils.paintShadowTitle(g, title, x, y, frente, shadow, desp, 1, 0);
    }

    static void paintShadowTitleThin(Graphics g, String title, int x, int y, Color frente) {
        NimRODUtils.paintShadowTitle(g, title, x, y, frente, Color.black, 1, 0, 0);
    }

    static void paintShadowTitleThin(Graphics g, String title, int x, int y, Color frente, Color shadow) {
        NimRODUtils.paintShadowTitle(g, title, x, y, frente, shadow, 1, 0, 0);
    }

    static void paintShadowTitleThin(Graphics g, String title, int x, int y, Color frente, Color shadow, int desp) {
        NimRODUtils.paintShadowTitle(g, title, x, y, frente, shadow, desp, 0, 0);
    }

    static void paintShadowTitleFatV(Graphics g, String title, int x, int y, Color frente) {
        NimRODUtils.paintShadowTitle(g, title, x, y, frente, Color.black, 1, 1, 1);
    }

    static void paintShadowTitleFatV(Graphics g, String title, int x, int y, Color frente, Color shadow) {
        NimRODUtils.paintShadowTitle(g, title, x, y, frente, shadow, 1, 1, 1);
    }

    static void paintShadowTitleFatV(Graphics g, String title, int x, int y, Color frente, Color shadow, int desp) {
        NimRODUtils.paintShadowTitle(g, title, x, y, frente, shadow, desp, 1, 1);
    }

    static void paintShadowTitleThinV(Graphics g, String title, int x, int y, Color frente) {
        NimRODUtils.paintShadowTitle(g, title, x, y, frente, Color.black, 1, 0, 1);
    }

    static void paintShadowTitleThinV(Graphics g, String title, int x, int y, Color frente, Color shadow) {
        NimRODUtils.paintShadowTitle(g, title, x, y, frente, shadow, 1, 0, 1);
    }

    static void paintShadowTitleThinV(Graphics g, String title, int x, int y, Color frente, Color shadow, int desp) {
        NimRODUtils.paintShadowTitle(g, title, x, y, frente, shadow, desp, 0, 1);
    }

    static void paintShadowTitle(Graphics g, String title, int x, int y, Color frente, Color shadow, int desp, int tipo, int orientation) {
        Font f = g.getFont();
        if (orientation == 1) {
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            f = f.deriveFont(rotate);
        }
        if (shadow != null) {
            int h;
            int w;
            int matrix = tipo == 0 ? 3 : 5;
            Rectangle2D rect = g.getFontMetrics().getStringBounds(title, g);
            if (orientation == 0) {
                w = (int)rect.getWidth() + 6 * matrix;
                h = (int)rect.getHeight() + 6 * matrix;
            } else {
                h = (int)rect.getWidth() + 6 * matrix;
                w = (int)rect.getHeight() + 6 * matrix;
            }
            BufferedImage iTitulo = new BufferedImage(w, h, 2);
            BufferedImage iSombra = new BufferedImage(w, h, 2);
            Graphics2D g2 = iTitulo.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setFont(f);
            g2.setColor(shadow);
            g2.drawString(title, 3 * matrix, 3 * matrix);
            ConvolveOp cop = new ConvolveOp(tipo == 0 ? kernelThin : kernelFat, 1, null);
            cop.filter(iTitulo, iSombra);
            g.drawImage(iSombra, x - 3 * matrix + desp, y - 3 * matrix + desp, null);
        }
        if (frente != null) {
            g.setFont(f);
            g.setColor(frente);
            g.drawString(title, x, y);
        }
    }

    static Icon reescala(Icon ic, int maxW, int maxH) {
        if (ic == null) {
            return null;
        }
        if (ic.getIconHeight() == maxH && ic.getIconWidth() == maxW) {
            return ic;
        }
        BufferedImage bi = new BufferedImage(ic.getIconHeight(), ic.getIconWidth(), 2);
        Graphics2D g = bi.createGraphics();
        ic.paintIcon(null, g, 0, 0);
        g.dispose();
        Image bf = bi.getScaledInstance(maxW, maxH, 4);
        return new ImageIcon(bf);
    }

    static int getOpacity() {
        return NimRODUtils.getMenuOpacity();
    }

    static int getMenuOpacity() {
        try {
            NimRODTheme th = (NimRODTheme)NimRODLookAndFeel.theme;
            return th.getMenuOpacity();
        }
        catch (Throwable ex) {
            return 195;
        }
    }

    static float getMenuOpacityFloat() {
        return (float)NimRODUtils.getMenuOpacity() / 255.0f;
    }

    static int getFrameOpacity() {
        try {
            NimRODTheme th = (NimRODTheme)NimRODLookAndFeel.theme;
            return th.getFrameOpacity();
        }
        catch (Throwable ex) {
            return 180;
        }
    }

    static float getFrameOpacityFloat() {
        return (float)NimRODUtils.getFrameOpacity() / 255.0f;
    }
}

