/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.OldWorldCalendar;

abstract class CopticEthiopicCalendar
extends OldWorldCalendar {
    private static final int[] cumulative_days_in_ordinary_year = new int[]{0, 30, 60, 90, 120, 150, 180, 210, 240, 270, 300, 330, 360, 365};
    private static final int[] cumulative_days_in_leap_year = new int[]{0, 30, 60, 90, 120, 150, 180, 210, 240, 270, 300, 330, 360, 366};
    private final int J_FIRST;
    protected static final int COPTIC = CopticEthiopicCalendar.date2jdn_julian(284, 8, 29);
    protected static final int ETHIOPIC = CopticEthiopicCalendar.date2jdn_julian(8, 8, 29);
    private static final long serialVersionUID = 1L;

    protected CopticEthiopicCalendar(int n) {
        this.J_FIRST = n;
    }

    @Override
    protected void jdn2date(int n) {
        if (n < this.J_FIRST) {
            throw new IllegalArgumentException("CopticEthiopicCalendar jdn2date (int n)");
        }
        int n2 = this.J_FIRST - 365;
        int n3 = n - n2;
        int n4 = n3 / 1461;
        int n5 = n3 % 1461;
        int n6 = Math.min(3, n5 / 365);
        int n7 = n5 - 365 * n6;
        this.year = 4 * n4 + n6;
        this.month = n7 / 30 + 1;
        this.day = n7 % 30 + 1;
        if (!this.isDate(this.year, this.month, this.day)) {
            throw new IllegalArgumentException("CopticEthiopicCalendar jdn2date year=" + this.year + " month=" + this.month + " day=" + this.day + " n=" + n);
        }
    }

    @Override
    protected int date2jdn(int n, int n2, int n3) {
        return this.J_FIRST + 365 * (n - 1) + n / 4 + this.getCumulativeDays(n, n2 - 1) + n3 - 1;
    }

    @Override
    protected void doy2date(int n, int n2) {
        this.year = n;
        this.month = (n2 - 1) / 30 + 1;
        this.day = n2 - this.getCumulativeDays(n, this.month - 1);
        if (!this.isDate(n, this.month, this.day)) {
            throw new IllegalArgumentException("CopticEthiopicCalendar doy2date year=" + n + " month=" + this.month + " day=" + this.day + " doy=" + n2);
        }
    }

    @Override
    protected int getCumulativeDays(int n, int n2) {
        return this.isLeapYear(n) ? cumulative_days_in_leap_year[n2] : cumulative_days_in_ordinary_year[n2];
    }

    @Override
    public boolean isLeapYear(int n) {
        return (n + 1) % 4 == 0;
    }

    @Override
    public int getLengthOfMonth(int n, int n2) {
        return n2 < 13 ? 30 : (this.isLeapYear(n) ? 6 : 5);
    }

    @Override
    public int getLastMonthOfYear(int n) {
        return 13;
    }
}

