/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.OldWorldCalendar;
import fi.joensuu.joyds1.calendar.nepali.Table;
import java.util.Arrays;
import java.util.GregorianCalendar;

public class NepaliCalendar
extends OldWorldCalendar {
    private static final long serialVersionUID = 1L;
    private static final int[] y = Table.Years.y;
    private static final int[][] m = Table.Months.m;
    private static final int[][] c = Table.CumulativeMonths.c;
    public static final int FIRST_JULIAN_DAY = NepaliCalendar.date2jdn_gregorian(1833, 4, 14);
    private static final int LAST_JULIAN_DAY = NepaliCalendar.date2jdn_gregorian(2253, 4, 17);
    private static final int FIRST_YEAR = 1890;

    public NepaliCalendar() {
        this(NepaliCalendar.getToday());
    }

    public NepaliCalendar(int n, int n2, int n3) {
        this.set(n, n2, n3);
    }

    public NepaliCalendar(int n, int n2) {
        this.set(n, n2);
    }

    public NepaliCalendar(int n) {
        this.set(n);
    }

    public NepaliCalendar(Calendar calendar) {
        this.set(calendar);
    }

    public NepaliCalendar(GregorianCalendar gregorianCalendar) {
        this.set(gregorianCalendar);
    }

    @Override
    protected void jdn2date(int n) {
        if (n < FIRST_JULIAN_DAY || n > LAST_JULIAN_DAY) {
            throw new IllegalArgumentException("NepaliCalendar jdn2date (int n) " + FIRST_JULIAN_DAY + " n=" + n + " " + LAST_JULIAN_DAY);
        }
        int n2 = n - FIRST_JULIAN_DAY + 1;
        this.year = Arrays.binarySearch(y, n2);
        if (this.year < 0) {
            this.year = -this.year - 1;
        }
        this.doy2date(this.year + 1890 - 1, n2 - y[this.year - 1]);
        if (!this.isDate(this.year, this.month, this.day)) {
            throw new IllegalArgumentException("NepaliCalendar jdn2date year=" + this.year + " month=" + this.month + " day=" + this.day + " n=" + n);
        }
    }

    @Override
    protected int date2jdn(int n, int n2, int n3) {
        return FIRST_JULIAN_DAY - 1 + y[n - 1890] + this.getCumulativeDays(n, n2 - 1) + n3;
    }

    @Override
    protected void doy2date(int n, int n2) {
        if (n2 < 1 || n2 > this.getLengthOfYear(n)) {
            throw new IllegalArgumentException("NepaliCalendar doy2date year=" + n + " doy=" + n2);
        }
        this.year = n;
        this.month = Arrays.binarySearch(c[n - 1890], n2);
        if (this.month < 0) {
            this.month = -this.month - 1;
        }
        this.day = n2 - this.getCumulativeDays(n, this.month - 1);
        if (!this.isDate(this.year, this.month, this.day)) {
            throw new IllegalArgumentException("NepaliCalendar doy2date this.year=" + this.year + " this.month=" + this.month + " this.day=" + this.day + " doy=" + n2);
        }
    }

    @Override
    protected int getCumulativeDays(int n, int n2) {
        return c[n - 1890][n2];
    }

    @Override
    public int getLengthOfYear(int n) {
        return c[n - 1890][12];
    }

    @Override
    public int getLengthOfMonth(int n, int n2) {
        return m[n - 1890][n2];
    }

    @Override
    public int getFirstJulianDay() {
        return FIRST_JULIAN_DAY;
    }
}

