/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.util;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.CalendarFromString;
import fi.joensuu.joyds1.calendar.GregorianCalendar;
import fi.joensuu.joyds1.calendar.Resources;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

class MyTableModel
extends AbstractTableModel {
    private final Calendar c = new GregorianCalendar();
    private Object[][] data = new Object[calendarName.length][this.getColumnCount()];
    private static final String[] calendarName = CalendarFromString.getCalendarNames();
    private static final String[] unsortedLocalizedCalendarName = CalendarFromString.getLocalizedCalendarNames();
    private static final String[] columnNames = new String[]{Resources.getString("Calendar"), Resources.getString("Cycle"), Resources.getString("Year"), Resources.getString("Month"), Resources.getString("Day"), Resources.getString("LeapMonth")};
    private static final String ERR = "?";
    private final Calendar[] calendar = new Calendar[calendarName.length];
    private static final String IS_LEAP_MONTH = Resources.getString("IsLeapMonth");
    private static final String IS_NOT_LEAP_MONTH = Resources.getString("IsNotLeapMonth");
    private static final long serialVersionUID = 1L;

    MyTableModel() {
        int n;
        Object[] objectArray = new String[calendarName.length];
        for (n = 0; n < calendarName.length; ++n) {
            objectArray[n] = unsortedLocalizedCalendarName[n];
        }
        Arrays.sort(objectArray);
        for (n = 0; n < calendarName.length; ++n) {
            this.calendar[n] = CalendarFromString.getCalendarFromLocalizedName((String)objectArray[n]);
            if (this.calendar[n] == null) {
                throw new IllegalArgumentException((String)objectArray[n]);
            }
            this.data[n][0] = objectArray[n];
            for (int i = 1; i < this.getColumnCount(); ++i) {
                this.data[n][i] = "";
            }
        }
        this.setCalendars(this.c);
    }

    @Override
    public int getRowCount() {
        return calendarName.length;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.data[n][n2];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Object object2 = this.getValueAt(n, n2);
        if (n2 == 5 && !this.isMayanCalendar(n)) {
            try {
                this.data[n][n2] = MyTableModel.getLeapString(MyTableModel.getBoolean(object));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(null, Resources.getString("NotLeapMonth", (String)object, IS_LEAP_MONTH, IS_NOT_LEAP_MONTH));
            }
        } else {
            try {
                this.data[n][n2] = new Integer((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(null, Resources.getString("NotInteger", (String)object));
            }
        }
        if (!this.update(n)) {
            JOptionPane.showMessageDialog(null, Resources.getString("NotDate", this.toString(n)));
            this.data[n][n2] = object2;
        }
        for (int i = 0; i < calendarName.length; ++i) {
            if (this.RowHasERRs(i)) {
                System.out.println("boo " + i);
            }
            for (int j = 1; j < this.getColumnCount(); ++j) {
                if (!this.isCellEditable(i, j)) continue;
                this.fireTableCellUpdated(i, j);
            }
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 0: {
                return false;
            }
            case 1: {
                return this.isChineseCalendar(n) || this.isMayanCalendar(n);
            }
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
            case 5: {
                return this.hasLeapMonth(n) || this.isMayanCalendar(n);
            }
        }
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    private final String toString(int n) {
        String string = this.getValueAt(n, 2) + "-" + this.getValueAt(n, 3) + "-" + this.getValueAt(n, 4);
        if (this.isChineseCalendar(n) || this.isMayanCalendar(n)) {
            string = this.getValueAt(n, 1) + "-" + string;
        }
        if (this.hasLeapMonth(n)) {
            string = string + "-" + this.getValueAt(n, 5);
        }
        return string;
    }

    private final boolean hasLeapMonth(int n) {
        return this.isChineseCalendar(n) || this.isHinduLunarCalendar(n);
    }

    private final boolean isChineseCalendar(int n) {
        return this.getCalendarName(n).compareTo(Resources.getString("ChineseCalendar")) == 0;
    }

    private final boolean isHinduLunarCalendar(int n) {
        return this.getCalendarName(n).compareTo(Resources.getString("HinduLunarCalendar")) == 0;
    }

    private final boolean isMayanCalendar(int n) {
        return this.getCalendarName(n).compareTo(Resources.getString("MayanCalendar")) == 0;
    }

    private final String getCalendarName(int n) {
        return (String)this.data[n][0];
    }

    private final void setCalendars(Calendar calendar) {
        for (int i = 0; i < calendarName.length; ++i) {
            try {
                this.calendar[i].set(calendar);
                if (this.isMayanCalendar(i)) {
                    this.data[i][1] = this.calendar[i].getBaktun();
                    this.data[i][2] = this.calendar[i].getKatun();
                    this.data[i][3] = this.calendar[i].getTun();
                    this.data[i][4] = this.calendar[i].getUinal();
                    this.data[i][5] = this.calendar[i].getKin();
                    continue;
                }
                try {
                    this.data[i][1] = this.calendar[i].getCycle();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.data[i][1] = "";
                }
                try {
                    this.data[i][2] = this.calendar[i].getYear();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.data[i][2] = "";
                }
                try {
                    this.data[i][3] = this.calendar[i].getMonth();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.data[i][3] = "";
                }
                try {
                    this.data[i][4] = this.calendar[i].getDay();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.data[i][4] = "";
                }
                try {
                    this.data[i][5] = MyTableModel.getLeapString(this.calendar[i].isLeapMonth());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.data[i][5] = "";
                }
                continue;
            }
            catch (Throwable throwable) {
                if (this.isCellEditable(i, 1)) {
                    this.data[i][1] = ERR;
                }
                this.data[i][2] = ERR;
                this.data[i][3] = ERR;
                this.data[i][4] = ERR;
                if (!this.isCellEditable(i, 5)) continue;
                this.data[i][5] = ERR;
            }
        }
    }

    private final boolean update(int n) {
        try {
            if (this.isMayanCalendar(n) && this.valueOK(n, 1, 5)) {
                this.calendar[n].set((int)((Integer)this.getValueAt(n, 1)), (int)((Integer)this.getValueAt(n, 2)), (int)((Integer)this.getValueAt(n, 3)), (int)((Integer)this.getValueAt(n, 4)), (Integer)this.getValueAt(n, 5));
            } else if (this.isChineseCalendar(n) && this.valueOK(n, 1, 5)) {
                this.calendar[n].set((int)((Integer)this.getValueAt(n, 1)), (int)((Integer)this.getValueAt(n, 2)), (int)((Integer)this.getValueAt(n, 3)), (int)((Integer)this.getValueAt(n, 4)), MyTableModel.getBoolean(this.getValueAt(n, 5)));
            } else if (this.hasLeapMonth(n) && this.valueOK(n, 2, 5)) {
                this.calendar[n].set((Integer)this.getValueAt(n, 2), (Integer)this.getValueAt(n, 3), (Integer)this.getValueAt(n, 4), MyTableModel.getBoolean(this.getValueAt(n, 5)));
            } else if (this.valueOK(n, 2, 4)) {
                this.calendar[n].set((Integer)this.getValueAt(n, 2), (Integer)this.getValueAt(n, 3), (Integer)this.getValueAt(n, 4));
            }
            this.c.set(this.calendar[n]);
            this.setCalendars(this.c);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private final boolean valueOK(int n, int n2, int n3) {
        for (int i = n2; i <= n3; ++i) {
            if (!(this.getValueAt(n, i) instanceof String) || ((String)this.getValueAt(n, i)).compareTo(ERR) != 0) continue;
            return false;
        }
        return true;
    }

    private static final String getLeapString(boolean bl) {
        return bl ? IS_LEAP_MONTH : IS_NOT_LEAP_MONTH;
    }

    private static final boolean getBoolean(Object object) {
        String string = (String)object;
        if (string.compareTo(IS_LEAP_MONTH) == 0) {
            return true;
        }
        if (string.compareTo(IS_NOT_LEAP_MONTH) == 0) {
            return false;
        }
        throw new IllegalArgumentException(string);
    }

    private final boolean RowHasERRs(int n) {
        for (int i = 1; i < this.getColumnCount(); ++i) {
            if (!this.isCellEditable(n, i) || !(this.data[n][i] instanceof String) || ((String)this.data[n][i]).compareTo(ERR) != 0) continue;
            System.out.println("huu " + this.data[n][0] + " [" + this.data[n][i] + "]");
            return true;
        }
        return false;
    }
}

