/*
 * Decompiled with CFR 0.152.
 */
package jonelo.sugar.util;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;

public class GeneralString {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String specialChars = "=: \t\r\n\f#!";

    public static char nibbleToHexChar(int nibble) {
        return hexDigits[nibble & 0xF];
    }

    public static String replaceString(String source, String oldString, String newString) {
        int pos = source.indexOf(oldString);
        if (pos > -1) {
            StringBuilder sb = new StringBuilder();
            sb.append(source.substring(0, pos));
            sb.append(newString);
            sb.append(source.substring(pos + oldString.length()));
            return sb.toString();
        }
        return source;
    }

    public static String replaceAllStrings(String source, String oldString, String newString) {
        StringBuilder buffer = new StringBuilder(source);
        int idx = source.length();
        int offset = oldString.length();
        while ((idx = buffer.toString().lastIndexOf(oldString, idx - 1)) > -1) {
            buffer.replace(idx, idx + offset, newString);
        }
        return buffer.toString();
    }

    public static void replaceAllStrings(StringBuffer source, String oldString, String newString) {
        int idx = source.length();
        int offset = oldString.length();
        while ((idx = source.toString().lastIndexOf(oldString, idx - 1)) > -1) {
            source.replace(idx, idx + offset, newString);
        }
    }

    public static String removeAllStrings(String source, String oldString) {
        return GeneralString.replaceAllStrings(source, oldString, "");
    }

    public static String replaceString(String s, int pos, String newString) {
        StringBuilder sb = new StringBuilder(s);
        for (int i = 0; i < newString.length(); ++i) {
            sb.setCharAt(pos + i, newString.charAt(i));
        }
        return sb.toString();
    }

    public static String translateEscapeSequences(String s) {
        String temp = s;
        temp = GeneralString.replaceAllStrings(temp, "\\t", "\t");
        temp = GeneralString.replaceAllStrings(temp, "\\n", "\n");
        temp = GeneralString.replaceAllStrings(temp, "\\r", "\r");
        temp = GeneralString.replaceAllStrings(temp, "\\\"", "\"");
        temp = GeneralString.replaceAllStrings(temp, "\\'", "'");
        temp = GeneralString.replaceAllStrings(temp, "\\\\", "\\");
        return temp;
    }

    public static String removeChar(String s, char c) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == c) continue;
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    public static String removeChar(String s, int pos) {
        StringBuilder buf = new StringBuilder(s.length() - 1);
        buf.append(s.substring(0, pos)).append(s.substring(pos + 1));
        return buf.toString();
    }

    public static String replaceChar(String s, char oldC, char newC) {
        StringBuilder sb = new StringBuilder(s);
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != oldC) continue;
            sb.setCharAt(i, newC);
        }
        return sb.toString();
    }

    public static String replaceChar(String s, int pos, char c) {
        StringBuilder sb = new StringBuilder(s);
        sb.setCharAt(pos, c);
        return sb.toString();
    }

    public static int countChar(String s, char c) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static String message(String s, char c) {
        Character character = new Character(c);
        Object[] aobj = new Object[]{character.toString()};
        return MessageFormat.format(s, aobj);
    }

    public static String message(String s, int i) {
        Integer integer = new Integer(i);
        Object[] aobj = new Object[]{integer.toString()};
        return MessageFormat.format(s, aobj);
    }

    public static String message(String s, int i1, int i2) {
        Integer integer = new Integer(i1);
        Integer integer2 = new Integer(i2);
        Object[] aobj = new Object[]{integer.toString(), integer2.toString()};
        return MessageFormat.format(s, aobj);
    }

    public static String message(String s, String s1) {
        Object[] aobj = new Object[]{s1};
        return MessageFormat.format(s, aobj);
    }

    public static String message(String s, String s1, String s2) {
        Object[] aobj = new Object[]{s1, s2};
        return MessageFormat.format(s, aobj);
    }

    public static String decodeEncodedUnicode(String string) {
        int length = string.length();
        StringBuilder buffer = new StringBuilder(length);
        int x = 0;
        block7: while (x < length) {
            char c;
            if ((c = string.charAt(x++)) == '\\') {
                c = string.charAt(x++);
                switch (c) {
                    case 'u': {
                        int value = 0;
                        for (int i = 0; i < 4; ++i) {
                            if ((c = string.charAt(x++)) >= '0' && c <= '9') {
                                value = (value << 4) + c - 48;
                                continue;
                            }
                            if (c >= 'a' && c <= 'f') {
                                value = (value << 4) + 10 + c - 97;
                                continue;
                            }
                            if (c >= 'A' && c <= 'F') {
                                value = (value << 4) + 10 + c - 65;
                                continue;
                            }
                            throw new IllegalArgumentException("Wrong \\uxxxx encoding");
                        }
                        buffer.append((char)value);
                        continue block7;
                    }
                    case 'n': {
                        buffer.append('\n');
                        continue block7;
                    }
                    case 't': {
                        buffer.append('\t');
                        continue block7;
                    }
                    case 'r': {
                        buffer.append('\r');
                        continue block7;
                    }
                    case 'f': {
                        buffer.append('\f');
                        continue block7;
                    }
                }
                buffer.append(c);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String encodeUnicode(String string) {
        int length = string.length();
        StringBuilder buffer = new StringBuilder(length * 2);
        block8: for (int x = 0; x < length; ++x) {
            char c = string.charAt(x);
            switch (c) {
                case ' ': {
                    buffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block8;
                }
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block8;
                }
                case '\t': {
                    buffer.append('\\');
                    buffer.append('t');
                    continue block8;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block8;
                }
                case '\f': {
                    buffer.append('\\');
                    buffer.append('f');
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        buffer.append('\\');
                        buffer.append('u');
                        buffer.append(GeneralString.nibbleToHexChar(c >> 12 & 0xF));
                        buffer.append(GeneralString.nibbleToHexChar(c >> 8 & 0xF));
                        buffer.append(GeneralString.nibbleToHexChar(c >> 4 & 0xF));
                        buffer.append(GeneralString.nibbleToHexChar(c & 0xF));
                        continue block8;
                    }
                    if (specialChars.indexOf(c) != -1) {
                        buffer.append('\\');
                    }
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public static String[] split(String str, String delimiter) {
        ArrayList<String> al = new ArrayList<String>();
        int startpos = 0;
        int found = -1;
        do {
            if ((found = str.substring(startpos).indexOf(delimiter)) <= -1) continue;
            al.add(str.substring(startpos, startpos + found));
            startpos = startpos + found + delimiter.length();
        } while (found > -1);
        if (startpos < str.length()) {
            al.add(str.substring(startpos));
        }
        String[] s = new String[al.size()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = (String)al.get(i);
        }
        return s;
    }

    public static String wikipediaLinkFromDate(Calendar cal) {
        return GeneralString.wikipediaLinkFromDate(cal, "en");
    }

    public static String wikipediaLinkFromDate(Calendar cal, String language) {
        SimpleDateFormat formatter = new SimpleDateFormat("MMMM");
        String monthAsName = formatter.format(cal.getTime());
        String filename = null;
        if (language.equals("en")) {
            filename = monthAsName + "_" + cal.get(5);
        } else if (language.equals("de")) {
            filename = cal.get(5) + "._" + monthAsName;
        } else if (language.equals("fr")) {
            StringBuilder sb = new StringBuilder();
            sb.append(Integer.toString(cal.get(5)));
            if (cal.get(5) == 1) {
                sb.append("er");
            }
            sb.append("_");
            sb.append(monthAsName);
            filename = sb.toString();
        } else if (language.equals("es")) {
            filename = cal.get(5) + "_de_" + monthAsName;
        } else if (language.equals("pt")) {
            filename = cal.get(5) + "_de_" + monthAsName;
        } else if (language.equals("it")) {
            StringBuilder sb = new StringBuilder();
            sb.append(Integer.toString(cal.get(5)));
            if (cal.get(5) == 1) {
                sb.append("\u00ba");
            }
            sb.append("_");
            sb.append(monthAsName);
            filename = sb.toString();
        } else {
            filename = language.equals("tr") ? cal.get(5) + "_" + monthAsName : monthAsName + "_" + cal.get(5);
        }
        return "http://" + language + ".wikipedia.org/wiki/" + filename;
    }

    public static String trimRight(String string) {
        return string.replaceAll("^\\s+", "");
    }

    public static String trimLeft(String string) {
        return string.replaceAll("\\s+$", "");
    }
}

