/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import net.beeger.squareness.SquarenessLookAndFeel;

public abstract class SquarenessTitlePane
extends JComponent {
    private Icon _maximizeIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
    private Icon _minimizeIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
    private JButton _closeButton = new FrameButton();
    private JButton _maxButton;
    private JButton _iconifyButton;
    private JLabel _titleLabel;
    private boolean _lastCloseable;
    private boolean _lastIconifiable;
    private boolean _lastMaximized;
    private boolean _lastMaximizable;
    private Font _lastFont;
    private String _lastTitle;
    private boolean _firstUpdate = true;

    public SquarenessTitlePane() {
        this._closeButton.setIcon(UIManager.getIcon("InternalFrame.closeIcon"));
        this._closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SquarenessTitlePane.this.close();
            }
        });
        this._maxButton = new FrameButton();
        this._maxButton.setIcon(this._maximizeIcon);
        this._maxButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SquarenessTitlePane.this.isMaximized()) {
                    SquarenessTitlePane.this.restore();
                } else {
                    SquarenessTitlePane.this.maximize();
                }
            }
        });
        this._iconifyButton = new FrameButton();
        this._iconifyButton.setIcon(UIManager.getIcon("InternalFrame.iconifyIcon"));
        this._iconifyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SquarenessTitlePane.this.iconify();
            }
        });
        this.add(this._iconifyButton);
        this.add(this._maxButton);
        this.add(this._closeButton);
        this._titleLabel = new JLabel();
        this._titleLabel.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
        this._titleLabel.setForeground(SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        this.add(this._titleLabel);
        this.setLayout(new SquarenessTitlePaneLayout());
        this.setBackground(SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
    }

    protected void update() {
        boolean bl = this.isClosable();
        boolean bl2 = this.isIconifiable();
        boolean bl3 = this.isMaximized();
        boolean bl4 = this.isMaximizable();
        Font font = UIManager.getFont("InternalFrame.titleFont", this.getLocale());
        String string = this.getTitle();
        if (this._firstUpdate || this._lastCloseable != bl) {
            this._closeButton.setEnabled(bl);
        }
        if (this._firstUpdate || this._lastIconifiable != bl2) {
            this._iconifyButton.setEnabled(bl2);
        }
        if (this._firstUpdate || this._lastMaximized != bl3) {
            this._maxButton.setIcon(bl3 ? this._minimizeIcon : this._maximizeIcon);
        }
        if (this._firstUpdate || this._lastMaximizable != bl4) {
            this._maxButton.setEnabled(bl4);
        }
        if (this._firstUpdate || !font.equals(this._lastFont)) {
            this._titleLabel.setFont(font);
        }
        if (this._firstUpdate || string == null && this._lastTitle != null || string != null && !string.equals(this._lastTitle)) {
            this._titleLabel.setText(string);
        }
        this._lastCloseable = bl;
        this._lastIconifiable = bl2;
        this._lastMaximized = bl3;
        this._lastMaximizable = bl4;
        this._lastFont = font;
        this._lastTitle = string;
        this._firstUpdate = false;
    }

    public abstract boolean isLeftToRight();

    protected abstract boolean isIconifiable();

    protected abstract boolean isMaximizable();

    protected abstract boolean isClosable();

    protected abstract void close();

    protected abstract void iconify();

    protected abstract void maximize();

    protected abstract void restore();

    protected abstract boolean isMaximized();

    protected abstract boolean isIconified();

    protected abstract String getTitle();

    protected static class FrameButton
    extends JButton {
        public FrameButton() {
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.setOpaque(true);
            this.setFocusPainted(false);
        }

        public boolean isFocusable() {
            return false;
        }
    }

    protected class SquarenessTitlePaneLayout
    implements LayoutManager {
        protected SquarenessTitlePaneLayout() {
        }

        public void removeLayoutComponent(Component component) {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(SquarenessTitlePane.this._closeButton.getIcon().getIconWidth() + 60, SquarenessTitlePane.this._closeButton.getIcon().getIconHeight() + 2);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            boolean bl = SquarenessTitlePane.this.isLeftToRight();
            int n = SquarenessTitlePane.this.getWidth();
            int n2 = SquarenessTitlePane.this.getHeight();
            int n3 = SquarenessTitlePane.this._closeButton.getIcon().getIconHeight();
            int n4 = SquarenessTitlePane.this._closeButton.getIcon().getIconWidth();
            int n5 = n2 - n3 >> 1;
            int n6 = bl ? n - n4 - 2 : 2;
            SquarenessTitlePane.this._closeButton.setBounds(n6, n5, n4, n3);
            SquarenessTitlePane.this._maxButton.setBounds(n6 += bl ? -(n4 + 2) : n4 + 2, n5, n4, n3);
            SquarenessTitlePane.this._iconifyButton.setBounds(n6 += bl ? -(n4 + 2) : n4 + 2, n5, n4, n3);
            int n7 = bl ? n6 - 2 : n - 2;
            n6 = bl ? 2 : n6 + 2;
            SquarenessTitlePane.this._titleLabel.setBounds(n6, n5, n7 - n6, n3);
        }
    }
}

