/*
 * Decompiled with CFR 0.152.
 */
package jscicalc;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ListIterator;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import jscicalc.Navigator;
import jscicalc.ReadOnlyDisplayPanel;
import jscicalc.WhitePanel;

public abstract class ScrollableLabel
extends JViewport {
    protected boolean caretVisible;
    protected Navigator navigator;
    protected String expression;
    protected int dotPosition;
    protected JPanel jPanel;
    protected JTextPane textPane;
    protected ReadOnlyDisplayPanel panel;
    protected boolean newExpression;
    protected Action backward;
    protected Action forward;
    private static final long serialVersionUID = 1L;

    public ScrollableLabel(ReadOnlyDisplayPanel readOnlyDisplayPanel, Navigator navigator) {
        this.setBackground(Color.white);
        this.jPanel = new WhitePanel();
        this.textPane = new JTextPane();
        this.textPane.setContentType("text/html");
        this.textPane.setEditable(false);
        this.navigator = navigator;
        this.textPane.setNavigationFilter(navigator);
        this.jPanel.add(this.textPane);
        this.setView(this.jPanel);
        this.expression = "";
        this.dotPosition = 0;
        this.newExpression = true;
        this.panel = readOnlyDisplayPanel;
        this.update(false);
        this.backward = this.textPane.getActionMap().get("caret-backward");
        this.forward = this.textPane.getActionMap().get("caret-forward");
    }

    public abstract void update(boolean var1);

    public void left() {
        int n = this.textPane.getCaret().getDot();
        ListIterator<Integer> listIterator = this.navigator.dots().listIterator();
        while (listIterator.hasNext()) {
            int n2 = listIterator.next();
            if (n2 < n) continue;
            listIterator.previous();
            break;
        }
        this.dotPosition = listIterator.hasPrevious() ? listIterator.previous() : 0;
    }

    public void right() {
        int n = this.textPane.getCaret().getDot();
        ListIterator<Integer> listIterator = this.navigator.dots().listIterator(this.navigator.dots().size());
        while (listIterator.hasPrevious()) {
            int n2 = listIterator.previous();
            if (n2 > n) continue;
            listIterator.next();
            break;
        }
        this.dotPosition = listIterator.hasNext() ? listIterator.next() : this.navigator.dots().lastElement();
    }

    protected int getDotPosition() {
        int n;
        if (this.navigator == null) {
            System.out.println("ScrollableLabel.getDotPosition(): navigator == null");
        }
        return (n = this.navigator.dots().indexOf(this.textPane.getCaret().getDot())) == -1 ? 0 : n;
    }

    public void newExpression() {
        this.newExpression = true;
        this.setCaretVisible(false);
    }

    public void updateCaretVisibility() {
        if (this.caretVisible && this.panel.hasCaret(this)) {
            this.textPane.getCaret().setVisible(true);
        } else {
            this.textPane.getCaret().setVisible(false);
        }
        this.textPane.getCaret().setDot(this.dotPosition);
    }

    protected void setCaretVisible(boolean bl) {
        this.caretVisible = bl;
        this.updateCaretVisibility();
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(graphics);
    }
}

