/*
 * Decompiled with CFR 0.152.
 */
package jscicalc.graph;

import jscicalc.graph.View;

public class Transformation {
    protected View view;
    protected double xScale;
    protected double yScale;
    protected double xOrigin;
    protected double yOrigin;
    protected double xMajorUnit;
    protected double xMinorUnit;
    protected double yMajorUnit;
    protected double yMinorUnit;

    public Transformation(View view) {
        this.view = view;
        this.setScale(10.0);
        this.setOrigin(0.0, 0.0);
        this.setXMajorUnit(5.0);
        this.setXMinorUnit(1.0);
        this.setYMajorUnit(5.0);
        this.setYMinorUnit(1.0);
    }

    public void setScale(double d) {
        if (d <= 0.0) {
            System.err.println("Ignoring attempt to set invalid scale in Transformation.");
            return;
        }
        this.xScale = this.yScale = d;
    }

    public void setScaleY(double d) {
        if (d <= 0.0) {
            System.err.println("Ignoring attempt to set invalid scale in Transformation.");
            return;
        }
        this.yScale = d;
    }

    public void setScaleX(double d) {
        if (d <= 0.0) {
            System.err.println("Ignoring attempt to set invalid scale in Transformation.");
            return;
        }
        this.xScale = d;
    }

    public void setOrigin(double d, double d2) {
        this.xOrigin = d;
        this.yOrigin = d2;
    }

    public void setOriginX(double d) {
        this.xOrigin = d;
    }

    public void setOriginY(double d) {
        this.yOrigin = d;
    }

    double getOriginX() {
        return this.xOrigin;
    }

    double getOriginY() {
        return this.yOrigin;
    }

    public double toModelX(double d) {
        return this.xOrigin + (d - (double)this.view.getWidth() / 2.0) / this.xScale;
    }

    public double toModelY(double d) {
        return this.yOrigin + ((double)this.view.getHeight() / 2.0 - d) / this.yScale;
    }

    public double toViewX(double d) {
        return (d - this.xOrigin) * this.xScale + (double)this.view.getWidth() / 2.0;
    }

    public double toViewY(double d) {
        return (double)this.view.getHeight() / 2.0 + (this.yOrigin - d) * this.yScale;
    }

    double getXMajorUnit() {
        return this.xMajorUnit;
    }

    void setXMajorUnit(double d) {
        this.xMajorUnit = d;
    }

    double getXMinorUnit() {
        return this.xMinorUnit;
    }

    void setXMinorUnit(double d) {
        this.xMinorUnit = d;
    }

    double getYMajorUnit() {
        return this.yMajorUnit;
    }

    void setYMajorUnit(double d) {
        this.yMajorUnit = d;
    }

    double getYMinorUnit() {
        return this.yMinorUnit;
    }

    void setYMinorUnit(double d) {
        this.yMinorUnit = d;
    }
}

