/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;

public class ControlCurve {
    protected Polygon pts = new Polygon();
    protected int selection = -1;
    static Font f = new Font("Courier", 0, 12);
    static final int EPSILON = 36;

    public void paint(Graphics g) {
        FontMetrics fm = g.getFontMetrics(f);
        g.setFont(f);
        int h = fm.getAscent() / 2;
        int i = 0;
        while (i < this.pts.npoints) {
            String s = Integer.toString(i);
            int w = fm.stringWidth(s) / 2;
            g.drawString(Integer.toString(i), this.pts.xpoints[i] - w, this.pts.ypoints[i] + h);
            ++i;
        }
    }

    public int addPoint(int x, int y) {
        this.pts.addPoint(x, y);
        this.selection = this.pts.npoints - 1;
        return this.selection;
    }

    public void setPoint(int x, int y) {
        if (this.selection >= 0) {
            this.pts.xpoints[this.selection] = x;
            this.pts.ypoints[this.selection] = y;
        }
    }

    public void removePoint() {
        if (this.selection >= 0) {
            --this.pts.npoints;
            int i = this.selection;
            while (i < this.pts.npoints) {
                this.pts.xpoints[i] = this.pts.xpoints[i + 1];
                this.pts.ypoints[i] = this.pts.ypoints[i + 1];
                ++i;
            }
        }
    }

    public int selectPoint(int x, int y) {
        int mind = Integer.MAX_VALUE;
        this.selection = -1;
        int i = 0;
        while (i < this.pts.npoints) {
            int d = ControlCurve.sqr(this.pts.xpoints[i] - x) + ControlCurve.sqr(this.pts.ypoints[i] - y);
            if (d < mind && d < 36) {
                mind = d;
                this.selection = i;
            }
            ++i;
        }
        return this.selection;
    }

    private static int sqr(int x) {
        return x * x;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.pts.npoints) {
            result.append(" " + this.pts.xpoints[i] + " " + this.pts.ypoints[i]);
            ++i;
        }
        return result.toString();
    }
}

