/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colorbar;

import gov.nasa.giss.graphics.colorbar.AbstractColorbar;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class PAL1Colorbar
extends AbstractColorbar {
    public PAL1Colorbar(File f) throws IOException, FileNotFoundException {
        super(f);
        byte[] b = this.readBytes(f, 768, 768);
        this.fillColorTable(b);
    }

    public PAL1Colorbar(URL url) throws IOException, FileNotFoundException {
        super(url);
        byte[] b = this.readBytes(url, 768, 768);
        this.fillColorTable(b);
    }

    public PAL1Colorbar(byte[] b, String identifier) throws IOException {
        this.identifier = identifier;
        this.makeName(identifier);
        this.fillColorTable(b);
    }

    private void fillColorTable(byte[] b) throws IOException {
        if (b.length < 768) {
            throw new IOException("Not a valid PAL color table");
        }
        this.colors = new Color[256];
        this.rgbValues = new int[256];
        this.colorCount = 254;
        this.minBin = 1;
        this.maxBin = 254;
        this.minOutlierBin = 0;
        this.maxOutlierBin = 255;
        int i = 0;
        while (i < 256) {
            this.colors[i] = new Color(0xFF & b[i], 0xFF & b[i + 256], 0xFF & b[i + 512]);
            this.rgbValues[i] = this.colors[i].getRGB();
            ++i;
        }
    }

    public String getName() {
        return super.getName() + " PAL-1";
    }
}

