/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.PointDouble;
import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

public class Equirectangular
extends AbstractProjection {
    private static final String PROJECTION_NAME = "Equirectangular";
    private static final boolean IS_AZIMUTHAL = false;
    public static final double ASPECT_RATIO = 2.0;
    private static int GRID_FHGT = 10;
    private static Font GRID_FONT = new Font("Monospaced", 0, GRID_FHGT);
    private double dstXPixPerDeg;
    private double dstYPixPerDeg;
    private double srcXPixPerDeg;

    public Equirectangular(Integer dw, Integer dh, Integer xm, Integer ym, Double lon) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)lon);
    }

    public Equirectangular(int dw, int dh, int xm, int ym, double lon) {
        this.init(dw, dh, xm, ym, lon, 0.0);
        this.dstXPixPerDeg = (double)this.useWidth / 360.0;
        this.dstYPixPerDeg = (double)this.useHeight / 180.0;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 2.0;
    }

    public void drawMap(Image src, Graphics g) {
        this.setSourceMap(src);
        this.drawMap(g);
    }

    public void setSourceMap(Image src) {
        super.setSourceMap(src);
        this.srcXPixPerDeg = (double)this.srcWidth / 360.0;
    }

    public void drawMap(Graphics g) {
        if (this.needsUpdate) {
            this.calculateTransform();
        }
        g.setColor(this.bgcolor);
        g.fillRect(0, 0, this.dstWidth, this.dstHeight);
        if (this.copLon == 0.0) {
            g.drawImage(this.source, this.xMargin, this.yMargin, this.xMargin + this.useWidth, this.yMargin + this.useHeight, 0, 0, this.srcWidth, this.srcHeight, this);
        } else {
            int shiftDst = (int)(this.dstXPixPerDeg * this.copLon);
            int shiftSrc = (int)(this.srcXPixPerDeg * this.copLon);
            while (shiftDst < 0) {
                shiftDst += this.useWidth;
            }
            while (shiftDst > this.srcWidth) {
                shiftDst -= this.useWidth;
            }
            while (shiftSrc < 0) {
                shiftSrc += this.srcWidth;
            }
            while (shiftSrc > this.srcWidth) {
                shiftSrc -= this.srcWidth;
            }
            g.drawImage(this.source, this.xMargin, this.yMargin, this.xMargin + shiftDst, this.yMargin + this.useHeight, this.srcWidth - shiftSrc, 0, this.srcWidth, this.srcHeight, this);
            g.drawImage(this.source, this.xMargin + shiftDst, this.yMargin, this.dstWidth - this.xMargin, this.yMargin + this.useHeight, 0, 0, this.srcWidth - shiftSrc, this.srcHeight, this);
        }
        if (this.drawMapBorder) {
            g.setColor(this.fgcolor);
            g.drawRect(this.xMargin - 1, this.yMargin - 1, this.useWidth + 1, this.useHeight + 1);
        }
    }

    protected void calculateInverseArray() {
        throw new IllegalArgumentException("Equirectangular projection does not use inverse array");
    }

    public void drawLLGrid(Graphics g, int spacing) {
        if (spacing < 5) {
            return;
        }
        int majorStep = spacing * 3;
        g.setColor(this.gridColor);
        g.setFont(GRID_FONT);
        FontMetrics fm = g.getFontMetrics();
        int i = 0;
        while (i < 360) {
            Point xy1 = this.transformLL2XY(i, 89.9);
            Point xy2 = this.transformLL2XY(i, -89.9);
            if (xy1 != null && xy2 != null) {
                if (i % majorStep == 0) {
                    g.drawLine(xy1.x, xy1.y, xy2.x, xy2.y);
                    String s = i + "\u00b0";
                    g.drawString(s, xy1.x - 2 - fm.stringWidth(s), xy1.y + GRID_FHGT);
                    g.drawString(s, xy2.x + 2, xy2.y - 2);
                } else {
                    int j = xy1.y + 5;
                    while (j < xy2.y - 10) {
                        g.drawLine(xy1.x, j, xy1.x, j + 10);
                        j += 20;
                    }
                }
            }
            i += spacing;
        }
        int j = -90 + spacing;
        while (j < 90) {
            Point xy1 = this.transformLL2XY(this.copLon + 180.0 - 0.1, j);
            Point xy2 = this.transformLL2XY(this.copLon - 180.0 + 0.1, j);
            if (xy1 != null && xy2 != null) {
                if (j % majorStep == 0) {
                    g.drawLine(xy1.x, xy1.y, xy2.x, xy2.y);
                    String s = j + "\u00b0";
                    g.drawString(s, xy1.x + 2, xy1.y + GRID_FHGT);
                    g.drawString(s, xy2.x - 2 - fm.stringWidth(s), xy2.y - 2);
                } else {
                    int i2 = xy1.x + 5;
                    while (i2 < xy2.x - 10) {
                        g.drawLine(i2, xy1.y, i2 + 10, xy1.y);
                        i2 += 20;
                    }
                }
            }
            j += spacing;
        }
    }

    private void calculateTransform() {
        this.needsUpdate = false;
    }

    public PointDouble transformXY2LL(int x, int y) {
        if (x > this.dstWidth || y > this.dstHeight) {
            return null;
        }
        double lon = 180.0 - (double)(x - this.xMargin) / this.dstXPixPerDeg + this.copLon;
        double lat = 90.0 - (double)(y - this.yMargin) / this.dstYPixPerDeg;
        while (lon > 360.0) {
            lon -= 360.0;
        }
        while (lon < 0.0) {
            lon += 360.0;
        }
        while (lat > 90.0) {
            lat -= 180.0;
        }
        while (lat < -90.0) {
            lat += 180.0;
        }
        return new PointDouble(lon, lat);
    }

    public Point transformLL2XY(double lon, double lat) {
        double xd = 0.0;
        double yd = 0.0;
        if (lon < 180.0) {
            xd = this.dstXPixPerDeg * (180.0 - lon + this.copLon);
            yd = this.dstYPixPerDeg * (90.0 - lat);
        } else {
            xd = this.dstXPixPerDeg * (540.0 - lon + this.copLon);
            yd = this.dstYPixPerDeg * (90.0 - lat);
        }
        while (xd < 0.0) {
            xd += (double)this.useWidth;
        }
        while (xd > (double)this.useWidth) {
            xd -= (double)this.useWidth;
        }
        return new Point(this.xMargin + (int)xd, this.yMargin + (int)yd);
    }
}

