/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Point;

public class PutninsP3p
extends AbstractProjection {
    private static final String PROJECTION_NAME = "Putni\u0146\u0161 P3'";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TERM_A = Math.sqrt(0.6366197723675814);
    private static final double ONE_OVER_TERM_A = 1.0 / TERM_A;
    private static final double TERM_B = 2.0;
    private static final double TERM_B_OVER_PI_SQUARE = 0.20264236728467555;
    private static final double FIT_WIDTH = TERM_A * Math.PI;
    private static final double FIT_HEIGHT = ONE_OVER_TERM_A;
    public static final double ASPECT_RATIO = FIT_WIDTH / FIT_HEIGHT;
    private double scaleFactor = 1.0;
    private double radius;
    private double rS;
    private double oneOverR;
    private double oneOverRS;

    public PutninsP3p(int dw, int dh) {
        this(dw, dh, 0, 0, 0.0);
    }

    public PutninsP3p(Integer dw, Integer dh, Integer xm, Integer ym, Double longitude) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)longitude);
    }

    public PutninsP3p(int dw, int dh, int xm, int ym, double longitude) {
        this.init(dw, dh, xm, ym, longitude, 0.0);
        this.radius = Math.min(0.5 * (double)this.useHeight / FIT_HEIGHT, 0.5 * (double)this.useWidth / FIT_WIDTH);
        this.oneOverR = 1.0 / this.radius;
        this.rS = this.radius * this.scaleFactor;
        this.oneOverRS = 1.0 / this.rS;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        int y = 0;
        while ((double)y < 0.5 * (double)this.useHeight) {
            int row = this.yCenter - y;
            int rowF = this.yCenter + y;
            double phiRad = (double)y * this.oneOverRS * ONE_OVER_TERM_A;
            double phi = AbstractProjection.toDegrees(phiRad);
            if (phi > 90.0 || phi < -90.0) break;
            int yMap = (int)(this.srcYPixPerDeg * (90.0 - phi));
            int yMapF = (int)(this.srcYPixPerDeg * (90.0 + phi));
            double xFactor = ONE_OVER_TERM_A * this.oneOverRS / (1.0 - phiRad * phiRad * 0.20264236728467555);
            int x = 0;
            while (x < this.xCenter) {
                double dlambda = -AbstractProjection.toDegrees((double)x * xFactor);
                if (dlambda > 180.0 || dlambda < -180.0) break;
                int col = this.xCenter + x;
                int colF = this.xCenter - x;
                int xMap = (int)(this.srcXPixPerDeg * (180.0 - this.copLon - dlambda));
                int xMapF = (int)(this.srcXPixPerDeg * (180.0 - this.copLon + dlambda));
                while (xMap >= this.srcWidth) {
                    xMap -= this.srcWidth;
                }
                while (xMapF >= this.srcWidth) {
                    xMapF -= this.srcWidth;
                }
                while (xMap < 0) {
                    xMap += this.srcWidth;
                }
                while (xMapF < 0) {
                    xMapF += this.srcWidth;
                }
                this.invArray[row * this.dstWidth + col] = yMap * this.srcWidth + xMap;
                this.invArray[row * this.dstWidth + colF] = yMap * this.srcWidth + xMapF;
                this.invArray[rowF * this.dstWidth + col] = yMapF * this.srcWidth + xMap;
                this.invArray[rowF * this.dstWidth + colF] = yMapF * this.srcWidth + xMapF;
                ++x;
            }
            ++y;
        }
        this.needsUpdate = false;
    }

    public Point transformLL2XY(double longitude, double latitude) {
        double phiRad = AbstractProjection.toRadians(latitude);
        double dlambda = longitude - this.copLon;
        while (dlambda > 180.0) {
            dlambda -= 360.0;
        }
        while (dlambda < -180.0) {
            dlambda += 360.0;
        }
        double x = -this.rS * TERM_A * AbstractProjection.toRadians(dlambda) * (1.0 - phiRad * phiRad * 0.20264236728467555);
        double y = this.rS * TERM_A * phiRad;
        return new Point(this.xCenter + (int)x, this.yCenter - (int)y);
    }
}

