/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Point;

public class Sinusoidal
extends AbstractProjection {
    private static final String PROJECTION_NAME = "Sinusoidal";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double FIT_WIDTH = Math.PI;
    private static final double FIT_HEIGHT = 1.5707963267948966;
    public static final double ASPECT_RATIO = 2.0;
    private double scaleFactor = 1.0;
    private double radius;
    private double rS;
    private double oneOverR;
    private double oneOverRS;

    public Sinusoidal(int dw, int dh) {
        this(dw, dh, 0, 0, 0.0);
    }

    public Sinusoidal(Integer dw, Integer dh, Integer xm, Integer ym, Double longitude) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)longitude);
    }

    public Sinusoidal(int dw, int dh, int xm, int ym, double longitude) {
        this.init(dw, dh, xm, ym, longitude, 0.0);
        this.radius = Math.min(0.5 * (double)this.useHeight / 1.5707963267948966, 0.5 * (double)this.useWidth / Math.PI);
        this.oneOverR = 1.0 / this.radius;
        this.rS = this.radius * this.scaleFactor;
        this.oneOverRS = 1.0 / (this.radius * this.scaleFactor);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 2.0;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        int row = this.yMargin;
        while (row < this.dstHeight - this.yMargin) {
            double y = this.yCenter - row;
            double phiRad = y * this.oneOverRS;
            if (!(phiRad > 1.5707963267948966) && !(phiRad < -1.5707963267948966)) {
                int yMap = (int)(this.srcYPixPerDeg * (90.0 - AbstractProjection.toDegrees(phiRad)));
                double xFactor = this.oneOverRS / Math.cos(phiRad);
                int col = 0;
                while (col < this.dstWidth) {
                    double dlambdaRad = (double)(col - this.xCenter) * xFactor;
                    if (!(dlambdaRad > Math.PI) && !(dlambdaRad <= -Math.PI)) {
                        int xMap = (int)(this.srcXPixPerDeg * (180.0 + AbstractProjection.toDegrees(dlambdaRad) - this.copLon));
                        while (xMap >= this.srcWidth) {
                            xMap -= this.srcWidth;
                        }
                        while (xMap < 0) {
                            xMap += this.srcWidth;
                        }
                        this.invArray[row * this.dstWidth + col] = yMap * this.srcWidth + xMap;
                    }
                    ++col;
                }
            }
            ++row;
        }
        this.needsUpdate = false;
    }

    public Point transformLL2XY(double longitude, double latitude) {
        double dlambda = longitude - this.copLon;
        while (dlambda < -180.0) {
            dlambda += 360.0;
        }
        while (dlambda > 180.0) {
            dlambda -= 360.0;
        }
        double phiRad = AbstractProjection.toRadians(latitude);
        double x = -this.rS * AbstractProjection.toRadians(dlambda) * Math.cos(phiRad);
        double y = this.rS * phiRad;
        return new Point(this.xCenter + (int)x, this.yCenter - (int)y);
    }
}

