/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.mars24.LandmarkList;
import gov.nasa.giss.mars24.M24Version;
import gov.nasa.giss.mars24.applet.M24Canvas;
import gov.nasa.giss.mars24.applet.M24ControlPanel;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;

public class Mars24Applet
extends Applet
implements Runnable {
    private static final double DEFAULT_COP_LONGITUDE = 0.0;
    private static final double DEFAULT_COP_LATITUDE = 45.0;
    private Thread mThread = null;
    private Image backdrop;
    private LandmarkList landmarks;
    private M24Canvas canvas;
    private M24ControlPanel controls;

    public String getAppletInfo() {
        return "Mars24 5.1\n\nWritten by Robert B. Schmunk <rschmunk@giss.nasa.gov>\nBased on work by Michael D. Allison <mallison@giss.nasa.gov>.\n\nPrimary references:\nAllison 1997. Geophys. Res. Lett. 24, 1967-1970.\nAllison and McEwen 2000. Planet. Space Sci. 48, 235-255.\n\nAdditional references\nSeidelmann et al. 2002. Celest. Mech. Dynam. Astron. 82, 83-110.\nAllison 2003. Personal communications.\n";
    }

    public void start() {
        if (this.mThread == null) {
            this.mThread = new Thread(this);
            this.mThread.start();
        }
    }

    public void run() {
        while (this.mThread != null) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException exc) {
                // empty catch block
            }
            this.repaint();
        }
        this.mThread = null;
    }

    public void stop() {
        this.mThread = null;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.controls.paint(g);
    }

    public void init() {
        M24Version.printCredits();
        try {
            String backdropFname = this.getParameter("backdrop");
            if (backdropFname != null && backdropFname.length() > 0) {
                this.backdrop = this.getImage(this.getDocumentBase(), backdropFname);
                this.prepareImage(this.backdrop, this);
            }
        }
        catch (Exception exc) {
            System.out.println(exc.toString());
        }
        try {
            this.landmarks = new LandmarkList(this.getDocumentBase(), this.getParameter("landmarks"));
        }
        catch (Exception exc) {
            this.landmarks = new LandmarkList();
        }
        double copLon = 0.0;
        double copLat = 45.0;
        try {
            copLon = Double.valueOf(this.getParameter("longitude"));
            copLat = Double.valueOf(this.getParameter("latitude"));
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.canvas = new M24Canvas(this.landmarks, this.backdrop);
        this.controls = new M24ControlPanel(this.canvas, this.landmarks, copLon, copLat);
        this.setLayout(new BorderLayout());
        this.add((Component)this.canvas, "North");
        this.add((Component)this.controls, "South");
    }
}

