/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.gui.TreeTableModel;
import gov.nasa.giss.netcdf.NCDataset;
import gov.nasa.giss.netcdf.NCDatasetList;
import gov.nasa.giss.netcdf.NCTreeTableNode;
import gov.nasa.giss.netcdf.NCVariable;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class NCTreeTableModel
implements TreeTableModel {
    private static final String PATH_SEP = System.getProperty("file.separator");
    private NCTreeTableNode root;
    private EventListenerList listenerList = new EventListenerList();
    private ArrayList datasetsList = new ArrayList(5);
    private static String[] colNames = new String[]{"Name", "Long Name", "Plottable?"};
    private static Class[] colClasses = new Class[]{class$gov$nasa$giss$gui$TreeTableModel == null ? (class$gov$nasa$giss$gui$TreeTableModel = NCTreeTableModel.class$("gov.nasa.giss.gui.TreeTableModel")) : class$gov$nasa$giss$gui$TreeTableModel, class$java$lang$String == null ? (class$java$lang$String = NCTreeTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NCTreeTableModel.class$("java.lang.String")) : class$java$lang$String};
    private static int[] colAlignments = new int[]{2, 2, 0};
    private boolean listAllVars = false;
    static /* synthetic */ Class class$gov$nasa$giss$gui$TreeTableModel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;

    public NCTreeTableModel() {
        this.root = new NCDatasetList();
        ((NCDatasetList)this.root).setListAllVariables(this.listAllVars);
    }

    public NCTreeTableModel(NCDataset dataset) {
        this.root = new NCDatasetList(dataset);
        dataset.setListAllVariables(this.listAllVars);
        ((NCDatasetList)this.root).setListAllVariables(this.listAllVars);
    }

    public Object getRoot() {
        return this.root;
    }

    public int getChildCount(Object node) {
        Object[] children = this.getChildren(node);
        return children == null ? 0 : children.length;
    }

    protected Object[] getChildren(Object node) {
        return ((NCTreeTableNode)node).getChildren();
    }

    public Object getChild(Object node, int i) {
        return this.getChildren(node)[i];
    }

    public int getColumnCount() {
        return colNames.length;
    }

    public String getColumnName(int col) {
        return colNames[col];
    }

    public Class getColumnClass(int col) {
        return colClasses[col];
    }

    public int getColumnAlignment(int col) {
        return colAlignments[col];
    }

    public int getIndexOfChild(Object parentTTNode, Object child) {
        int i = 0;
        while (i < this.getChildCount(parentTTNode)) {
            if (this.getChild(parentTTNode, i).equals(child)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Object getValueAt(Object row, int col) {
        NCTreeTableNode node = (NCTreeTableNode)row;
        try {
            switch (col) {
                case 0: {
                    return node.getName();
                }
                case 1: {
                    return node.getLongName();
                }
                case 2: {
                    if (!(node instanceof NCVariable)) {
                        return "-";
                    }
                    switch (((NCVariable)node).getPlottingType()) {
                        case 1: {
                            return "[lon][lat]";
                        }
                        case 2: {
                            return "[lon][lat][vert]";
                        }
                        case 3: {
                            return "[lat][vert]";
                        }
                    }
                    return "-";
                }
            }
        }
        catch (Exception ignore) {}
        return null;
    }

    public boolean isLeaf(Object node) {
        if (node == null) {
            return false;
        }
        return node instanceof NCVariable;
    }

    public boolean isRoot(Object node) {
        if (node == null) {
            return false;
        }
        return node instanceof NCDatasetList;
    }

    public boolean isCellEditable(Object node, int col) {
        if (node == null) {
            return false;
        }
        return col == 0;
    }

    public void addDataset(URL url) throws IOException {
        int index = ((NCDatasetList)this.root).add(url);
        if (index < 0) {
            throw new IOException("Negative index in dataset list!");
        }
        this.fireTreeNodesInserted(this, this.root.getPath(), new int[]{index}, this.root.getChildren());
    }

    public void removeDataset(NCTreeTableNode child) {
        if (!(child instanceof NCDataset)) {
            return;
        }
        int index = this.getIndexOfChild(this.root, child);
        try {
            NCTreeTableNode temp = ((NCDatasetList)this.root).remove(index);
            this.fireTreeNodesRemoved(this, this.root.getPath(), new int[]{index}, this.root.getChildren());
        }
        catch (Exception exc) {
            System.out.println("NCTreeTableModel.removeDataset : " + exc.toString());
        }
    }

    public void setValueAt(Object aValue, Object node, int col) {
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public boolean getListAllVariables() {
        return this.listAllVars;
    }

    public void setListAllVariables(boolean listAllVars) {
        this.listAllVars = listAllVars;
        ((NCDatasetList)this.root).setListAllVariables(listAllVars);
        int i = 0;
        while (i < this.getChildCount(this.root)) {
            NCTreeTableNode node = (NCTreeTableNode)this.getChild(this.root, i);
            ((NCDataset)node).setListAllVariables(listAllVars);
            this.fireTreeStructureChanged(this, node.getPath(), null, null);
            ++i;
        }
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = NCTreeTableModel.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = NCTreeTableModel.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$javax$swing$event$TreeModelListener == null ? NCTreeTableModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
            }
            i -= 2;
        }
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$javax$swing$event$TreeModelListener == null ? NCTreeTableModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
            }
            i -= 2;
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$javax$swing$event$TreeModelListener == null ? NCTreeTableModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
            }
            i -= 2;
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$javax$swing$event$TreeModelListener == null ? NCTreeTableModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
            }
            i -= 2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

