/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

public abstract class NCTreeTableNode {
    protected NCTreeTableNode parentTTNode = null;

    public NCTreeTableNode getParent() {
        return this.parentTTNode;
    }

    public void setParent(NCTreeTableNode newParent) {
        this.parentTTNode = newParent;
    }

    public NCTreeTableNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    public NCTreeTableNode[] getPathToRoot(NCTreeTableNode node, int depth) {
        NCTreeTableNode[] retNodes;
        if (node == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new NCTreeTableNode[depth];
        } else {
            retNodes = this.getPathToRoot(node.getParent(), ++depth);
            retNodes[retNodes.length - depth] = node;
        }
        return retNodes;
    }

    public NCTreeTableNode getRoot() {
        NCTreeTableNode[] ptr = this.getPath();
        if (ptr == null || ptr.length == 0) {
            return this;
        }
        return ptr[0];
    }

    public boolean isNodeAncestor(NCTreeTableNode anotherNode) {
        if (anotherNode == this || anotherNode == null) {
            return true;
        }
        NCTreeTableNode[] ptr = this.getPath();
        if (ptr == null) {
            return false;
        }
        int i = 0;
        while (i < ptr.length) {
            if (anotherNode == ptr[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public abstract Object getObject();

    public abstract String getName();

    public abstract String getLongName();

    public abstract String getDetail();

    public abstract int getChildCount();

    protected abstract Object[] getChildren();
}

