/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

public class JulianDate {
    protected static final boolean DEBUG = false;
    public static final int JPLAIN = 0;
    public static final int J2000 = 1;
    public static final int JMODIFIED = 2;
    public static final double MJD_0 = 2400000.5;
    public static final double JD_2000 = 2451545.0;
    public static final double JD_UNIX = 2440587.5;
    protected long unixMillis;
    protected double et2000;
    protected double jdTT;
    private double jdUTC;
    protected double delta2000;
    protected double utc2tt;

    public JulianDate() {
        this.calculate(System.currentTimeMillis());
    }

    public JulianDate(long t) {
        this.calculate(t);
    }

    public void setTime(long t) {
        this.calculate(t);
    }

    private void calculate(long t) {
        this.unixMillis = t;
        this.jdUTC = JulianDate.getJDate(t);
        this.delta2000 = this.jdUTC - 2451545.0;
        if (this.delta2000 < 0.0) {
            double jc2000 = this.delta2000 / 36525.0;
            double jc2000Squ = jc2000 * jc2000;
            this.utc2tt = 64.184 + 59.0 * jc2000 - 51.2 * jc2000Squ - 67.1 * jc2000 * jc2000Squ - 16.4 * jc2000Squ * jc2000Squ;
        } else {
            this.utc2tt = 64.184;
        }
        this.jdTT = this.jdUTC + this.utc2tt / 86400.0;
        this.delta2000 = this.jdTT - 2451545.0;
        double unixSecs = (double)this.unixMillis * 0.001;
        double utc2000Secs = unixSecs - 9.46728E8;
        this.et2000 = utc2000Secs + this.utc2tt;
    }

    public long getMillis() {
        return this.unixMillis;
    }

    public long getEphemerisSeconds() {
        return this.unixMillis;
    }

    public double getDelta2000() {
        return this.delta2000;
    }

    public double getJDate() {
        return this.jdUTC;
    }

    public double getJDate(int format) {
        if (format == 1) {
            return this.jdUTC - 2451545.0;
        }
        if (format == 2) {
            return this.jdUTC - 2400000.5;
        }
        return this.jdUTC;
    }

    public static double getJDate(long t) {
        return JulianDate.getJDate(t, 0);
    }

    public static double getJDate(long t, int format) {
        double julianDay = 2440587.5 + (double)t * 1.1574074074074074E-8;
        if (format == 1) {
            julianDay -= 2451545.0;
        } else if (format == 2) {
            julianDay -= 2400000.5;
        }
        return julianDay;
    }
}

